/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.species;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.Set;
import javax.swing.table.TableColumnModel;
import org.nuiton.i18n.I18n;

public class SpeciesBatchTableModel
extends AbstractTuttiTableModel<SpeciesBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId("speciesToConfirm", I18n.n_((String)"tutti.table.species.batch.header.toConfirm", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.toConfirm", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_BY_CODE = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.table.species.batch.header.speciesByCode", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.speciesByCode", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_BY_GENUS_CODE = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.table.species.batch.header.speciesByGenusCode", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.speciesByGenusCode", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SORTED_UNSORTED_CATEGORY = ColumnIdentifier.newId("sortedUnsortedCategory", I18n.n_((String)"tutti.table.species.batch.header.sortedUnsortedCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.sortedUnsortedCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT_CATEGORY = ColumnIdentifier.newId("weightCategory", I18n.n_((String)"tutti.table.species.batch.header.weightCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.weightCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SEX = ColumnIdentifier.newId("sex", I18n.n_((String)"tutti.table.species.batch.header.sex", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.sex", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> MATURITY = ColumnIdentifier.newId("maturity", I18n.n_((String)"tutti.table.species.batch.header.maturity", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.maturity", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> AGE = ColumnIdentifier.newId("age", I18n.n_((String)"tutti.table.species.batch.header.age", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.age", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId("weight", I18n.n_((String)"tutti.table.species.batch.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.weight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_WEIGHT = ColumnIdentifier.newId("computedWeight", I18n.n_((String)"tutti.table.species.batch.header.computedWeight", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.computedWeight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId("computedNumber", I18n.n_((String)"tutti.table.species.batch.header.computedNumber", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.computedNumber", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SAMPLE_WEIGHT = ColumnIdentifier.newId("sampleWeight", I18n.n_((String)"tutti.table.species.batch.header.sampleWeight", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.sampleWeight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SAMPLING_RATIO = ColumnIdentifier.newId("samplingRatio", I18n.n_((String)"tutti.table.species.batch.header.elevationRate", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.elevationRate", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId("comment", I18n.n_((String)"tutti.table.species.batch.header.comment", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.comment", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENTS = ColumnIdentifier.newId("attachments", I18n.n_((String)"tutti.table.species.batch.header.file", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.file", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> noneEditableColIfNoSpecies;

    public SpeciesBatchTableModel(TableColumnModel columnModel) {
        super(columnModel);
        this.setNoneEditableCols(SAMPLE_WEIGHT, SAMPLING_RATIO);
        this.noneEditableColIfNoSpecies = Sets.newHashSet();
        this.noneEditableColIfNoSpecies.add(COMPUTED_NUMBER);
        this.noneEditableColIfNoSpecies.add(COMPUTED_WEIGHT);
    }

    @Override
    protected SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel();
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName, SpeciesBatchRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        if (propertyName == SPECIES_BY_CODE) {
            this.fireTableCellUpdated(rowIndex, SPECIES_BY_GENUS_CODE, COMPUTED_NUMBER, COMPUTED_WEIGHT);
        } else if (propertyName == SPECIES_BY_GENUS_CODE) {
            this.fireTableCellUpdated(rowIndex, SPECIES_BY_CODE, COMPUTED_NUMBER, COMPUTED_WEIGHT);
        } else if (propertyName == COMPUTED_NUMBER) {
            this.fireTableCellUpdated(rowIndex, COMPUTED_WEIGHT);
        } else if (propertyName == COMPUTED_WEIGHT) {
            this.fireTableCellUpdated(rowIndex, COMPUTED_NUMBER);
        }
    }

    public void updateSamplingRatio(Set<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            int rowIndex = this.getRows().indexOf((Object)row);
            this.fireTableCellUpdated(rowIndex, SAMPLE_WEIGHT, SAMPLING_RATIO);
        }
    }

    @Override
    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result && this.noneEditableColIfNoSpecies.contains(propertyName)) {
            SpeciesBatchRowModel entry = (SpeciesBatchRowModel)((Object)this.getEntry(rowIndex));
            result = entry.getSpecies() != null;
        }
        return result;
    }
}

