/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public final class TuttiUIUtil {
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);

    private TuttiUIUtil() {
    }

    public static JDialog openInDialog(JComponent ui, JFrame frame, String title, Action closeAction) {
        return TuttiUIUtil.openInDialog(ui, frame, title, closeAction, null);
    }

    public static JDialog openInDialog(JComponent ui, JFrame frame, String title, Action closeAction, Dimension dim) {
        JDialog result = new JDialog((Frame)frame, false);
        result.setTitle(title);
        result.add(ui);
        result.setResizable(true);
        if (dim == null) {
            result.setSize(550, 450);
        } else {
            result.setSize(dim);
        }
        if (closeAction != null) {
            JRootPane rootPane = result.getRootPane();
            rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
            rootPane.getActionMap().put("close", closeAction);
        }
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
            }
        });
        SwingUtil.center((Component)frame, (Component)result);
        result.setVisible(true);
        return result;
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        File file = FileUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        File result = file == null ? incoming : file;
        return result;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        String file = FileUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        return file == null ? incoming : new File(file);
    }

    public static void updateBusyState(Component ui, boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ui.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ui.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void showSuccessMessage(Component ui, String message) {
        JOptionPane.showMessageDialog(ui, message, "Success", 1, UIManager.getIcon("info"));
    }

    public static void showErrorMessage(Component ui, String message) {
        JOptionPane.showMessageDialog(ui, message, "Error", 0, UIManager.getIcon("error"));
    }

    public static boolean askQuestion(Component ui, String message) {
        int i = JOptionPane.showConfirmDialog(ui, message, "Question?", 0);
        return i == 0;
    }
}

