package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.BeaufortScaleBean;
import fr.ifremer.tutti.persistence.entities.SeaStateBean;
import fr.ifremer.tutti.persistence.entities.StrataBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FishesTabUI extends JPanel implements TuttiUI<FishesTabUIModel, FishesTabUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SAMPLE_VRAC_WEIGHT_FIELD_MODEL = "sampleVracWeightField.model";
    public static final String BINDING_SAMPLE_VRAC_WEIGHT_FIELD_NUMBER_PATTERN = "sampleVracWeightField.numberPattern";
    public static final String BINDING_TOTAL_HORS_VRAC_WEIGHT_FIELD_MODEL = "totalHorsVracWeightField.model";
    public static final String BINDING_TOTAL_HORS_VRAC_WEIGHT_FIELD_NUMBER_PATTERN = "totalHorsVracWeightField.numberPattern";
    public static final String BINDING_TOTAL_VRAC_WEIGHT_FIELD_MODEL = "totalVracWeightField.model";
    public static final String BINDING_TOTAL_VRAC_WEIGHT_FIELD_NUMBER_PATTERN = "totalVracWeightField.numberPattern";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_MODEL = "totalWeightField.model";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "totalWeightField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRQeGzuJ4xaHhgYjEhpIVTlCWpcDSJAADWndOHJCFLulwocw3h3bW83+YGa22SgC8SdwhRPcuSBx44Q4cObABfEvIMSBa8Wb2fWu117LTkmkrLwz733zvvfefG+//wvlOUOvPca+rzHPFqZFtP2dR48+6jwmurhLuM5MVzgMBX+ZLMq2UdGI1rlAG+2GdK+G7tVdx3Idm9hD3lsNtMjFGSW8T4gQaC3poXNebUbbW77rsQFqFFQa6rf//J39yvjyuyxCvgvRLQGV9WleMZNcA2VNQ6BrcNITXKXY7kEYzLR7EO9VubZLMeeH2CKfoS/QfAPNuZgBmECvz05ZYSh/3xWo0HcscoRtQgV6q8s0s8uIRZgmPCFMzTM1fgrna7pjC4DTdCz0PuFazYTU8BbuPKi7rkKbE2i+j22DEibQ9jMh7QXuMWDecgwZ2LvPBHcgnWOwEmHMYbBDyUEAu50ozRNMTQNDpkLkpnw+HCweEM5xj8TuMXAh8hTojQtAxgi5rsMsgcoJ58BFHSjNCpH1DeEITD8mZq8vWvLnQ4b14LWBO5LYNdkrfoiwrxalbzmCWLi5r2p+e9RWrSZtl4aOq5mEQoPeSgmUGKYkeuhZHcLuqRcJ8GqE86JIxqqw5N5G0q7CseVSEhsqjntwtUd4Svu1dF5vyvf15N71UdxkAJXIsCzGD5xkWxKyPk2dOZTKkwV6KZHPeCdZw7zyG81+VGzNBeV4JZFl0CQt1qRYNDJtlGceLEPg7XEZO4atQMDKIwImAdXu05Xl33/688faQLWKcPb1VNMh0QU1cZnjwmU35dGlQLI8YdLqAXa32qjACQXFVoq8mhJYM9yG4OC8F6S7Jt21Pcz7AJGf/+PnX1Y+/e05lK2hRepgo4alfR0VRJ9BFhxq+O4Hd1REV04XpNzCfw5uU4dgG9ToXKnH53BBsSecI8f1QO+q56FIaT0idh27a/Yqm5rJdwYmww1c2ZTecNTpMeFyTuQE8yD5JbmkrD8ENQIFQrcnwDbBcBgxsAdcHyqymlKRKC2dwq//Ljd/uDOoSgay9PJE87gy+U/QnGlT0yZqmoSDInV6FF1OPMOJB0LaiECQtCvDFELZekc93xsrQEZmifiQrFuBVFN5V7XJmuV7Eui+oih/1dF0iXNnDqI6HMQMypIWzcyKNC2sXDzSykF3ynZpxVxVw121VbaPsBCEQW+tnNcPWydvn9yt36+3midHO63WveNDMFzwOKnBzQCa+S6m0KFoIbyUZwIVh3KYxmpM1y8Q/epI9HEeLpNBSUzvlNSpcgEmazGT5kiVL5PK0mgLpXFJn1AXILM+UpZki14mn+WUGZlGaeIsncYqG7PaOA80VV5o+HjySCX+CtN0KVWSWFF3qGfZ4afdZrrPbmwz8EyLOpjOM4jMHMVnDggMen4bPunwese0DZjk74+BZuRzcSqiXP5aPr5JR7jxvxE2AeE/vSgR2GUNAAA=";
    private static final Log log = LogFactory.getLog(FishesTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SwingValidatorMessageTableModel errorTableModel;
    protected Table form;
    protected FishesTabUIHandler handler;
    protected FishesTabUI homePanel = this;
    protected FishesTabUIModel model;
    protected NumberEditor sampleVracWeightField;
    protected JLabel sampleVracWeightTotalHorsVracWeightLabel;
    protected JTable table;
    protected JScrollPane tableScrollPane;
    protected NumberEditor totalHorsVracWeightField;
    protected NumberEditor totalVracWeightField;
    protected NumberEditor totalWeightField;
    protected JLabel totalWeightTotalVracWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<FishesTabUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void selectTrait(TraitBean trait) { handler.selectTrait(trait); }
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishesTabUI(CatchesUI parentUI) {
        FishesTabUIHandler handler = new FishesTabUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishesTabUI() {
        $initialize();
    }

    public FishesTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishesTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishesTabUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishesTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishesTabUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishesTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishesTabUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public Table getForm() {
        return form;
    }

    public FishesTabUIHandler getHandler() {
        return handler;
    }

    public FishesTabUIModel getModel() {
        return model;
    }

    public NumberEditor getSampleVracWeightField() {
        return sampleVracWeightField;
    }

    public JLabel getSampleVracWeightTotalHorsVracWeightLabel() {
        return sampleVracWeightTotalHorsVracWeightLabel;
    }

    public JTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public NumberEditor getTotalHorsVracWeightField() {
        return totalHorsVracWeightField;
    }

    public NumberEditor getTotalVracWeightField() {
        return totalVracWeightField;
    }

    public NumberEditor getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightTotalVracWeightLabel() {
        return totalWeightTotalVracWeightLabel;
    }

    public SwingValidator<FishesTabUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(totalWeightTotalVracWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(sampleVracWeightTotalHorsVracWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishesTabUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishesTabUIModel.class));
    }

    protected void createSampleVracWeightField() {
        $objectMap.put("sampleVracWeightField", sampleVracWeightField = new NumberEditor(this));
        
        sampleVracWeightField.setName("sampleVracWeightField");
        sampleVracWeightField.setProperty("sampleVracWeight");
        sampleVracWeightField.setUseFloat(false);
        sampleVracWeightField.setShowReset(true);
    }

    protected void createSampleVracWeightTotalHorsVracWeightLabel() {
        $objectMap.put("sampleVracWeightTotalHorsVracWeightLabel", sampleVracWeightTotalHorsVracWeightLabel = new JLabel());
        
        sampleVracWeightTotalHorsVracWeightLabel.setName("sampleVracWeightTotalHorsVracWeightLabel");
        sampleVracWeightTotalHorsVracWeightLabel.setText(_("tutti.label.sampleVracWeightTotalHorsVracWeight"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JTable());
        
        table.setName("table");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTotalHorsVracWeightField() {
        $objectMap.put("totalHorsVracWeightField", totalHorsVracWeightField = new NumberEditor(this));
        
        totalHorsVracWeightField.setName("totalHorsVracWeightField");
        totalHorsVracWeightField.setProperty("totalHorsVracWeight");
        totalHorsVracWeightField.setUseFloat(false);
        totalHorsVracWeightField.setShowReset(true);
    }

    protected void createTotalVracWeightField() {
        $objectMap.put("totalVracWeightField", totalVracWeightField = new NumberEditor(this));
        
        totalVracWeightField.setName("totalVracWeightField");
        totalVracWeightField.setProperty("totalVracWeight");
        totalVracWeightField.setUseFloat(false);
        totalVracWeightField.setShowReset(true);
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new NumberEditor(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setProperty("totalWeight");
        totalWeightField.setUseFloat(false);
        totalWeightField.setShowReset(true);
    }

    protected void createTotalWeightTotalVracWeightLabel() {
        $objectMap.put("totalWeightTotalVracWeightLabel", totalWeightTotalVracWeightLabel = new JLabel());
        
        totalWeightTotalVracWeightLabel.setName("totalWeightTotalVracWeightLabel");
        totalWeightTotalVracWeightLabel.setText(_("tutti.label.totalWeightTotalVracWeight"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(FishesTabUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(totalWeightField);
        $JPanel0.add(totalVracWeightField);
        // inline complete setup of $JPanel1
        $JPanel1.add(sampleVracWeightField);
        $JPanel1.add(totalHorsVracWeightField);
        addChildrenToTableScrollPane();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        totalWeightField.setBean(model);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalVracWeightField.setBean(model);
        totalVracWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalVracWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        sampleVracWeightField.setBean(model);
        sampleVracWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        sampleVracWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalHorsVracWeightField.setBean(model);
        totalHorsVracWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalHorsVracWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setModel(getContextValue(TableModel.class));
        table.setColumnModel(getContextValue(TableColumnModel.class));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createForm();
        createTotalWeightTotalVracWeightLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createTotalWeightField();
        createTotalVracWeightField();
        createSampleVracWeightTotalHorsVracWeightLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createSampleVracWeightField();
        createTotalHorsVracWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setModel(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_VRAC_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalVracWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalVracWeightField.setModel(model.getTotalVracWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalVracWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_VRAC_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalVracWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_VRAC_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleVracWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleVracWeightField.setModel(model.getSampleVracWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleVracWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAMPLE_VRAC_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                sampleVracWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_HORS_VRAC_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalHorsVracWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalHorsVracWeightField.setModel(model.getTotalHorsVracWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalHorsVracWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_HORS_VRAC_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalHorsVracWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}