/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.interval;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Observable;

public class Interval
extends Observable
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 245693725840885583L;
    private int min = 0;
    private int max = 100;
    private int first = 25;
    private int last = 75;

    public Interval(int first, int last) {
        this.init(this.min, this.max, first, last);
    }

    public Interval() {
        this.init(this.min, this.max, this.first, this.last);
    }

    private void init(int min, int max, int first, int last) {
        this.min = min;
        this.max = max;
        this.first = first;
        this.last = last;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        if (this.min != min) {
            this.min = min;
            this.setChanged();
            this.notifyObservers("min");
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (this.max != max) {
            this.max = max;
            this.setChanged();
            this.notifyObservers("max");
        }
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int v) {
        int lv = Math.min(this.max, v);
        if (this.first != lv) {
            this.first = lv;
            this.setChanged();
            this.notifyObservers("first");
        }
    }

    public int getLast() {
        return this.last;
    }

    public void setLast(int v) {
        int lv = Math.max(this.min, v);
        if (this.last != lv) {
            this.last = lv;
            this.setChanged();
            this.notifyObservers("last");
        }
    }

    public void move(int decal) {
        int first = this.first + decal;
        while (first < this.getMin()) {
            first = this.getMax() - this.getMin() + first + 1;
        }
        if (first > this.getMax()) {
            first %= this.getMax() + 1;
        }
        int last = this.last + decal;
        while (last < this.getMin()) {
            last = this.getMax() - this.getMin() + last + 1;
        }
        if (last > this.getMax()) {
            last %= this.getMax() + 1;
        }
        if (this.first != first || this.last != last) {
            this.first = first;
            this.last = last;
            this.setChanged();
            this.notifyObservers("first,last");
        }
    }

    public boolean contains(int integerToCheck) {
        if (this.getFirst() <= this.getLast()) {
            return this.getFirst() <= integerToCheck && integerToCheck <= this.getLast();
        }
        boolean result = this.getMin() <= integerToCheck && integerToCheck <= this.getLast() || this.getFirst() <= integerToCheck && integerToCheck <= this.getMax();
        return result;
    }

    public int getNbElem() {
        if (this.getFirst() <= this.getLast()) {
            return this.getLast() - this.getFirst() + 1;
        }
        return this.getMax() - this.getFirst() + (this.getLast() - this.getMin()) + 2;
    }

    public String toString() {
        return this.getFirst() + " - " + this.getLast();
    }

    public Iterator<Integer> iterator() {
        return new IntervalIterator(this.getMin(), this.getMax(), this.getFirst(), this.getLast());
    }

    public boolean equals(Object o) {
        if (o instanceof Interval) {
            Interval i = (Interval)o;
            return i.min == this.min && i.max == this.max && i.first == this.first && i.last == this.last;
        }
        return false;
    }

    public Interval clone() {
        Interval result = new Interval();
        result.setFirst(this.getFirst());
        result.setLast(this.getLast());
        result.setMax(this.getMax());
        result.setMin(this.getMin());
        return result;
    }

    public static class IntervalIterator
    implements Iterator<Integer> {
        private int max;
        private int first;
        private int last;
        private int current;

        public IntervalIterator(int min, int max, int first, int last) {
            this.max = max;
            this.first = first;
            this.last = last;
            this.current = this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current % (this.max + 1) != (this.last + 1) % (this.max + 1) || this.current == this.first;
        }

        public int nextInt() {
            return this.current++ % (this.max + 1);
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

