/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.types;

import fr.ifremer.isisfish.types.Month;
import java.io.Serializable;
import org.nuiton.i18n.I18n;

public class TimeStep
implements Cloneable,
Serializable,
Comparable<TimeStep> {
    private static final long serialVersionUID = 1L;
    protected int step = 0;

    public TimeStep() {
    }

    public TimeStep(int step) {
        this.step = step;
    }

    @Override
    public int compareTo(TimeStep t) {
        if (this.before(t)) {
            return -1;
        }
        if (this.after(t)) {
            return 1;
        }
        return 0;
    }

    public int getYear() {
        return this.step / 12;
    }

    public Month getMonth() {
        int tmp;
        for (tmp = this.step; tmp < 0; tmp += 12) {
        }
        Month result = Month.MONTH[tmp % 12];
        return result;
    }

    @Deprecated
    public int getDate() {
        return this.step;
    }

    public int getStep() {
        return this.step;
    }

    public TimeStep add(int number) {
        return new TimeStep(this.step + number);
    }

    public TimeStep minus(int number) {
        return new TimeStep(this.step - number);
    }

    public int gap(TimeStep other) {
        return this.step - other.step;
    }

    public TimeStep next() {
        return new TimeStep(this.step + 1);
    }

    public TimeStep previous() {
        return new TimeStep(this.step - 1);
    }

    public TimeStep nextYear() {
        return new TimeStep(this.step + 12);
    }

    public TimeStep previousYear() {
        return new TimeStep(this.step - 12);
    }

    public boolean before(TimeStep t) {
        return this.step < t.step;
    }

    public boolean beforeOrEquals(TimeStep t) {
        return this.step <= t.step;
    }

    public boolean after(TimeStep t) {
        return this.step > t.step;
    }

    public boolean afterOrEquals(TimeStep d) {
        return this.step >= d.step;
    }

    public boolean equals(Object o) {
        if (o instanceof TimeStep) {
            return this.step == ((TimeStep)o).step;
        }
        return false;
    }

    public int hashCode() {
        return this.step;
    }

    public Month[] getMonthBetweenDate(TimeStep timeStep2) {
        if (timeStep2.getStep() - this.getStep() < 0) {
            return new Month[0];
        }
        Month[] result = new Month[timeStep2.getStep() - this.getStep()];
        Month month = this.getMonth();
        for (int i = 0; i < result.length; ++i) {
            result[i] = month = month.next();
        }
        return result;
    }

    public String toString() {
        String result = I18n.t((String)"isisfish.date.toString", (Object[])new Object[]{this.getMonth(), this.getYear()});
        return result;
    }
}

