/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.ReverseFileReader;
import scripts.ResultName;

public class SensitivitySpawningBiomassRelativeReferenceY11
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivitySpawningBiomassRelativeReferenceY11.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_BIOMASS};
    @Doc(value="Population")
    public Population param_pop;
    @Doc(value="URL of the Biomasses.csv reference export file")
    public String param_referenceBiomassCSV = "";

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        ResultStorage resultStorage = simulation.getResultStorage();
        TimeStep lastStep = resultStorage.getLastStep();
        TimeStep firstStep = new TimeStep(11);
        double biomass = 0.0;
        double firstbiomass = 0.0;
        double biomassReference = 0.0;
        double firstBiomassReference = 0.0;
        File referenceFile = new File(this.param_referenceBiomassCSV);
        TopiaContext tx = simulation.getStorage().beginTransaction();
        Population tempPop = (Population)tx.findByTopiaId(this.param_pop.getTopiaId());
        List groups = tempPop.getPopulationGroup();
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (PopulationGroup group : groups) {
            map.put(group.getId(), group.getMaturityOgive());
        }
        tx.closeContext();
        ReverseFileReader reader = new ReverseFileReader(referenceFile);
        String line = reader.readLine();
        line = reader.readLine();
        String lastMonth = "";
        while (line != null) {
            String[] items = line.split(";");
            if ("".equals(lastMonth)) {
                lastMonth = items[3];
            }
            if (items[0].equals(this.param_pop.getName()) && items[3].equals(lastMonth)) {
                biomassReference += Double.parseDouble(items[4]) * (Double)map.get(Integer.parseInt(items[1]));
            }
            if (items[0].equals(this.param_pop.getName()) && items[3].equals("11")) {
                firstBiomassReference += Double.parseDouble(items[4]) * (Double)map.get(Integer.parseInt(items[1]));
            }
            line = reader.readLine();
        }
        reader.close();
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            MatrixND matfirstdate = resultStorage.getMatrix(pop, ResultName.MATRIX_BIOMASS);
            MatrixIterator i = matfirstdate.iterator();
            while (i.hasNext()) {
                i.next();
                Object[] sems = i.getSemanticsCoordinates();
                PopulationGroup group = (PopulationGroup)sems[1];
                TimeStep step = (TimeStep)sems[0];
                if (!step.equals((Object)firstStep)) continue;
                firstbiomass += i.getValue() * group.getMaturityOgive();
            }
            MatrixND matlastdate = resultStorage.getMatrix(pop, ResultName.MATRIX_BIOMASS);
            MatrixIterator i2 = matlastdate.iterator();
            while (i2.hasNext()) {
                i2.next();
                Object[] sems = i2.getSemanticsCoordinates();
                PopulationGroup group = (PopulationGroup)sems[1];
                TimeStep step = (TimeStep)sems[0];
                if (!step.equals((Object)lastStep)) continue;
                biomass += i2.getValue() * group.getMaturityOgive();
            }
        }
        out.write(Double.toString(biomass / firstbiomass / (biomassReference / firstBiomassReference)));
    }

    public String getDescription() {
        return "Biomass of the genitors for the last time step. Biomass is the sum on the groups and zones";
    }

    public String getExportFilename() {
        return "SensitivitySpawningBiomassRelativeReferenceY11_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

