/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.types.RDataFrame;

public class Sobol
extends AbstractSensitivityAnalysis {
    @Doc(value="the size of the 2 random samples")
    public int param_n = 20;
    @Doc(value="the number of bootstrap replicates.")
    public int param_nboot = 20;
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;

    public boolean canManageCardinality() {
        return true;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        this.setIsisFactorsR(plan, outputDirectory);
        int factorNumber = plan.getFactors().size();
        List factors = plan.getFactors();
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        List thisExperimentScenarios = thisExperiment.getScenarios();
        this.checkAllFactorContinuous(factors);
        String rInstruction = "isis.methodAnalyse<-sobol2002(model=NULL,X1=X1,X2=X2,nboot=%s)";
        String rCall = String.format(rInstruction, this.param_nboot);
        if (this.param_modifR) {
            rCall = this.editRInstruction(rCall);
        }
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(sensitivity)");
            String x = "<-data.frame(matrix(c(";
            int i = 0;
            while (i < factorNumber) {
                x = String.valueOf(x) + "runif(" + this.param_n + "),";
                ++i;
            }
            x = StringUtils.removeEnd((String)x, (String)",");
            x = String.valueOf(x) + "),nrow=" + this.param_n + "))";
            engine.voidEval("X1" + x);
            engine.voidEval("X2" + x);
            engine.voidEval(rCall);
            rInstruction = "factornames<-c(";
            i = 0;
            while (i < factorNumber) {
                String factorName = ((Factor)factors.get(i)).getName();
                rInstruction = i != factorNumber - 1 ? String.valueOf(rInstruction) + "\"" + factorName + "\"," : String.valueOf(rInstruction) + "\"" + factorName + "\"";
                ++i;
            }
            rInstruction = String.valueOf(rInstruction) + ")";
            engine.voidEval(rInstruction);
            RDataFrame dataFrame = (RDataFrame)engine.eval("isis.methodAnalyse$X");
            dataFrame.setVariable("isis.methodAnalyse$X");
            int nbExperiments = dataFrame.dim()[0];
            engine.voidEval(this.getIsisFactorDistribution(factors));
            engine.voidEval("call<-isis.methodAnalyse$call");
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-data.frame(isis.methodAnalyse$X)");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            int j = 0;
            while (j < nbExperiments) {
                Scenario experimentScenario = new Scenario();
                int i2 = 0;
                while (i2 < factorNumber) {
                    Factor factor = (Factor)plan.getFactors().get(i2);
                    Double dFValue = (Double)dataFrame.get(i2, j);
                    factor.setValueForIdentifier((Object)dFValue);
                    experimentScenario.addFactor(factor);
                    ++i2;
                }
                thisExperimentScenarios.add(experimentScenario);
                ++j;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)e);
        }
        thisExperiment.setScenarios(thisExperimentScenarios);
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        SimulationStorage firstStorage = simulationStorages.get(0);
        SimulationParameter param = firstStorage.getParameter();
        int sensitivityNumber = param.getSensitivityExport().size();
        String simulationName = outputDirectory.getName().replaceAll("-", "");
        try {
            SensitivityExport sensitivityExport;
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(sensitivity)");
            engine.voidEval("names(X1)<-factornames");
            engine.voidEval("names(X2)<-factornames");
            engine.voidEval("names(a$X)<-factornames");
            int k = 0;
            while (k < sensitivityNumber) {
                sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + sensitivityExport.getExportFilename() + ")");
                ++k;
            }
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("attr(isis.simule,\"call\")<-isis.methodExp$call");
            k = 0;
            while (k < sensitivityNumber) {
                sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String name = sensitivityExport.getExportFilename();
                engine.voidEval("tell(a,y=" + name + ")");
                engine.voidEval("row.names(isis.methodAnalyse$S)<-names(isis.methodAnalyse$X)");
                engine.voidEval("row.names(isis.methodAnalyse$T)<-names(isis.methodAnalyse$X)");
                engine.voidEval("row.names(isis.methodAnalyse$V)<-c(\"global\",names(isis.methodAnalyse$X),paste(\"-\",names(isis.methodAnalyse$X),sep=\"\"))");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(simulationName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.factors\"=isis.factors," + "\"isis.factor.distribution\"=isis.factor.distribution," + "\"isis.simule\"=isis.simule," + "call_method=\"tell(a,y=" + name + ")" + "\"," + "\"analysis_result\"=a)");
                engine.voidEval("attr(" + exportMethodAnalyse + "," + "\"nomModel\")<-\"isis-fish-externe-R\")");
                engine.voidEval("dfresults<-data.frame(isis.methodAnalyse$X,isis.methodAnalyse$y)");
                engine.setwd(outputDirectory);
                engine.voidEval("write.csv(isis.methodAnalyse$V,\"" + name + "_SensitivityIndices.csv\")");
                engine.voidEval("write.csv(isis.methodAnalyse$D,\"" + name + "_D.csv\")");
                engine.voidEval("write.csv(isis.methodAnalyse$S,\"" + name + "_S.csv\")");
                engine.voidEval("write.csv(dfresults,\"" + name + "_Results.csv\")");
                ++k;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't evaluate results", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Implementation of Sobol method using R (use of the R sobol2002 method, needs the 'sensitivity' package to work)";
    }
}

