/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.List;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;

public class RegularFractions
extends AbstractSensitivityAnalysis {
    @Doc(value="the path of the directory where the R function is stored (do not indicate the RegularFractions.R file name)")
    public String param_pathToFunction = "";
    @Doc(value="unique prime number of levels of all input and unit factors")
    public int param_p = 2;
    @Doc(value="number of unit factors (so that there are N=p^r units)")
    public int param_r = 2;
    @Doc(value="resolution of the fraction")
    public int param_resolution = 2;
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;

    public boolean canManageCardinality() {
        return true;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        this.setIsisFactorsR(plan, outputDirectory);
        int factorNumber = plan.getFactors().size();
        List factors = plan.getFactors();
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        List thisExperimentScenarios = thisExperiment.getScenarios();
        String factorNames = "";
        this.checkAllFactorContinuous(factors);
        int i = 0;
        while (i < factorNumber) {
            if (i != 0) {
                factorNames = String.valueOf(factorNames) + ",";
            }
            factorNames = String.valueOf(factorNames) + "\"" + ((Factor)factors.get(i)).getName() + "\"";
            ++i;
        }
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.clearSession();
            engine.loadRData(outputDirectory.getParentFile(), outputDirectory.getName());
            engine.setwd(new File(this.param_pathToFunction));
            engine.voidEval("source(\"regularfractions.R\")");
            String rInstruction = "isis.methodAnalyse<-regular.fraction(%s,%s,%s,%s)";
            String rCall = String.format(rInstruction, factors.size(), this.param_p, this.param_r, this.param_resolution);
            if (this.param_modifR) {
                rCall = this.editRInstruction(rCall);
            }
            engine.voidEval(rCall);
            engine.voidEval("call<-\"" + rCall + "\"");
            rInstruction = "factornames<-c(%s)";
            rCall = String.format(rInstruction, factorNames);
            engine.voidEval(rCall);
            engine.eval("expPlan<-as.data.frame(isis.methodAnalyse[[1]])");
            RDataFrame dataFrame = (RDataFrame)engine.eval("expPlan");
            dataFrame.setVariable("expPlan");
            int simulationNumber = (Integer)engine.eval("length(isis.methodAnalyse[[1]][,1])");
            int j = 0;
            while (j < simulationNumber) {
                Scenario experimentScenario = new Scenario();
                int i2 = 0;
                while (i2 < factors.size()) {
                    Factor factor = (Factor)plan.getFactors().get(i2);
                    factor.setValueForIdentifier(dataFrame.get(i2, j));
                    experimentScenario.addFactor(factor);
                    ++i2;
                }
                thisExperimentScenarios.add(experimentScenario);
                thisExperiment.setScenarios(thisExperimentScenarios);
                ++j;
            }
            String dataframe = "data<-data.frame(";
            int j2 = 0;
            while (j2 < factorNumber) {
                Factor factor = (Factor)factors.get(j2);
                String factorName = factor.getName().replaceAll(" ", "");
                String vector = String.valueOf(factorName) + "<-c(";
                int i3 = 0;
                while (i3 < simulationNumber) {
                    Scenario scenario = (Scenario)thisExperimentScenarios.get(i3);
                    List newFactors = scenario.getFactors();
                    Factor factor1 = (Factor)newFactors.get(j2);
                    vector = i3 < simulationNumber - 1 ? String.valueOf(vector) + factor1.getDisplayedValue() + "," : String.valueOf(vector) + factor1.getDisplayedValue();
                    ++i3;
                }
                vector = String.valueOf(vector) + ")";
                engine.voidEval(vector);
                dataframe = j2 < factorNumber - 1 ? String.valueOf(dataframe) + factorName + "=factor(" + factorName + ")," : String.valueOf(dataframe) + factorName + "=factor(" + factorName + "))";
                ++j2;
            }
            engine.voidEval(dataframe);
            engine.voidEval(this.getIsisFactorDistribution(factors));
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-data.frame(data)");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            this.closeEngine(engine, outputDirectory);
        }
        catch (RException eee) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)eee);
        }
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        SimulationStorage firstStorage = simulationStorages.get(0);
        SimulationParameter param = firstStorage.getParameter();
        List exports = param.getSensitivityExport();
        int sensitivityNumber = exports.size();
        String simulationName = outputDirectory.getName().replaceAll("-", "");
        try {
            REngine engine = this.openEngine(outputDirectory);
            int factorNumber = (Integer)engine.eval("dim(isis.simule)[2]");
            int k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + sensitivityExport.getExportFilename() + ")");
                ++k;
            }
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            for (SensitivityExport export : exports) {
                String name = export.getExportFilename();
                String dataFrame = "dataforaov<-data.frame(isis.simule," + name + "=" + name + ")";
                engine.voidEval(dataFrame);
                String aovCall = "aovresult<-aov(" + name + "~(";
                int j = 0;
                while (j < factorNumber) {
                    if (j < factorNumber - 1) {
                        aovCall = String.valueOf(aovCall) + engine.eval("names(isis.simule)[" + (j + 1) + "]") + "+";
                    } else {
                        aovCall = String.valueOf(aovCall) + engine.eval("names(isis.simule)[" + (j + 1) + "]") + ")";
                        aovCall = this.param_resolution <= 4 ? String.valueOf(aovCall) + ",data=dataforaov)" : String.valueOf(aovCall) + "^2,data=dataforaov)";
                    }
                    ++j;
                }
                engine.voidEval(aovCall);
                engine.voidEval("SoS<-summary(aovresult)[[1]][1:dim(summary(aovresult)[[1]])[1],2]");
                engine.voidEval("names(SoS)<-dimnames(summary(aovresult)[[1]])[[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("IndSensibilite<-SoS/sum(SoS)");
                engine.voidEval("exportsensitivity<-data.frame(SoS[1:dim(summary(aovresult)[[1]])[1]],IndSensibilite[1:dim(summary(aovresult)[[1]])[1]])");
                engine.voidEval("names(exportsensitivity)<-c(\"Sum Of Squares\",\"Sensitivity indices\")");
                engine.voidEval("row.names(exportsensitivity)<-dimnames(summary(aovresult)[[1]])[1][[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("resultsnames<-c(isis.factor.distribution$NomFacteur,\"Result\")");
                engine.voidEval("names(dataforaov)<-isis.factor.distribution$NomFacteur");
                engine.setwd(outputDirectory);
                engine.voidEval("write.csv(dataforaov,\"" + name + "_Results.csv\")");
                engine.voidEval("write.csv(exportsensitivity,\"" + name + "_SensitivityIndices.csv\")");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(simulationName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.factors\"=isis.factors," + "\"isis.factor.distribution\"=isis.factor.distribution," + "\"isis.simule\"=isis.simule," + "\"call_method\"=\"" + aovCall + "\"," + "\"analysis_result\"=list(aovresult,IndSensibilite))");
                engine.voidEval("attr(" + exportMethodAnalyse + "," + "\"nomModel\")<-\"isis-fish-externe-R\"");
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception eee) {
            throw new SensitivityException("Can't evaluate results", (Throwable)eee);
        }
    }

    public String getDescription() {
        return "Implementation of Regular fractions method using R";
    }
}

