/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import scripts.ResultName;
import scripts.SiMatrix;

public class GravityModel {
    private static Log log = LogFactory.getLog(GravityModel.class);
    protected SimulationContext context = null;
    protected TopiaContext db = null;
    protected SiMatrix siMatrix = null;
    protected ResultStorage resultManager = null;

    public static GravityModel getGravityModel(SimulationContext context) {
        GravityModel result = (GravityModel)context.getValue(GravityModel.class.getName());
        return result;
    }

    private static void setGravityModel(SimulationContext context, GravityModel gravityModel) {
        context.setValue(GravityModel.class.getName(), (Object)gravityModel);
    }

    public GravityModel(SimulationContext context, SiMatrix siMatrix) throws TopiaException, StorageException {
        this.context = context;
        this.db = context.getDB();
        this.resultManager = context.getSimulationStorage().getResultStorage();
        this.siMatrix = siMatrix;
        GravityModel.setGravityModel(context, this);
    }

    public MatrixND matrixFishingTimePerMonthPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_FISHING_TIME_PER_MONTH_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.fishingTimePerMonthPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double fishingTimePerMonthPerVessel(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        double timePerTrip = this.siMatrix.fishingTimePerTrip(str, metier, step);
        double nbTrip = str.getStrategyMonthInfo(month).getNumberOfTrips();
        return timePerTrip * nbTrip;
    }

    public MatrixND matrixFuelCostsOfTravelPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_FUEL_COSTS_OF_TRAVEL_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.fuelCostsOfTravelPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double fuelCostsOfTravelPerVessel(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        double nbTrip = str.getStrategyMonthInfo(month).getNumberOfTrips();
        Collection zone = metier.getMetierSeasonInfo(month).getZone();
        double travelTime = this.siMatrix.travelTimePerTrip(str.getSetOfVessels(), zone);
        double unitFuelCost = str.getSetOfVessels().getVesselType().getUnitFuelCostOfTravel();
        return nbTrip * travelTime * unitFuelCost;
    }

    public MatrixND matrixCostsOfFishingPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_COSTS_OF_FISHING_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.costsOfFishingPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double costsOfFishingPerVessel(Strategy str, Metier metier, TimeStep step) {
        double fishingTime = this.fishingTimePerMonthPerVessel(str, metier, step);
        EffortDescription effort = str.getSetOfVessels().getPossibleMetiers(metier);
        int nbOperation = 0;
        double unitCostOfFishing = 0.0;
        if (effort != null) {
            nbOperation = effort.getFishingOperation();
            unitCostOfFishing = effort.getUnitCostOfFishing();
        }
        return fishingTime * ((double)nbOperation * unitCostOfFishing / 24.0);
    }

    public MatrixND matrixFuelCostsPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_FUEL_COSTS_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.fuelCostsPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double fuelCostsPerVessel(Strategy str, Metier metier, TimeStep step) {
        double fuelCosts = this.fuelCostsOfTravelPerVessel(str, metier, step);
        double costsOfFishing = this.costsOfFishingPerVessel(str, metier, step);
        return fuelCosts + costsOfFishing;
    }

    public MatrixND matrixRepairAndMaintenanceGearCostsPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_REPAIR_AND_MAINTENANCE_GEAR_COSTS_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.repairAndMaintenanceGearCostsPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double repairAndMaintenanceGearCostsPerVessel(Strategy str, Metier metier, TimeStep step) {
        double fishingTime = this.fishingTimePerMonthPerVessel(str, metier, step);
        EffortDescription effort = str.getSetOfVessels().getPossibleMetiers(metier);
        double repair = 0.0;
        if (effort != null) {
            repair = effort.getRepairAndMaintenanceGearCost();
        }
        return fishingTime * repair / 24.0;
    }

    public MatrixND matrixOtherRunningCostsPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_OTHER_RUNNING_COSTS_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.otherRunningCostsPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double otherRunningCostsPerVessel(Strategy str, Metier metier, TimeStep step) {
        double fishingTime = this.fishingTimePerMonthPerVessel(str, metier, step);
        EffortDescription effort = str.getSetOfVessels().getPossibleMetiers(metier);
        double otherCosts = 0.0;
        if (effort != null) {
            otherCosts = effort.getOtherRunningCost();
        }
        return fishingTime * otherCosts / 24.0;
    }

    public MatrixND matrixSharedNotFixedCostsPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_SHARED_NOT_FIXED_COSTS_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.sharedNotFixedCostsPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double sharedNotFixedCostsPerVessel(Strategy str, Metier metier, TimeStep step) {
        double fuelCostsPerVessel = this.fuelCostsPerVessel(str, metier, step);
        double otherRunningCostsPerVessel = this.otherRunningCostsPerVessel(str, metier, step);
        return fuelCostsPerVessel + otherRunningCostsPerVessel;
    }

    public MatrixND matrixGrossValueOfLandingsPerSpeciesPerStrategyMet(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        List<Population> pops = this.siMatrix.getPopulations(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_SPECIES_PER_STRATEGY_MET, new List[]{strategies, metiers, pops}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Populations", (Object[])new Object[0])});
        int p = 0;
        while (p < pops.size()) {
            Population pop = pops.get(p);
            int s = 0;
            while (s < strategies.size()) {
                Strategy str = strategies.get(s);
                metiers = this.siMatrix.getMetiers(str, step);
                int m = 0;
                while (m < metiers.size()) {
                    Metier metier = metiers.get(m);
                    double value = this.grossValueOfLandingsPerSpeciesPerStrategyMet(str, metier, pop, step);
                    result.setValue((Object)str, (Object)metier, (Object)pop, value);
                    ++m;
                }
                ++s;
            }
            ++p;
        }
        return result;
    }

    private double grossValueOfLandingsPerSpeciesPerStrategyMet(Strategy str, Metier metier, Population pop, TimeStep step) {
        List groups = pop.getPopulationGroup();
        double result = 0.0;
        for (PopulationGroup group : groups) {
            double price = group.getPrice();
            List zones = pop.getPopulationZone();
            for (Zone zone : zones) {
                double catchWeight = this.getCatchWeightPerStrMetPerZonePop(str, metier, group, zone, step);
                double discardsWeight = this.getDiscardsWeightPerStrMet(str, metier, group, zone, step);
                result += price * (catchWeight - discardsWeight);
            }
        }
        return result;
    }

    private double getCatchWeightPerStrMetPerZonePop(Strategy str, Metier metier, PopulationGroup group, Zone zone, TimeStep step) {
        MatrixND mat = this.resultManager.getMatrix(step, group.getPopulation(), ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP);
        double result = 0.0;
        if (mat != null) {
            result = mat.getValue((Object)str, (Object)metier, (Object)group, (Object)zone);
        }
        return result;
    }

    private double getDiscardsWeightPerStrMet(Strategy str, Metier metier, PopulationGroup group, Zone zone, TimeStep step) {
        MatrixND mat = this.resultManager.getMatrix(step, group.getPopulation(), ResultName.MATRIX_DISCARDS_WEIGHT_PER_STR_MET_PER_ZONE_POP);
        double result = 0.0;
        if (mat != null) {
            result = mat.getValue((Object)str, (Object)metier, (Object)group, (Object)zone);
        }
        return result;
    }

    public MatrixND matrixGrossValueOfLandingsPerStrategyMet(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_STRATEGY_MET, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.grossValueOfLandingsPerStrategyMet(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double grossValueOfLandingsPerStrategyMet(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        List<Population> pops = this.siMatrix.getPopulations(step);
        double result = 0.0;
        int i = 0;
        while (i < pops.size()) {
            Population pop = pops.get(i);
            result += this.grossValueOfLandingsPerSpeciesPerStrategyMet(str, metier, pop, step);
            ++i;
        }
        return result;
    }

    public MatrixND matrixGrossValueOfLandingsPerStrategyMetPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_STRATEGY_MET_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.grossValueOfLandingsPerStrategyMetPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double grossValueOfLandingsPerStrategyMetPerVessel(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double grossValueOfLandingsPerStrategyMet = this.grossValueOfLandingsPerStrategyMet(str, metier, step);
        double proportionSetOfVessels = str.getProportionSetOfVessels();
        double numberOfVessels = str.getSetOfVessels().getNumberOfVessels();
        double grossValueOfLandingsOtherSpeciesPerStrategyMet = this.grossValueOfLandingsOtherSpeciesPerStrategyMet(str, metier, step);
        return (grossValueOfLandingsPerStrategyMet + grossValueOfLandingsOtherSpeciesPerStrategyMet) / (proportionSetOfVessels * numberOfVessels);
    }

    public MatrixND matrixNetValueOfLandingsPerStrategyMet(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_NET_VALUE_OF_LANDINGS_PER_STRATEGY_MET, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.netValueOfLandingsPerStrategyMet(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double netValueOfLandingsPerStrategyMet(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double grossValue = this.grossValueOfLandingsPerStrategyMet(str, metier, step);
        EffortDescription effort = str.getSetOfVessels().getPossibleMetiers(metier);
        double landingCost = 1.0;
        if (effort != null) {
            landingCost -= effort.getLandingCosts();
        }
        double grossValueOfLandingsOtherSpeciesPerStrategyMet = this.grossValueOfLandingsOtherSpeciesPerStrategyMet(str, metier, step);
        double result = (grossValue + grossValueOfLandingsOtherSpeciesPerStrategyMet) * landingCost;
        return result;
    }

    private double grossValueOfLandingsOtherSpeciesPerStrategyMet(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        return 0.0;
    }

    public MatrixND matrixNetValueOfLandingsPerStrategyMetPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_NET_VALUE_OF_LANDINGS_PER_STRATEGY_MET_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.netValueOfLandingsPerStrategyMetPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double netValueOfLandingsPerStrategyMetPerVessel(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double netValueOfLandingsPerStrategyMet = this.netValueOfLandingsPerStrategyMet(str, metier, step);
        double proportionSetOfVessels = str.getProportionSetOfVessels();
        double numberOfVessels = str.getSetOfVessels().getNumberOfVessels();
        return netValueOfLandingsPerStrategyMet / (proportionSetOfVessels * numberOfVessels);
    }

    public MatrixND matrixNetRenevueToSharePerStrategyMetPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_NET_RENEVUE_TO_SHARE_PER_STRATEGY_MET_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.netRenevueToSharePerStrategyMetPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double netRenevueToSharePerStrategyMetPerVessel(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double netRenevueToSharePerStrategyMetPerVessel = this.netValueOfLandingsPerStrategyMetPerVessel(str, metier, step);
        double sharedNotFixedCostsPerVessel = this.sharedNotFixedCostsPerVessel(str, metier, step);
        double propStr = str.getStrategyMonthInfo(step.getMonth()).getProportionMetier(metier);
        double result = netRenevueToSharePerStrategyMetPerVessel - sharedNotFixedCostsPerVessel * propStr;
        return result;
    }

    public MatrixND matrixCrewSharePerStrategyMetPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_CREW_SHARE_PER_STRATEGY_MET_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.crewSharePerStrategyMetPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double crewSharePerStrategyMetPerVessel(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double netRenevueToShare = this.netRenevueToSharePerStrategyMetPerVessel(str, metier, step);
        EffortDescription effort = str.getSetOfVessels().getPossibleMetiers(metier);
        double crewShareRate = 0.0;
        if (effort != null) {
            crewShareRate = effort.getCrewShareRate();
        }
        return netRenevueToShare * crewShareRate;
    }

    public MatrixND matrixOwnerMarginOverVariableCostsPerStrategyMetPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_OWNER_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_MET_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.ownerMarginOverVariableCostsPerStrategyMetPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double ownerMarginOverVariableCostsPerStrategyMetPerVessel(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double netRenevueToShare = this.netRenevueToSharePerStrategyMetPerVessel(str, metier, step);
        double crewShare = this.crewSharePerStrategyMetPerVessel(str, metier, step);
        double repair = this.repairAndMaintenanceGearCostsPerVessel(str, metier, step);
        double propStr = str.getStrategyMonthInfo(step.getMonth()).getProportionMetier(metier);
        return netRenevueToShare - crewShare - repair * propStr;
    }

    public MatrixND matrixVesselMarginOverVariableCostsPerStrategyMetPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        List<Metier> metiers = this.siMatrix.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_MET_PER_VESSEL, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.siMatrix.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.vesselMarginOverVariableCostsPerStrategyMetPerVessel(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double vesselMarginOverVariableCostsPerStrategyMetPerVessel(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        double netRenevueToShare = this.netRenevueToSharePerStrategyMetPerVessel(str, metier, step);
        double repair = this.repairAndMaintenanceGearCostsPerVessel(str, metier, step);
        double propStr = str.getStrategyMonthInfo(step.getMonth()).getProportionMetier(metier);
        return netRenevueToShare - repair * propStr;
    }

    public MatrixND matrixOwnerMarginOverVariableCostsPerStrategyPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_OWNER_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_PER_VESSEL, new List[]{strategies}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            double value = this.ownerMarginOverVariableCostsPerStrategyPerVessel(str, step);
            result.setValue(s, value);
            ++s;
        }
        return result;
    }

    private double ownerMarginOverVariableCostsPerStrategyPerVessel(Strategy str, TimeStep step) throws TopiaException {
        SetOfVessels sov = str.getSetOfVessels();
        Collection efforts = sov.getPossibleMetiers();
        float result = 0.0f;
        for (EffortDescription effort : efforts) {
            Metier metier = effort.getPossibleMetiers();
            result = (float)((double)result + this.ownerMarginOverVariableCostsPerStrategyMetPerVessel(str, metier, step));
        }
        return result;
    }

    public MatrixND matrixOwnerMarginOverVariableCostsPerStrategy(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_OWNER_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY, new List[]{strategies}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            double value = this.ownerMarginOverVariableCostsPerStrategy(str, step);
            result.setValue(s, value);
            ++s;
        }
        return result;
    }

    private double ownerMarginOverVariableCostsPerStrategy(Strategy str, TimeStep step) throws TopiaException {
        double ownerMarginOverVariableCostsPerStrategyPerVessel = this.ownerMarginOverVariableCostsPerStrategyPerVessel(str, step);
        double proportionSetOfVessels = str.getProportionSetOfVessels();
        double numberOfVessels = str.getSetOfVessels().getNumberOfVessels();
        return ownerMarginOverVariableCostsPerStrategyPerVessel * (proportionSetOfVessels * numberOfVessels);
    }

    public MatrixND matrixVesselMarginOverVariableCostsPerStrategyPerVessel(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_PER_VESSEL, new List[]{strategies}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            double value = this.vesselMarginOverVariableCostsPerStrategyPerVessel(str, step);
            result.setValue(s, value);
            ++s;
        }
        return result;
    }

    private double vesselMarginOverVariableCostsPerStrategyPerVessel(Strategy str, TimeStep step) throws TopiaException {
        SetOfVessels sov = str.getSetOfVessels();
        Collection efforts = sov.getPossibleMetiers();
        float result = 0.0f;
        for (EffortDescription effort : efforts) {
            Metier metier = effort.getPossibleMetiers();
            result = (float)((double)result + this.vesselMarginOverVariableCostsPerStrategyMetPerVessel(str, metier, step));
        }
        return result;
    }

    public MatrixND matrixVesselMarginOverVariableCostsPerStrategy(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.siMatrix.getStrategies(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY, new List[]{strategies}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            double value = this.vesselMarginOverVariableCostsPerStrategy(str, step);
            result.setValue(s, value);
            ++s;
        }
        return result;
    }

    private double vesselMarginOverVariableCostsPerStrategy(Strategy str, TimeStep step) throws TopiaException {
        double vesselMarginOverVariableCostsPerStrategyPerVessel = this.vesselMarginOverVariableCostsPerStrategyPerVessel(str, step);
        double proportionSetOfVessels = str.getProportionSetOfVessels();
        double numberOfVessels = str.getSetOfVessels().getNumberOfVessels();
        return vesselMarginOverVariableCostsPerStrategyPerVessel * (proportionSetOfVessels * numberOfVessels);
    }

    public double valuePerUnitFishingEffort(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        List<Population> pops = this.siMatrix.getPopulations(step);
        double result = 0.0;
        for (Population pop : pops) {
            List groups = pop.getPopulationGroup();
            List zones = pop.getPopulationZone();
            for (PopulationGroup group : groups) {
                double price = group.getPrice();
                for (Zone zone : zones) {
                    double catchValue = this.getCatchWeightPerStrMetPerZonePop(str, metier, group, zone, step);
                    double discards = this.getDiscardsWeightPerStrMet(str, metier, group, zone, step);
                    result += price * (catchValue - discards);
                }
            }
        }
        double effort = this.getEffortPerStrategyMet(str, metier, step);
        result = effort == 0.0 ? 0.0 : (result /= effort);
        return result;
    }

    public double getEffortPerStrategyMet(Strategy str, Metier metier, TimeStep step) {
        MatrixND mat = this.resultManager.getMatrix(step, ResultName.MATRIX_EFFORT_PER_STRATEGY_MET);
        double result = 0.0;
        if (mat != null) {
            result = mat.getValue((Object)str, (Object)metier);
        }
        return result;
    }

    public double landingPerUnitFishingEffort(Strategy str, Metier metier, TimeStep step) throws TopiaException {
        List<Population> pops = this.siMatrix.getPopulations(step);
        double effort = this.getEffortPerStrategyMet(str, metier, step);
        double result = 0.0;
        if (effort != 0.0) {
            for (Population pop : pops) {
                List groups = pop.getPopulationGroup();
                List zones = pop.getPopulationZone();
                for (PopulationGroup group : groups) {
                    for (Zone zone : zones) {
                        double catchValue = this.getCatchWeightPerStrMetPerZonePop(str, metier, group, zone, step);
                        double discards = this.getDiscardsWeightPerStrMet(str, metier, group, zone, step);
                        result += catchValue - discards;
                    }
                }
            }
            result /= effort;
        }
        return result;
    }
}

