/*
 * Decompiled with CFR 0.152.
 */
package exports;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class ZonesDefinition
implements Export {
    private static Log log = LogFactory.getLog(ZonesDefinition.class);
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getExportFilename() {
        return "ZonesDefinition";
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String getDescription() {
        return "Export cell's zone constitution";
    }

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        TopiaContext tx = simulation.getStorage().beginTransaction();
        List zones = SimulationStorage.getFisheryRegion((TopiaContext)tx).getZone();
        TimeStep lastStep = simulation.getResultStorage().getLastStep();
        TimeStep step = new TimeStep(0);
        while (!step.after(lastStep)) {
            for (Zone zone : zones) {
                for (Cell cell : zone.getCell()) {
                    out.write(zone + ";" + cell + ";" + step.getStep() + "\n");
                }
            }
            step = step.next();
        }
        tx.closeContext();
    }
}

