<%--
#%L
  EchoBase :: UI
  $Id: dashboard.jsp 655 2012-09-12 16:12:57Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.2/echobase-ui/src/main/webapp/WEB-INF/jsp/removeData/dashboard.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
--%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>
<s:set var="emptySelection">
  <s:text name="echobase.message.noEntrySelection"/>
</s:set>

<s:url id='deleteImg' value='/images/delete.png'/>
<s:set id='deleteTitle'><s:text name="echobase.action.importLogDelete"/></s:set>
<s:url id='delUrl' action="confirmDelete" namespace="/removeData" method="input"
       escapeAmp="false"/>
<script type="text/javascript">

  function confirmDelete(id) {
    var dialog = $("#confirmDeleteDialog");
    dialog.html('');
    var url = "${delUrl}";
    url += '?' + $.param({'model.importLogId':id});
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  jQuery(document).ready(function () {
    $.addRowSelectTopic('datas', function (event) {
      $('#extraInfos').show();
      var text = $("tr[aria-selected=true] td[aria-describedby='datas_importText']").text();
      $('#importLogText').html(text);
      var voyage = $("tr[aria-selected=true] td[aria-describedby='datas_voyage']").text();
      $('#importLogVoyage').html(voyage);
      var user = $("tr[aria-selected=true] td[aria-describedby='datas_importUser']").text();
      $('#importLogUser').html(user);
      var date = $("tr[aria-selected=true] td[aria-describedby='datas_importDate']").text();
      $('#importLogDate').html(date);
      var importType = $("tr[aria-selected=true] td[aria-describedby='datas_importType']").text();
      $('#importLogImportType').html(importType);

    });
    $.addClearSelectTopic('datas', function (event) {
      $('#extraInfos').hide();
    });
    $.addSingleRowTopic2('datas', 'Delete', function (event, id) {
      return confirmDelete(id);
    });
    $.addEvenAndOddClasses('datas');
  });
</script>

<title><s:text name="echobase.title.importLogs"/></title>
<s:url id="loadUrl" action="getImportLogs" namespace="/removeData"
       escapeAmp="false"/>

<sjg:grid id="datas" dataType="json" href="%{loadUrl}" gridModel="datas"
          pager="true" pagerButtons="true" pagerInput="true" navigator="true"
          autowidth="true" rownumbers="false" viewrecords="true"
          navigatorEdit="false" navigatorSearch="false"
          navigatorDelete="false" navigatorAdd="false"
          rowList="10,15,20,50,100,250,500" rowNum="10"
          onSelectRowTopics='datas-rowSelect'
          onCompleteTopics="datas-clearSelect,datas-CompleteTopics"
          navigatorExtraButtons="{
                delete: { title : 'Supprimer', icon: 'ui-icon-trash', topic: 'datas-rowDelete' }
        }"
  >

  <sjg:gridColumn name="id" title="id" hidden="true"/>
  <sjg:gridColumn name="importType" sortable="true"
                  title="%{getText('echobase.common.importType')}"/>
  <sjg:gridColumn name="voyage" sortable="true"
                  title="%{getText('echobase.common.voyage')}"/>
  <sjg:gridColumn name="importDate" sortable="true"
                  title="%{getText('echobase.common.importDate')}"/>
  <sjg:gridColumn name="importText" sortable="true"
                  title="%{getText('echobase.common.importText')}"/>
  <sjg:gridColumn name="importUser" sortable="true"
                  title="%{getText('echobase.common.importUser')}"/>
</sjg:grid>
<br/>
<fieldset>
  <legend><s:text name="echobase.title.importLog.detail"/></legend>
  <div id="extraInfos">

    <s:label key='echobase.common.importType' value=''/>
    <div class="clearBoth"/>
    <pre id='importLogImportType' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.voyage' value=''/>
    <div class="clearBoth"/>
    <pre id='importLogVoyage' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.importDate' value=''/>
    <div class="clearBoth"/>
    <pre id='importLogDate' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.importText' value=''/>
    <div class="clearBoth"/>
    <pre id='importLogText' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.importUser' value=''/>
    <div class="clearBoth"/>
    <pre id='importLogUser' style="font-weight: bold;"></pre>
  </div>
</fieldset>

<sj:dialog id="confirmDeleteDialog" autoOpen="false" modal="true" width="780"
           title='%{getText("echobase.title.delete.importLog")}'/>