/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportDb;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.exportdb.ExportDbConfiguration;
import fr.ifremer.echobase.services.exportdb.ExportDbMode;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;

public class Configure
extends AbstractConfigureAction<ExportDbConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected Map<String, String> modes;
    protected Map<String, String> voyages;

    public Configure() {
        super(ExportDbConfiguration.class);
    }

    public Map<String, String> getModes() {
        return this.modes;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public void setFileName(String fileName) {
        ((ExportDbConfiguration)this.getModel()).setFileName(fileName);
    }

    @InputConfig(methodName="input")
    public String configureReferential() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String configureReferentialAndData() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String configureData() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String configureAll() throws Exception {
        return this.execute();
    }

    protected ExportDbConfiguration createModel() {
        ExportDbConfiguration result = new ExportDbConfiguration();
        result.setFileName("echobase");
        result.setComputeSteps(true);
        result.setVoyageIds(StringUtil.EMPTY_STRING_ARRAY);
        return result;
    }

    protected void prepareInputAction(ExportDbConfiguration model) {
        this.modes = this.decorateEnums((Enum[])ExportDbMode.values());
        if (model.getExportDbMode() == null) {
            model.setExportDbMode(ExportDbMode.ALL);
        }
        this.voyages = this.loadSortAndDecorate(Voyage.class);
    }

    protected void prepareExecuteAction(ExportDbConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-exportDb-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        if (model.getExportDbMode() == ExportDbMode.ALL) {
            this.voyages = this.loadSortAndDecorate(Voyage.class);
            Set ids = this.voyages.keySet();
            model.setVoyageIds(ids.toArray(new String[ids.size()]));
        }
    }
}

