/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.importdata.ResultsImportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GetDataProcessingsForVoyage
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String voyageId;
    protected Map<String, String> dataProcessings;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public Map<String, String> getDataProcessings() {
        return this.dataProcessings;
    }

    public String execute() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.voyageId)) {
            this.dataProcessings = Maps.newLinkedHashMap();
        } else {
            ResultsImportService service = (ResultsImportService)this.newService(ResultsImportService.class);
            Voyage voyage = (Voyage)service.getEntityById(Voyage.class, this.voyageId);
            Preconditions.checkNotNull((Object)voyage, (Object)("Could not find voyage with id " + this.voyageId));
            this.dataProcessings = service.getDataProcessings(voyage);
        }
        return "success";
    }
}

