/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: LoginAction.java 51 2011-11-13 16:20:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.6/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/user/LoginAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.user;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.interceptor.I18nInterceptor;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.SessionAware;

import java.util.Locale;
import java.util.Map;

/**
 * Login and Logout action.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class LoginAction extends EchoBaseActionSupport implements SessionAware {

    protected static final Log log = LogFactory.getLog(LoginAction.class);

    private static final long serialVersionUID = 1L;

    protected String email;

    protected String password;

    protected String redirectAction;

    private transient Map<String, Object> session;

    protected transient UserService userService;

    public UserService getUserService() {
        if (userService == null) {
            userService = newService(UserService.class);
        }
        return userService;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRedirectAction() {
        return redirectAction;
    }

    public void setRedirectAction(String redirectAction) {
        this.redirectAction = redirectAction;
    }

    public String doLogin() throws Exception {

        EchoBaseUser user = getUserService().getUserByEmail(email);

        EchoBaseSession userSession = getEchoBaseSession();

        // user is authorized, keep it in his echoBaseSession
        userSession.setEchoBaseUser(user);

        // add locale in echoBaseSession if required
        Object o = session.get(I18nInterceptor.DEFAULT_SESSION_ATTRIBUTE);
        if (o == null) {

            // push the locale in echoBaseSession to be able to use it everywhere
            Locale locale = ActionContext.getContext().getLocale();
            session.put(I18nInterceptor.DEFAULT_SESSION_ATTRIBUTE, locale);
        }

        // redecode parameters
        if (log.isInfoEnabled()) {
            log.info("success login for user " + email +
                     ", will redirect to " + redirectAction);
        }
        return "redirect";
    }

    public String doLogout() {

        EchoBaseSession userSession = getEchoBaseSession();

        // remove user from session
        userSession.setEchoBaseUser(null);

        // remove echoBaseSession from application session
        ActionContext.getContext().getSession().remove(SESSION_PARAMETER);

        return SUCCESS;
    }

    @Override
    public void setSession(Map<String, Object> session) {
        this.session = session;
    }
}
