/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: gridHelper.js 96 2011-11-19 14:10:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.2/echobase-ui/src/main/webapp/js/gridHelper.js $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
( function($) {

    $.fn.extend(
            {
                addRowSelectTopic: function(gridId, callback) {
                    $.subscribe(gridId + '-rowSelect', function(event) {
                        if (event.originalEvent) {
                            var gridId = event.data.id;
                            var opts = jQuery.struts2_jquery[gridId] = {};

                            var id = event.originalEvent.id;
                            if (id) {
                                opts['selectedRow'] = id;
                            }
                        }
                        var callback = event.data.callback;
                        if (callback) {
                            callback(event);
                        }
                    }, {id:gridId, callback:callback});
                },

                addClearSelectTopic: function (gridId, callback) {
                    $.subscribe(gridId + '-clearSelect', function(event) {
                        var gridId = event.data.id;
                        jQuery.struts2_jquery[gridId] = {};
                        var callback = event.data.callback;
                        if (callback) {
                            callback(event);
                        }
                    }, {id:gridId, callback:callback});
                },

                addAddRowTopic: function (gridId, url) {
                    $.subscribe(gridId + '-rowAdd', function(event) {
                        var url = event.data.url;
                        window.location = url;
                    }, {id:gridId, url:url});
                },

                addSingleRowTopic: function (gridId, action, url, parameterName) {
                    $.subscribe(gridId + '-row' + action, function(event) {
                        var gridId = event.data.id;
                        var opts = jQuery.struts2_jquery[gridId];
                        if (opts && opts['selectedRow']) {
                            var selectedId = opts['selectedRow'];
                            var parameterName = event.data.parameterName;
                            var params = {}
                            params[parameterName] = selectedId;
                            var url = $.prepareUrl(event.data.url, params);
                            window.location = url;
                        }
                    }, {id:gridId, url:url, parameterName:parameterName});
                },
                addMultiRowTopic: function (gridId, action, target, checkboxName, callback) {
                    $.subscribe(gridId + '-row' + action, function(event) {
                        var gridId = event.data.id;
                        var prefix = 'jqg_' + gridId + '_';
                        var prefixLength = prefix.length;

                        // get all selected ids
                        var inputs = $('table#' + gridId + ' :checked[id^="' + prefix + '"]');

                        if (inputs && inputs.length) {
                            var checkboxName = event.data.checkboxName;
                            inputs.each(function() {
                                var id = this.id;
                                var newId = id.substring(prefixLength);
                                $.attr(this, "name", checkboxName);
                                $.attr(this, "value", newId);
                                $.attr(this, "checked", "checked");
                            });
                            var callback = event.data.callback;
                            if (callback) {
                                callback();
                            }
                            event.data.target.click();
                        }
                    }, {id:gridId,
                        target:target,
                        checkboxName:checkboxName,
                        callback:callback});
                },

                serializeCheckboxs: function(id, params, newId) {
                    var all = $(':checkbox[name="' + id + '"]');
                    var selected = $(':checked[name="' + id + '"]');

                    if (all.length != selected.length) {

                        // apply a year filter
                        var list = [];
                        selected.each(function() {
                            list.push(this.value);
                        });
                        if (!newId) {
                            newId = id;
                        }
                        params[newId] = list;
                    }
                },

                prepareUrl: function (url, params) {
                    var result = url;
                    if (url.indexOf("?") > -1) {
                        result += "&";
                    } else {
                        result += "?";
                    }
                    result += $.param(params);
                    return result;
                }
            });

    $.extend({
                 addRowSelectTopic:function(gridId, callback) {
                     return $(document).addRowSelectTopic(gridId, callback);
                 },

                 addClearSelectTopic:function(gridId, callback) {
                     return $(document).addClearSelectTopic(gridId, callback);
                 },

                 addAddRowTopic:function(gridId, url) {
                     return $(document).addAddRowTopic(gridId, url);
                 },

                 addSingleRowTopic:function(gridId, action, url, parameterName) {
                     return $(document).addSingleRowTopic(gridId, action, url, parameterName);
                 },

                 addMultiRowTopic:function(gridId, action, target, checkboxName, calbback) {
                     return $(document).addMultiRowTopic(gridId, action, target, checkboxName, calbback);
                 },
                 serializeCheckboxs: function(id, params, newId) {
                     return $(document).serializeCheckboxs(id, params, newId);
                 },
                 prepareUrl:function(url, params) {
                     return $(document).prepareUrl(url, params);
                 }
             });
})(jQuery);

