<%--
#%L
  EchoBase :: UI
  $Id: dbeditor.jsp 244 2012-01-06 16:19:28Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.2/echobase-ui/src/main/webapp/WEB-INF/jsp/dbeditor/dbeditor.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
--%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:url id="reloadUrl" action="dbeditor" namespace="/dbeditor"/>
<s:url id="getTableData" action="getTableData" namespace="/dbeditor"/>

<s:set name="tableSelected" value="%{entityType != null}"/>

<title><s:text name="echobase.title.dbEditor"/></title>

<script type="text/javascript">

  jQuery(document).ready(function () {

    // Hack to make name=id on sj tags
    var combos = $('select[name=""]');
    combos.each(function(obj) {
        this.name = this.id;
    });

    var pickers = $('input.hasDatepicker');
    pickers.each(function(obj) {
        this.name = this.id;
    });

    // on table name change, let's reload reload this page
    $('[name="entityType"]').change(function(event) {
      var url = "${reloadUrl}?" + $.param({entityType:this.value});
      window.location = url;
    });

    // on reset let's just reload the selected row
    $('[name="resetAction"]').click(function(event){
      $.publish('datas-rowSelect')
    });

    // on grid selected clear, let's remove the edit form
    $.addClearSelectTopic('datas', function(event) {

      $('#noRowSelected').show();
      $('#editForm').hide();
    });

    // on row selection, let's load the edit form
    $.addRowSelectTopic('datas', function(event) {
      
      $('#noRowSelected').hide();
      $('#editForm').show();

      // get selected id
      var id = jQuery.struts2_jquery['datas']['selectedRow'];

      // get table name
      var entityType = "${entityType}";

      // get entity value from json
      jQuery.getJSON("${getTableData}",
                     { "entityType":entityType, "id":id }, function (result) {

          // get metadatas from the response
          var metas = result.metas;

          // iterate on result to push in form the value to edit

          $.each(result.datas, function(propertyName, value) {

            if (propertyName == 'topiaId') {

              // push the id of row
              $("#" + propertyName).val(value);
              return;
            }

            var meta = metas[propertyName];

            if (!meta) {

              // not a meta to treate
              return;
            }

            var type = meta['typeSimpleName'];
            if (meta['fK']) {
              type = 'FK';
            }

            // get concerned editor
            var editor = $("#" + propertyName);

            switch (type) {
              case 'boolean':
              case 'Boolean':
                editor.attr('checked', value);
                break;

              case 'Date':
                // Update date
                updateDate(value, editor);
                break;

              case 'FK':
                // select value in the select box
                $('#' + propertyName + ' option[value="' + value + '"]').attr('selected', true);
                break;

              default:
                editor.val(value);
            }
          });
        });
    });
  });

  function formatEntityLabel(cellvalue, options, rowObject) {
    var columnName = options.colModel.name + "_lib";
    return rowObject[columnName];
  }

  function updateDate(value, editor) {

      // parse date formated like : dd/MM/yyyy HH:mm:ss
      var date = parseDate(value);

      // get timePicker instance
      var inst = $.datepicker._getInst(editor[0]);

      // set date
      $.datepicker._setDate(inst, date);

      // set time
      $.datepicker._setTime(inst, date);
  }

  function parseDate(value) {

      // parse date formated like : dd/MM/yyyy HH:mm:ss
      var dateString = value.substring(0, 10);
      var dateSplited = dateString.split("/");

      var hourString = value.substring(11, 19);
      var hourSplited = hourString.split(":");

      var day = parseInt(dateSplited[0]);

      // FIXME sletellier 20111122 : currently, one month more are displayed....
      var month = parseInt(dateSplited[1]) - 1;
      var year = parseInt(dateSplited[2]);
      var hour = parseInt(hourSplited[0]);
      var minute = parseInt(hourSplited[1]);
      var second = parseInt(hourSplited[2]);

      // update date
      // TODO sletellier 20111122 : edit milliseconds ?
      return new Date(year, month, day, hour, minute, second, 0);
  }
</script>

<s:select key="entityType" label='%{getText("echobase.common.entityType")}'
            list="entityTypes" headerKey="" headerValue=""/>

<br class="clearBoth"/>

<s:if test="tableSelected">

    <sj:tabbedpanel id="io" collapsible="true">
      <sj:tab id="tab_importForm" target="importForm" title="ss"
              label="%{getText('echobase.title.importTable')}"/>

      <sj:tab id="tab_exportForm" target="exportForm"
              label="%{getText('echobase.title.exportTable')}"/>

      <s:form id="importForm" namespace="/dbeditor" method="post"
              enctype="multipart/form-data">

        <s:hidden key="entityType" label=''/>
        <s:file key="importFile" required="true"
                label="%{getText('echobase.label.importFile')}"/>

        <s:checkbox key='createIfNotFound' value='true'
                    label='%{getText("echobase.label.createIfNotFound")}'/>
        <br/>
        <s:submit key="echobase.action.importTable" action="doImport"
                  align="right"/>
      </s:form>

      <s:form id="exportForm" namespace="/dbeditor" method="post">
        <s:hidden key="entityType" label=''/>
        <s:textfield key="exportFileName" required="true" size="100"
                 label="%{getText('echobase.label.exportFileName')}"/>

        <br/>
        <s:submit key="echobase.action.exportTable" action="doExport"
                  align="right"/>
      </s:form>

    </sj:tabbedpanel>

  </s:if>
<br class="clearBoth"/>

<s:if test="tableSelected">
  <s:url id="loadUrl" action="getTableDatas" namespace="/dbeditor"
         escapeAmp="false">
    <s:param name="entityType" value="%{entityType}"/>
  </s:url>

  <s:set var="tableI18nName"
         value="%{getText('echobase.common.tableDatas', entityTypes[entityType])}"/>

  <sjg:grid id="datas" dataType="json" href="%{loadUrl}" gridModel="datas"
            caption="%{tableI18nName}"
            pager="true" pagerButtons="true" pagerInput="true" navigator="true"
            autowidth="true" rownumbers="false" viewrecords="true"
            navigatorEdit="false" navigatorSearch="true"
            navigatorDelete="false" navigatorAdd="false"
            rowList="10,15,20, 50" rowNum="10"
            onSelectRowTopics="datas-rowSelect"
            onCompleteTopics="datas-clearSelect"
            navigatorSearchOptions="{multipleGroup:false,showQuery:true,multipleSearch:true,sopt:['eq','ne','cn','nc','bw','bn','ew','en','lt','le','gt','ge','nu','nn','in','ni']}">

    <sjg:gridColumn name="id" title="id" hidden="true" editable="true"/>

    <s:iterator value="columnMetas" var="meta" status="status">

      <s:if test="#meta.fK">
        <sjg:gridColumn name="%{#meta.name}"
                        title="%{#meta.name}"
                        formatter='formatEntityLabel'
                        sortable="true"/>
      </s:if>
      <s:elseif test="#meta.name == 'id'">
        <sjg:gridColumn name="ID"
                        title="id"
                        sortable="true" editable="true"/>
      </s:elseif>
      <s:else>
        <sjg:gridColumn name="%{#meta.name}"
                        title="%{#meta.name}"
                        sortable="true" editable="true"/>
      </s:else>


    </s:iterator>

  </sjg:grid>

  <br class="clearBoth"/>

  <fieldset id="noRowSelected">
    <legend>
          <s:text name="echobase.legend.dbeditor.edit">
            <s:param value="%{tableI18nName}"/>
          </s:text>
      </legend>
    <i><s:text name="echobase.message.no.row.selected"/>.</i>
  </fieldset>

  <s:form id="editForm" namespace="/dbeditor">
    <fieldset>
      <legend>
        <s:text name="echobase.legend.dbeditor.edit">
          <s:param value="%{tableI18nName}"/>
        </s:text>
      </legend>

      <s:hidden key="entityType" label=''/>

      <s:hidden id="topiaId" name='topiaId' label=''/>
      
      <s:iterator value="columnMetas" var="meta" status="status">
        <s:set var="metaName" value='%{#meta.name}'/>
        <s:if test="#meta.fK">
          <s:url id="urlName"
               action="getForeignEntities"
               namespace="/dbeditor"
               escapeAmp="false">
            <s:param name="entityType" value="%{#meta.typeSimpleName}"/>
          </s:url>
          <sj:select id="%{#metaName}"
                     label="%{#metaName}"
                     href="%{urlName}"
                     list="entities"
                     emptyOption="true"/>
        </s:if>
        <s:else>
            <s:if test='#meta.columnType == "string"'>
              <s:textfield id="%{#metaName}"
                           name="%{#metaName}"
                           label="%{#metaName}"
                           disabled="%{#meta.fK}"
                           value=""/>
            </s:if>
            <s:elseif test='#meta.columnType == "boolean"'>
              <s:checkbox id="%{#metaName}"
                          name="%{#metaName}"
                          label="%{#metaName}" value="%{false}"/>
            </s:elseif>
            <s:elseif test='#meta.columnType == "date"'>
              <sj:datepicker id="%{#metaName}"
                             name="%{#metaName}"
                             label="%{#metaName}"
                             value="%{new java.util.Date()}"
                             displayFormat="dd/mm/yy"
                             timepicker="true"
                             timepickerShowSecond="true"
                             timepickerFormat="hh:mm:ss"/>
            </s:elseif>
        </s:else>
        <br/>
      </s:iterator>
    </fieldset>
    <ul class="toolbar floatRight">
      <li><s:submit name='resetAction' key="echobase.action.reset"
                    theme="simple" onclick="return false;"/>
      </li>
      <li><s:submit name="submitAction" key="echobase.action.save"
                    action="editTableData" theme="simple"/>
      </li>
    </ul>
  </s:form>

</s:if>

