/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.EchoBaseUserDTO;
import fr.ifremer.echobase.entities.EchoBaseUserDTOImpl;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Update
extends EchoBaseActionSupport
implements Preparable {
    protected static final Log log = LogFactory.getLog(Update.class);
    private static final long serialVersionUID = 1L;
    protected transient UserService userService;
    protected EchoBaseUserDTO user;

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)this.newService(UserService.class);
        }
        return this.userService;
    }

    public String execute() throws Exception {
        EchoBaseUserDTO user = this.getUser();
        String userEmail = user.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will update user " + userEmail));
        }
        this.getUserService().createOrUpdate(user);
        this.addActionMessage(this._("echobase.info.user.update", new Object[]{userEmail}));
        return "success";
    }

    public void prepare() throws Exception {
        String userId = this.getUser().getId();
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            this.user = ((EchoBaseUser)this.getUserService().getEntityById(EchoBaseUser.class, userId)).toDTO();
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected user " + this.user.getEmail()));
            }
        }
    }

    public EchoBaseUserDTO getUser() {
        if (this.user == null) {
            this.user = new EchoBaseUserDTOImpl();
        }
        return this.user;
    }
}

