/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.EchoBaseUserDTO;
import fr.ifremer.echobase.entities.EchoBaseUserDTOImpl;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Create
extends EchoBaseActionSupport {
    protected static final Log log = LogFactory.getLog(Create.class);
    private static final long serialVersionUID = 1L;
    protected transient UserService userService;
    protected EchoBaseUserDTO user;

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)this.newService(UserService.class);
        }
        return this.userService;
    }

    public String execute() throws Exception {
        EchoBaseUserDTO user = this.getUser();
        String userEmail = user.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will create user  " + userEmail));
        }
        this.getUserService().createOrUpdate(user);
        this.addActionMessage(this._("echobase.info.user.create", new Object[]{userEmail}));
        return "success";
    }

    public void validate() {
        EchoBaseUserDTO user = this.getUser();
        String userEmail = user.getEmail();
        if (StringUtils.isEmpty((CharSequence)userEmail)) {
            this.addFieldError("user.email", this._("echobase.error.required.email", new Object[0]));
        } else {
            EchoBaseUser login;
            try {
                login = this.getUserService().getUserByEmail(userEmail);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not obtain user " + userEmail, e);
            }
            if (login != null) {
                this.addFieldError("user.email", this._("echobase.error.email.already.used", new Object[0]));
            }
        }
        String userPassword = user.getPassword();
        if (StringUtils.isEmpty((CharSequence)userPassword)) {
            this.addFieldError("user.password", this._("echobase.error.required.password", new Object[0]));
        }
    }

    public EchoBaseUserDTO getUser() {
        if (this.user == null) {
            this.user = new EchoBaseUserDTOImpl();
        }
        return this.user;
    }
}

