/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.ImportDataMode;
import fr.ifremer.echobase.services.configurations.ImportDataConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class ConfigureFiles
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureFiles.class);
    protected ImportDataConfiguration model;
    protected String missionId;
    protected Map<String, String> importDataModes;

    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    public void setImportDataMode(ImportDataMode importDataMode) {
        this.getModel().setImportDataMode(importDataMode);
    }

    public void setAcoustic(File file) {
        this.getModel().getAcousticFile().setFile(file);
    }

    public void setAcousticContentType(String contentType) {
        this.getModel().getAcousticFile().setContentType(contentType);
    }

    public void setAcousticFileName(String fileName) {
        this.getModel().getAcousticFile().setFileName(fileName);
    }

    public void setCapture(File file) {
        this.getModel().getCaptureFile().setFile(file);
    }

    public void setCaptureContentType(String contentType) {
        this.getModel().getCaptureFile().setContentType(contentType);
    }

    public void setCaptureFileName(String fileName) {
        this.getModel().getCaptureFile().setFileName(fileName);
    }

    public void setLectureAgeGen(File file) {
        this.getModel().getLectureAgeGenFile().setFile(file);
    }

    public void setLectureAgeGenContentType(String contentType) {
        this.getModel().getLectureAgeGenFile().setContentType(contentType);
    }

    public void setLectureAgeGenFileName(String fileName) {
        this.getModel().getLectureAgeGenFile().setFileName(fileName);
    }

    public void setEvents(File file) {
        this.getModel().getEventsFile().setFile(file);
    }

    public void setEventsContentType(String contentType) {
        this.getModel().getEventsFile().setContentType(contentType);
    }

    public void setEventsFileName(String fileName) {
        this.getModel().getEventsFile().setFileName(fileName);
    }

    public void setTypeEchoSpecies(File file) {
        this.getModel().getTypeEchoSpeciesFile().setFile(file);
    }

    public void setTypeEchoSpeciesContentType(String contentType) {
        this.getModel().getTypeEchoSpeciesFile().setContentType(contentType);
    }

    public void setTypeEchoSpeciesFileName(String fileName) {
        this.getModel().getTypeEchoSpeciesFile().setFileName(fileName);
    }

    public String getMissionId() {
        return this.missionId;
    }

    public ImportDataMode getImportDataMode() {
        return this.getModel().getImportDataMode();
    }

    public ImportDataConfiguration getModel() {
        if (this.model == null) {
            this.model = new ImportDataConfiguration(this.getLocale());
        }
        return this.model;
    }

    public Map<String, String> getImportDataModes() {
        return this.importDataModes;
    }

    public String input() throws Exception {
        this.getEchoBaseSession().setImportDataConfiguration(null);
        return "input";
    }

    public String execute() throws Exception {
        ImportDataConfiguration importModel = this.getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-importData-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        importModel.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        this.copyFile(importModel.getAcousticFile(), dataDirectory);
        this.copyFile(importModel.getCaptureFile(), dataDirectory);
        this.copyFile(importModel.getEventsFile(), dataDirectory);
        this.copyFile(importModel.getLectureAgeGenFile(), dataDirectory);
        this.copyFile(importModel.getTypeEchoSpeciesFile(), dataDirectory);
        this.getEchoBaseSession().setImportDataConfiguration(importModel);
        return "success";
    }

    public void prepare() throws Exception {
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.newService(EchoBaseServiceSupport.class);
        Mission mission = (Mission)service.getEntityById(Mission.class, this.missionId);
        ImportDataConfiguration configuration = this.getModel();
        configuration.setMission(mission);
        this.importDataModes = Maps.newLinkedHashMap();
        for (ImportDataMode mode : ImportDataMode.values()) {
            this.importDataModes.put(mode.name(), this._(mode.getI18nKey(), new Object[0]));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Incoming importDataMode " + configuration.getImportDataMode()));
        }
        if (configuration.getImportDataMode() == null) {
            configuration.setImportDataMode(ImportDataMode.ALL);
        }
    }
}

