/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.util;

import fr.ifremer.coser.util.ProgressMonitor;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class ProgressReader
extends Reader {
    protected Reader delegateReader;
    protected ProgressMonitor delegateProgress;

    public ProgressReader(Reader delegateReader, ProgressMonitor delegateProgress) {
        this.delegateReader = delegateReader;
        this.delegateProgress = delegateProgress;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int nb = this.delegateReader.read(cbuf, off, len);
        if (nb != -1) {
            this.delegateProgress.addCurrent(nb);
        }
        return nb;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int nb = this.delegateReader.read(target);
        if (nb != -1) {
            this.delegateProgress.addCurrent(nb);
        }
        return nb;
    }

    @Override
    public int read() throws IOException {
        int nb = this.delegateReader.read();
        if (nb != -1) {
            this.delegateProgress.addCurrent(nb);
        }
        return nb;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int nb = this.delegateReader.read(cbuf);
        if (nb != -1) {
            this.delegateProgress.addCurrent(nb);
        }
        return nb;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegateReader.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.delegateReader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.delegateReader.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.delegateReader.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegateReader.reset();
    }

    @Override
    public void close() throws IOException {
        this.delegateReader.close();
    }
}

