/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.util;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.nuiton.i18n.I18n;

public enum DataType {
    MAP(I18n.n((String)"coser.business.data.type.map", (Object[])new Object[0]), true, false),
    POPULATION(I18n.n((String)"coser.business.data.type.population", (Object[])new Object[0]), true, true),
    COMMUNITY(I18n.n((String)"coser.business.data.type.community", (Object[])new Object[0]), true, true),
    SOURCE(I18n.n((String)"coser.business.data.type.source", (Object[])new Object[0]), false, false);

    private final String i18nKey;
    private final boolean needSpecies;
    private final boolean indicator;

    private DataType(String i18nKey, boolean needSpecies, boolean indicator) {
        this.i18nKey = i18nKey;
        this.needSpecies = needSpecies;
        this.indicator = indicator;
    }

    public String getLabel(Locale locale) {
        return I18n.l((Locale)locale, (String)this.i18nKey, (Object[])new Object[0]);
    }

    public static Map<String, String> getExtractTypes(Locale locale) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (DataType dataType : DataType.values()) {
            result.put(dataType.name(), dataType.getLabel(locale));
        }
        return result;
    }

    public static boolean isNeedSpecies(List<DataType> types) {
        boolean result = false;
        for (DataType type : types) {
            if (!type.needSpecies) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isIndicator(List<DataType> types) {
        boolean result = false;
        for (DataType type : types) {
            if (!type.indicator) continue;
            result = true;
            break;
        }
        return result;
    }
}

