/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.storage;

import fr.ifremer.coser.storage.DataStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MemoryDataStorage
implements DataStorage {
    private static final long serialVersionUID = 1L;
    protected List<String> listStorage = new ArrayList<String>();
    protected List<String> lineIndexStorage = new ArrayList<String>();
    protected Map<String, Integer> lineIndexStorageCache = new HashMap<String, Integer>();
    protected static final char separator = ',';
    protected static final char quotechar = '\"';
    protected static final char escapechar = '\\';

    @Override
    public Iterator<String[]> iterator() {
        return this.iterator(false);
    }

    @Override
    public Iterator<String[]> iterator(boolean skipFirstLine) {
        StringListIterator iterator = new StringListIterator(this.listStorage.iterator(), this.lineIndexStorage.iterator());
        if (skipFirstLine) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public void add(String[] data) {
        String stringData = this.arrayToString(data);
        this.listStorage.add(stringData);
        this.lineIndexStorage.add(data[0]);
    }

    @Override
    public void add(int index, String[] data) {
        String stringData = this.arrayToString(data);
        this.listStorage.add(index, stringData);
        this.lineIndexStorage.add(index, data[0]);
        this.lineIndexStorageCache.clear();
    }

    @Override
    public String[] get(int index) {
        String stringData = this.listStorage.get(index);
        String[] dataArray = this.stringToArray(stringData);
        return dataArray;
    }

    @Override
    public int indexOf(String lineNumber) {
        Integer indexOf = this.lineIndexStorageCache.get(lineNumber);
        if (indexOf == null) {
            indexOf = this.lineIndexStorage.indexOf(lineNumber);
            this.lineIndexStorageCache.put(lineNumber, indexOf);
        }
        return indexOf;
    }

    @Override
    public int size() {
        return this.listStorage.size();
    }

    @Override
    public String[] set(int index, String[] element) {
        String data = this.arrayToString(element);
        String old = this.listStorage.set(index, data);
        String[] oldArray = this.stringToArray(old);
        this.lineIndexStorage.set(index, element[0]);
        return oldArray;
    }

    @Override
    public String[] remove(int index) {
        String old = this.listStorage.remove(index);
        String[] oldArray = this.stringToArray(old);
        this.lineIndexStorage.remove(index);
        this.lineIndexStorageCache.clear();
        return oldArray;
    }

    public String toString() {
        return this.listStorage.toString();
    }

    protected String arrayToString(String[] nextLine) {
        return this.writeNext(nextLine);
    }

    protected String[] stringToArray(String data) {
        return this.parseLine(data);
    }

    protected String writeNext(String[] nextLine) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(',');
            }
            if ((nextElement = nextLine[i]) == null) continue;
            sb.append('\"');
            if (nextElement.indexOf(34) != -1 || nextElement.indexOf(92) != -1) {
                sb.append((CharSequence)this.processLine(nextElement));
            } else {
                sb.append(nextElement);
            }
            sb.append('\"');
        }
        return sb.toString();
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (nextChar == '\"') {
                sb.append('\\').append(nextChar);
                continue;
            }
            if (nextChar == '\\') {
                sb.append('\\').append(nextChar);
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }

    protected String[] parseLine(String nextLine) {
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(128);
        boolean inQuotes = false;
        for (int i = 0; i < nextLine.length(); ++i) {
            char c = nextLine.charAt(i);
            if (c == '\\') {
                if (!this.isNextCharacterEscapable(nextLine, inQuotes, i)) continue;
                sb.append(nextLine.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == '\"') {
                if (this.isNextCharacterEscapedQuote(nextLine, inQuotes, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl = inQuotes = !inQuotes;
                if (i <= 2 || nextLine.charAt(i - 1) == ',' || nextLine.length() <= i + 1 || nextLine.charAt(i + 1) == ',') continue;
                sb.append(c);
                continue;
            }
            if (c == ',' && !inQuotes) {
                tokensOnThisLine.add(sb.toString());
                sb = new StringBuilder(128);
                continue;
            }
            sb.append(c);
        }
        tokensOnThisLine.add(sb.toString());
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    protected boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == '\"';
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && (nextLine.charAt(i + 1) == '\"' || nextLine.charAt(i + 1) == '\\');
    }

    public class StringListIterator
    implements Iterator<String[]> {
        protected Iterator<String> listIterator;
        protected Iterator<String> lineIndexIterator;

        public StringListIterator(Iterator<String> internalIterator, Iterator<String> lineIndexIterator) {
            this.listIterator = internalIterator;
            this.lineIndexIterator = lineIndexIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public String[] next() {
            String nextString = this.listIterator.next();
            String[] nextArray = MemoryDataStorage.this.stringToArray(nextString);
            this.lineIndexIterator.next();
            return nextArray;
        }

        @Override
        public void remove() {
            this.listIterator.remove();
            this.lineIndexIterator.remove();
        }
    }
}

