/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import com.itextpdf.text.DocumentException;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.command.CategoryLineCommand;
import fr.ifremer.coser.command.Command;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.ControlErrorGroup;
import fr.ifremer.coser.control.DiffCatchLengthControlError;
import fr.ifremer.coser.control.SpeciesControlError;
import fr.ifremer.coser.services.CommonService;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.MemoryDataStorage;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.util.ShapeUtilities;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PublicationService {
    private static final Log log = LogFactory.getLog(PublicationService.class);
    protected CoserBusinessConfig config;
    protected CommonService commonService;

    public PublicationService(CoserBusinessConfig config) {
        this.config = config;
        this.commonService = new CommonService(config);
    }

    public Map<String, JFreeChart> getCompareCatchLengthGraph(Project project, AbstractDataContainer container, Collection<String> speciesCollection) {
        int minYear = Integer.MAX_VALUE;
        int maxYear = Integer.MIN_VALUE;
        HashMap catchForSpeciesYears = new HashMap();
        Iterator<String[]> itCatchData = container.getCatch().iterator(true);
        while (itCatchData.hasNext()) {
            String year;
            HashMap<String, Double> speciesCatchForYears;
            String[] tuple;
            block14: {
                tuple = itCatchData.next();
                String species = tuple[4];
                speciesCatchForYears = (HashMap<String, Double>)catchForSpeciesYears.get(species);
                if (speciesCatchForYears == null) {
                    speciesCatchForYears = new HashMap<String, Double>();
                    catchForSpeciesYears.put(species, speciesCatchForYears);
                }
                year = tuple[2];
                try {
                    int intYear = Integer.parseInt(year);
                    minYear = Math.min(minYear, intYear);
                    maxYear = Math.max(maxYear, intYear);
                }
                catch (NumberFormatException ex) {
                    if (!log.isWarnEnabled()) break block14;
                    log.warn((Object)("Can't parse " + year + "as int"));
                }
            }
            String nombreValue = tuple[5];
            try {
                Double nombreDouble = Double.valueOf(nombreValue);
                if (speciesCatchForYears.containsKey(year)) {
                    Double oldValue = (Double)speciesCatchForYears.get(year);
                    Double newValue = oldValue + nombreDouble;
                    speciesCatchForYears.put(year, newValue);
                    continue;
                }
                speciesCatchForYears.put(year, nombreDouble);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + nombreValue + " as double"));
            }
        }
        HashMap lengthForSpeciesYears = new HashMap();
        Iterator<String[]> itLengthData = container.getLength().iterator(true);
        while (itLengthData.hasNext()) {
            String[] tuple = itLengthData.next();
            String species = tuple[4];
            HashMap<String, Double> speciesLengthForYears = (HashMap<String, Double>)lengthForSpeciesYears.get(species);
            if (speciesLengthForYears == null) {
                speciesLengthForYears = new HashMap<String, Double>();
                lengthForSpeciesYears.put(species, speciesLengthForYears);
            }
            String year = tuple[2];
            String nombreValue = tuple[8];
            try {
                Double nombreDouble = Double.valueOf(nombreValue);
                if (speciesLengthForYears.containsKey(year)) {
                    Double oldValue = (Double)speciesLengthForYears.get(year);
                    Double newValue = oldValue + nombreDouble;
                    speciesLengthForYears.put(year, newValue);
                    continue;
                }
                speciesLengthForYears.put(year, nombreDouble);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + nombreValue + " as double"));
            }
        }
        TreeMap<String, JFreeChart> charts = new TreeMap<String, JFreeChart>();
        for (Map.Entry catchEntries : catchForSpeciesYears.entrySet()) {
            String species = (String)catchEntries.getKey();
            if (speciesCollection != null && !speciesCollection.contains(species)) continue;
            Map catchNumbers = (Map)catchEntries.getValue();
            Map lengthNumbers = (Map)lengthForSpeciesYears.get(species);
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            for (int year = minYear; year <= maxYear; ++year) {
                Double catchNumber = (Double)catchNumbers.get(String.valueOf(year));
                dataset.setValue((Number)catchNumber, (Comparable)((Object)I18n.t((String)CoserConstants.Category.CATCH.getTranslationKey(), (Object[])new Object[0])), (Comparable)Integer.valueOf(year));
                if (lengthNumbers == null) continue;
                Double lengthNumber = (Double)lengthNumbers.get(String.valueOf(year));
                dataset.setValue((Number)lengthNumber, (Comparable)((Object)I18n.t((String)CoserConstants.Category.LENGTH.getTranslationKey(), (Object[])new Object[0])), (Comparable)Integer.valueOf(year));
            }
            JFreeChart chart = this.displayGraph((CategoryDataset)dataset, I18n.t((String)"coser.business.chart.compareCatchLengthNumberTitle", (Object[])new Object[]{project.getDisplaySpeciesText(species)}));
            charts.put(species, chart);
        }
        return charts;
    }

    protected JFreeChart displayGraph(CategoryDataset categoryDataSet, String title) {
        CategoryAxis categoryAxis = new CategoryAxis(I18n.t((String)"coser.business.common.year", (Object[])new Object[0]));
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis valueAxis = new NumberAxis(I18n.t((String)"coser.business.common.number", (Object[])new Object[0]));
        valueAxis.setUpperMargin(0.1);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        Shape firstShape = ShapeUtilities.createDiamond((float)5.0f);
        renderer.setSeriesShape(0, firstShape);
        StandardCategoryToolTipGenerator cttg = new StandardCategoryToolTipGenerator("{0}: {2}", NumberFormat.getInstance());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)cttg);
        CategoryPlot plot = new CategoryPlot(categoryDataSet, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        return chart;
    }

    public File exportErrorsAsHTML(Project project, AbstractDataContainer container, List<ControlError> validationErrors) throws CoserBusinessException {
        File exportHtmlFile = null;
        OutputStreamWriter out = null;
        try {
            exportHtmlFile = File.createTempFile("coser-errors-", ".html");
            exportHtmlFile.deleteOnExit();
            if (log.isInfoEnabled()) {
                log.info((Object)("Generating HTML report to " + exportHtmlFile.getAbsolutePath()));
            }
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(exportHtmlFile), "utf-8");
            this.exportErrorsAsHTML(project, container, validationErrors, out, false);
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't export errors", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
        return exportHtmlFile;
    }

    protected void exportErrorsAsHTML(Project project, AbstractDataContainer container, List<ControlError> validationErrors, Writer out, boolean includeProjectInfo) throws CoserBusinessException, IOException {
        ArrayList<String> speciesGraph = new ArrayList<String>();
        File imageDirectory = FileUtil.createTempDirectory((String)"coser-images-", (String)"-tmp");
        imageDirectory.deleteOnExit();
        out.write("<html><head>");
        out.write("<title>" + I18n.t((String)"coser.business.publication.errorexporttitle", (Object[])new Object[]{project.getName()}) + "</title>");
        out.write("<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />");
        out.write("</head><body>");
        HashMap validationCategoryChild = new HashMap();
        HashMap validationErrorsChilds = new HashMap();
        for (ControlError validationError : validationErrors) {
            ControlErrorGroup group;
            ArrayList<ControlError> childErrors;
            String string = validationError.getCategory() == null ? I18n.t((String)"coser.business.control.error.allCategories", (Object[])new Object[0]) : I18n.t((String)validationError.getCategory().getTranslationKey(), (Object[])new Object[0]);
            ArrayList<ControlErrorGroup> errorGroup = (ArrayList<ControlErrorGroup>)validationCategoryChild.get(string);
            if (errorGroup == null) {
                errorGroup = new ArrayList<ControlErrorGroup>();
                validationCategoryChild.put(string, errorGroup);
            }
            if ((childErrors = (ArrayList<ControlError>)validationErrorsChilds.get(group = new ControlErrorGroup(validationError.getCategory(), validationError.getLevel(), validationError.getMessage()))) == null) {
                childErrors = new ArrayList<ControlError>();
                validationErrorsChilds.put(group, childErrors);
                errorGroup.add(group);
            }
            if (validationError instanceof SpeciesControlError) {
                SpeciesControlError diffError = (SpeciesControlError)validationError;
                speciesGraph.add(diffError.getSpecies());
            }
            childErrors.add(validationError);
        }
        Map<String, JFreeChart> charts = this.getCompareCatchLengthGraph(project, container, speciesGraph);
        out.write("<h1 style='text-align:center'>" + I18n.t((String)"coser.business.publication.errorexporttitle", (Object[])new Object[]{project.getName()}) + "</h1>");
        if (includeProjectInfo) {
            this.extractProjectReport(project, out);
            this.extractHistoryCommandReport(project, container, out);
        }
        for (Map.Entry entry : validationCategoryChild.entrySet()) {
            out.write("<h2>" + (String)entry.getKey() + "</h2>");
            out.write("<ul>");
            for (ControlErrorGroup group : (List)entry.getValue()) {
                out.write("<li style='margin-bottom:20px'><span style='color:");
                switch (group.getValidationLevel()) {
                    case FATAL: {
                        out.write("rgb(88,0,0)");
                        break;
                    }
                    case ERROR: {
                        out.write("red");
                        break;
                    }
                    case WARNING: {
                        out.write("orange");
                        break;
                    }
                    case INFO: {
                        out.write("green");
                    }
                }
                out.write(";font-weight:bold'>" + I18n.t((String)group.getMessage(), (Object[])new Object[0]));
                out.write("</span>");
                out.write("<ul>");
                for (ControlError error : (List)validationErrorsChilds.get(group)) {
                    out.write("<li type='circle'>");
                    out.write(I18n.t((String)error.getDetailMessage(), (Object[])new Object[0]));
                    List<String> lineNumbers = error.getLineNumbers();
                    if (CollectionUtils.isNotEmpty(lineNumbers)) {
                        out.write(" (" + I18n.t((String)"coser.business.publication.errorexportlines", (Object[])new Object[0]) + " : ");
                        Iterator<String> itLineNumbers = lineNumbers.iterator();
                        while (itLineNumbers.hasNext()) {
                            out.write(itLineNumbers.next());
                            if (!itLineNumbers.hasNext()) continue;
                            out.write(", ");
                        }
                        out.write(")");
                    }
                    if (error instanceof DiffCatchLengthControlError) {
                        DiffCatchLengthControlError diffError = (DiffCatchLengthControlError)error;
                        String species = diffError.getSpecies();
                        out.write(" (<a href='#graph" + species + "'>" + I18n.t((String)"coser.business.publication.errorgraph", (Object[])new Object[0]) + "</a>)");
                    }
                    String tipMessage = I18n.t((String)error.getTipMessage(), (Object[])new Object[0]);
                    if (StringUtils.isNotEmpty((CharSequence)error.getTipMessage())) {
                        out.write("<p style='font-style:italic'>" + tipMessage + "</p>");
                    }
                    out.write("</li>");
                }
                out.write("</ul>");
                out.write("</li>");
            }
            out.write("</ul>");
        }
        out.write("<h2>" + I18n.t((String)"coser.business.publication.errorgraphs", (Object[])new Object[0]) + "</h2>");
        out.write("<ul>");
        for (Map.Entry<Object, Object> entry : charts.entrySet()) {
            JFreeChart chart = (JFreeChart)entry.getValue();
            File tmpChartImage = File.createTempFile("chart-", ".jpg", imageDirectory);
            tmpChartImage.deleteOnExit();
            ChartUtilities.saveChartAsJPEG((File)tmpChartImage, (JFreeChart)chart, (int)600, (int)300);
            out.write("<li><p><a name='graph" + (String)entry.getKey() + "'>");
            out.write(project.getDisplaySpeciesText((String)entry.getKey()) + "</a></p>");
            out.write("<img src='" + imageDirectory.getName() + "/" + tmpChartImage.getName() + "' /></li>");
        }
        out.write("</ul>");
        out.write("</body></html>");
    }

    public File extractControlLogAsHTML(Project project, Control control) throws CoserBusinessException {
        File exportHtmlFile = null;
        OutputStreamWriter out = null;
        try {
            exportHtmlFile = File.createTempFile("log-", ".html");
            if (log.isInfoEnabled()) {
                log.info((Object)("Generating HTML report to " + exportHtmlFile.getAbsolutePath()));
            }
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(exportHtmlFile), "utf-8");
            this.extractControlLogAsHTML(project, control, out);
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't export logs", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
        return exportHtmlFile;
    }

    protected void extractControlLogAsHTML(Project project, Control control, Writer out) throws CoserBusinessException, IOException {
        out.write("<html><head>");
        out.write("<title>" + I18n.t((String)"coser.business.publication.controllogexporttitle", (Object[])new Object[]{project.getName()}) + "</title>");
        out.write("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>");
        out.write("</head><body>");
        out.write("<h1 style='text-align:center'>" + I18n.t((String)"coser.business.publication.controllogexporttitle", (Object[])new Object[]{project.getName()}) + "</h1>");
        this.extractProjectReport(project, out);
        this.extractHistoryCommandReport(project, control, out);
        out.write("</body></html>");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractControlLogAsPDF(Project project, Control control, List<ControlError> validationErrors, File pdfFile) throws CoserBusinessException {
        FileOutputStream os = null;
        try {
            StringWriter out = new StringWriter();
            this.exportErrorsAsHTML(project, control, validationErrors, out, true);
            ((Writer)out).flush();
            Document document = CoserUtils.parseDocument(((Object)out).toString());
            os = new FileOutputStream(pdfFile);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(document, "file://" + System.getProperty("java.io.tmpdir") + "/");
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't generate log pdf", ex);
                catch (DocumentException ex2) {
                    throw new CoserBusinessException("Can't generate log pdf", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public File extractSelectionLogAsHTML(Project project, Selection selection) throws CoserBusinessException {
        File exportHtmlFile = null;
        OutputStreamWriter out = null;
        try {
            exportHtmlFile = File.createTempFile("coser-log-", ".html");
            exportHtmlFile.deleteOnExit();
            if (log.isInfoEnabled()) {
                log.info((Object)("Generating HTML report to " + exportHtmlFile.getAbsolutePath()));
            }
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(exportHtmlFile), "utf-8");
            this.extractSelectionLogAsHTML(project, selection, out);
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't export logs", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
        return exportHtmlFile;
    }

    protected void extractSelectionLogAsHTML(Project project, Selection selection, Writer out) throws IOException, CoserBusinessException {
        out.write("<html><head>");
        out.write("<title>" + I18n.t((String)"coser.business.publication.selectionlogexporttitle", (Object[])new Object[]{selection.getName(), project.getName()}) + "</title>");
        out.write("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>");
        out.write("</head><body>");
        out.write("<h1 style='text-align:center'>" + I18n.t((String)"coser.business.publication.selectionlogexporttitle", (Object[])new Object[]{selection.getName(), project.getName()}) + "</h1>");
        this.extractProjectReport(project, out);
        StringBuilder speciesBuilder = new StringBuilder(256);
        String separator = "";
        for (String speciesCode : selection.getSelectedSpecies()) {
            speciesBuilder.append(separator);
            speciesBuilder.append(project.getDisplaySpeciesText(speciesCode));
            separator = ", ";
        }
        out.write("<h2>" + I18n.t((String)"coser.business.publication.selectionchoices", (Object[])new Object[0]) + "</h2>");
        out.write("<ul>");
        out.write("<li>" + I18n.t((String)"coser.business.common.years", (Object[])new Object[0]) + " : " + StringUtils.join(selection.getSelectedYears(), (String)", ") + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.common.strata", (Object[])new Object[0]) + " : " + StringUtils.join(selection.getSelectedStrata(), (String)", ") + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.common.species", (Object[])new Object[0]) + " : " + speciesBuilder + "</li>");
        out.write("</ul>");
        this.extractHistoryCommandReport(project, selection, out);
        out.write("</body></html>");
    }

    protected void extractProjectReport(Project project, Writer out) throws IOException {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, this.config.getLocale());
        out.write("<div style='text-align:right;font-style:italic'>" + I18n.t((String)"coser.business.publication.date", (Object[])new Object[0]) + " : " + dateFormat.format(new Date()) + "</div>");
        out.write("<h2>" + I18n.t((String)"coser.business.publication.projectdetails", (Object[])new Object[0]) + "</h2>");
        out.write("<ul>");
        out.write("<li>" + I18n.t((String)"coser.business.publication.creationdate", (Object[])new Object[0]) + " : " + dateFormat.format(project.getCreationDate()) + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.publication.author", (Object[])new Object[0]) + " : " + project.getAuthor() + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.publication.catchfilename", (Object[])new Object[0]) + " : " + this.commonService.getDataStorageFileName(project, CoserConstants.Category.CATCH, null) + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.publication.lengthfilename", (Object[])new Object[0]) + " : " + this.commonService.getDataStorageFileName(project, CoserConstants.Category.LENGTH, null) + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.publication.haulfilename", (Object[])new Object[0]) + " : " + this.commonService.getDataStorageFileName(project, CoserConstants.Category.HAUL, null) + "</li>");
        out.write("<li>" + I18n.t((String)"coser.business.publication.stratafilename", (Object[])new Object[0]) + " : " + this.commonService.getDataStorageFileName(project, CoserConstants.Category.STRATA, null) + "</li>");
        if (StringUtils.isNotEmpty((CharSequence)project.getComment())) {
            out.write("<li>" + I18n.t((String)"coser.business.publication.comment", (Object[])new Object[0]) + " : " + project.getComment() + "</li>");
        }
        out.write("</ul>");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractSelectionLogAsPDF(Project project, Selection selection, File pdfFile) throws CoserBusinessException {
        FileOutputStream os = null;
        try {
            StringWriter out = new StringWriter();
            this.extractSelectionLogAsHTML(project, selection, out);
            ((Writer)out).flush();
            Document document = CoserUtils.parseDocument(((Object)out).toString());
            os = new FileOutputStream(pdfFile);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(document, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't generate log pdf", ex);
                catch (DocumentException ex2) {
                    throw new CoserBusinessException("Can't generate log pdf", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    protected void extractHistoryCommandReport(Project project, AbstractDataContainer container, Writer out) throws CoserBusinessException, IOException {
        HashSet<String> catchLines = new HashSet<String>();
        HashSet<String> lengthLines = new HashSet<String>();
        HashSet<String> haulLines = new HashSet<String>();
        HashSet<String> strataLines = new HashSet<String>();
        for (Command command : container.getHistoryCommands()) {
            CoserConstants.Category category = null;
            String line = null;
            if (command instanceof CategoryLineCommand) {
                category = ((CategoryLineCommand)command).getCategory();
                line = ((CategoryLineCommand)command).getLineNumber();
            }
            if (category == null || line == null) continue;
            switch (category) {
                case CATCH: {
                    catchLines.add(line);
                    break;
                }
                case LENGTH: {
                    lengthLines.add(line);
                    break;
                }
                case HAUL: {
                    haulLines.add(line);
                    break;
                }
                case STRATA: {
                    strataLines.add(line);
                }
            }
        }
        Map<String, String[]> catchContent = this.commonService.getOriginalContent(project, CoserConstants.Category.CATCH, catchLines);
        Map<String, String[]> lengthContent = this.commonService.getOriginalContent(project, CoserConstants.Category.LENGTH, lengthLines);
        Map<String, String[]> haulContent = this.commonService.getOriginalContent(project, CoserConstants.Category.HAUL, haulLines);
        Map<String, String[]> strataContent = this.commonService.getOriginalContent(project, CoserConstants.Category.STRATA, strataLines);
        out.write("<h2>" + I18n.t((String)"coser.business.publication.datamodification", (Object[])new Object[0]) + "</h2>");
        out.write("<ol>");
        for (Command command : container.getHistoryCommands()) {
            CoserConstants.Category category = null;
            String line = null;
            if (command instanceof CategoryLineCommand) {
                category = ((CategoryLineCommand)command).getCategory();
                line = ((CategoryLineCommand)command).getLineNumber();
            }
            out.write("<li>");
            if (category != null && line != null) {
                Object[] data = null;
                switch (category) {
                    case CATCH: {
                        data = catchContent.get(line);
                        break;
                    }
                    case LENGTH: {
                        data = lengthContent.get(line);
                        break;
                    }
                    case HAUL: {
                        data = haulContent.get(line);
                        break;
                    }
                    case STRATA: {
                        data = strataContent.get(line);
                    }
                }
                out.write(command.getLogString(project, container) + "<br/>");
                out.write("<tt style='color:#5F5A59'>" + StringUtils.join((Object[])data, (String)", ") + "</tt>");
            } else {
                out.write(command.getLogString(project, container));
            }
            if (StringUtils.isNotEmpty((CharSequence)command.getComment())) {
                out.write("<br /><i>" + command.getComment() + "</i>");
            }
            out.write("</li>");
        }
        out.write("</ol>");
    }

    public File getRsufiResultComChart(Project project, File resultDirectory, RSufiResult rsufiResult, File codeTypeEspecesFile, String indicator, String list, String zoneDisplayName, String indicatorName, String unit, Locale locale) throws CoserBusinessException {
        File result = null;
        File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading estComIndFile : " + estComIndFile));
        }
        DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
        String localList = list;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching list for indicator : " + indicator));
        }
        int multiplicator = 1;
        int minYear = Integer.MAX_VALUE;
        int maxYear = Integer.MIN_VALUE;
        boolean indicatorFound = false;
        HashMap<Integer, Double[]> graphData = new HashMap<Integer, Double[]>();
        Iterator<String[]> estComIndIterator = dataStorage.iterator(true);
        while (estComIndIterator.hasNext()) {
            String[] tuple = estComIndIterator.next();
            String indicatorCode = tuple[1];
            String indicatorList = tuple[2];
            if (!indicatorCode.equals(indicator)) continue;
            indicatorFound = true;
            if (StringUtils.isBlank((CharSequence)localList)) {
                localList = indicatorList;
            }
            if (!indicatorList.equals(localList)) continue;
            Double estimation = Double.parseDouble(tuple[5]);
            Double ecart = Double.parseDouble(tuple[6]);
            int year = Integer.parseInt(tuple[4]);
            if (year < minYear) {
                minYear = year;
            }
            if (year > maxYear) {
                maxYear = year;
            }
            graphData.put(year, new Double[]{estimation, ecart});
            if (estimation > 1.0E9) {
                multiplicator = 1000000;
            }
            if (!(estimation > 1000000.0) || multiplicator >= 1000000) continue;
            multiplicator = 1000;
        }
        if (indicatorFound) {
            String chartTitle = zoneDisplayName;
            chartTitle = chartTitle + " - " + indicatorName;
            String listLetter = String.valueOf(localList.charAt(0));
            DataStorage dataStorageType = this.commonService.loadCSVFile(codeTypeEspecesFile, ';');
            Iterator<String[]> typeIterator = dataStorageType.iterator(true);
            while (typeIterator.hasNext()) {
                String[] tuple = typeIterator.next();
                if (!tuple[4].equals(listLetter)) continue;
                if (tuple[4].equalsIgnoreCase("T")) {
                    if ("fr".equals(locale.getLanguage())) {
                        chartTitle = chartTitle + " - Tous Liste " + localList.charAt(1);
                        break;
                    }
                    if ("es".equals(locale.getLanguage())) {
                        chartTitle = chartTitle + " - Todo Lista " + localList.charAt(1);
                        break;
                    }
                    chartTitle = chartTitle + " - All List " + localList.charAt(1);
                    break;
                }
                if ("fr".equals(locale.getLanguage())) {
                    chartTitle = chartTitle + " - " + tuple[0] + " Liste " + localList.charAt(1);
                    break;
                }
                if ("es".equals(locale.getLanguage())) {
                    chartTitle = chartTitle + " - " + tuple[0] + " Lista " + localList.charAt(1);
                    break;
                }
                chartTitle = chartTitle + " - " + tuple[0] + " List " + localList.charAt(1);
                break;
            }
            DefaultStatisticalCategoryDataset statisticalDataset = new DefaultStatisticalCategoryDataset();
            for (int indexYear = minYear; indexYear <= maxYear; ++indexYear) {
                Double[] entry = (Double[])graphData.get(indexYear);
                if (entry != null) {
                    Double estimation = entry[0] / (double)multiplicator;
                    Double ecart = entry[1] / (double)multiplicator;
                    statisticalDataset.add((Number)estimation, (Number)ecart, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
                    continue;
                }
                statisticalDataset.add(null, null, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
            }
            String yearAxis = "Year";
            if ("fr".equals(locale.getLanguage())) {
                yearAxis = "Ann\u00e9e";
            } else if ("es".equals(locale.getLanguage())) {
                yearAxis = "A\u00f1o";
            }
            CategoryAxis categoryAxis = new CategoryAxis(yearAxis);
            categoryAxis.setCategoryMargin(0.0);
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            String legendY = indicatorName;
            if (multiplicator != 1) {
                legendY = legendY + " (" + unit + "*" + multiplicator + ")";
            } else if (StringUtils.isNotEmpty((CharSequence)unit)) {
                legendY = legendY + " (" + unit + ")";
            }
            NumberAxis valueAxis = new NumberAxis(legendY);
            valueAxis.setUpperMargin(0.1);
            StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(false, true);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)statisticalDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(PlotOrientation.VERTICAL);
            JFreeChart chart = new JFreeChart(chartTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.removeLegend();
            chart.setBackgroundPaint((Paint)Color.WHITE);
            try {
                result = File.createTempFile("coser-chart-", ".png");
                result.deleteOnExit();
                ChartUtilities.saveChartAsPNG((File)result, (JFreeChart)chart, (int)800, (int)400);
            }
            catch (IOException ex) {
                throw new CoserBusinessException("Can't save chart", ex);
            }
        }
        return result;
    }

    public File getRsufiResultPopChart(Project project, File resultDirectory, RSufiResult rsufiResult, String species, String indicator, String zoneDisplayName, String indicatorName, String unit, Locale locale) throws CoserBusinessException {
        File result = null;
        File estPopIndFile = new File(resultDirectory, rsufiResult.getEstPopIndName());
        DataStorage dataStorage = this.commonService.loadCSVFile(estPopIndFile, '\t');
        int multiplicator = 1;
        int minYear = Integer.MAX_VALUE;
        int maxYear = Integer.MIN_VALUE;
        boolean indicatorFound = false;
        HashMap<Integer, Double[]> graphData = new HashMap<Integer, Double[]>();
        Iterator<String[]> estPopIndIterator = dataStorage.iterator(true);
        while (estPopIndIterator.hasNext()) {
            String[] tuple = estPopIndIterator.next();
            String speciesCode = tuple[3];
            String indicatorCode = tuple[1];
            if (!speciesCode.equals(species) || !indicatorCode.equals(indicator)) continue;
            indicatorFound = true;
            Double estimation = Double.parseDouble(tuple[6]);
            Double ecart = Double.parseDouble(tuple[7]);
            int year = Integer.parseInt(tuple[5]);
            if (year < minYear) {
                minYear = year;
            }
            if (year > maxYear) {
                maxYear = year;
            }
            graphData.put(year, new Double[]{estimation, ecart});
            if (estimation > 1.0E9) {
                multiplicator = 1000000;
            }
            if (!(estimation > 1000000.0) || multiplicator >= 1000000) continue;
            multiplicator = 1000;
        }
        if (indicatorFound) {
            String title = zoneDisplayName;
            title = title + " - " + indicatorName;
            title = title + " - " + this.commonService.getReportDisplayName(project, species);
            DefaultStatisticalCategoryDataset statisticalDataset = new DefaultStatisticalCategoryDataset();
            for (int indexYear = minYear; indexYear <= maxYear; ++indexYear) {
                Double[] entry = (Double[])graphData.get(indexYear);
                if (entry != null) {
                    Double estimation = entry[0] / (double)multiplicator;
                    Double ecart = entry[1] / (double)multiplicator;
                    statisticalDataset.add((Number)estimation, (Number)ecart, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
                    continue;
                }
                statisticalDataset.add(null, null, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
            }
            String yearAxis = "Year";
            if ("fr".equals(locale.getLanguage())) {
                yearAxis = "Ann\u00e9e";
            } else if ("es".equals(locale.getLanguage())) {
                yearAxis = "Ann\u00e9e";
            }
            CategoryAxis categoryAxis = new CategoryAxis(yearAxis);
            categoryAxis.setCategoryMargin(0.0);
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            String legendY = indicatorName;
            if (multiplicator != 1) {
                legendY = legendY + " (" + unit + "*" + multiplicator + ")";
            } else if (StringUtils.isNotEmpty((CharSequence)unit)) {
                legendY = legendY + " (" + unit + ")";
            }
            NumberAxis valueAxis = new NumberAxis(legendY);
            valueAxis.setUpperMargin(0.1);
            StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(false, true);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)statisticalDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(PlotOrientation.VERTICAL);
            JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.removeLegend();
            chart.setBackgroundPaint((Paint)Color.WHITE);
            try {
                result = File.createTempFile("coser-chart-", ".png");
                result.deleteOnExit();
                ChartUtilities.saveChartAsPNG((File)result, (JFreeChart)chart, (int)800, (int)400);
            }
            catch (IOException ex) {
                throw new CoserBusinessException("Can't save chart", ex);
            }
        }
        return result;
    }

    public Map<String, Object[]> getRsufiResultComCharts(Project project, File resultDirectory, RSufiResult rsufiResult, File codeTypeEspecesFile, Collection<String> indicators, String zoneDisplayName, MultiKeyMap indicatorMap, Locale locale, int width, int height) throws CoserBusinessException {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading estComIndFile : " + estComIndFile));
        }
        DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
        int multiplicator = 1;
        int minYear = Integer.MAX_VALUE;
        int maxYear = Integer.MIN_VALUE;
        HashMap<String, HashMap<Integer, Double[]>> indicatorGraphData = new HashMap<String, HashMap<Integer, Double[]>>();
        HashMap<String, String> indicatorLists = new HashMap<String, String>();
        HashMap<String, DataStorage> indicatorStorages = new HashMap<String, DataStorage>();
        Iterator<String[]> estComIndIterator = dataStorage.iterator(false);
        String[] headers = estComIndIterator.next();
        while (estComIndIterator.hasNext()) {
            DataStorage subDataStorage;
            HashMap<Integer, Double[]> graphData;
            String[] tuple = estComIndIterator.next();
            String indicatorCode = tuple[1];
            String indicatorList = tuple[2];
            if (!indicators.contains(indicatorCode)) continue;
            String localList = (String)indicatorLists.get(indicatorCode);
            if (StringUtils.isBlank((CharSequence)localList)) {
                localList = indicatorList;
                indicatorLists.put(indicatorCode, localList);
            }
            if (!indicatorList.equals(localList)) continue;
            Double estimation = Double.parseDouble(tuple[5]);
            Double ecart = Double.parseDouble(tuple[6]);
            int year = Integer.parseInt(tuple[4]);
            if (year < minYear) {
                minYear = year;
            }
            if (year > maxYear) {
                maxYear = year;
            }
            if ((graphData = (HashMap<Integer, Double[]>)indicatorGraphData.get(indicatorCode)) == null) {
                graphData = new HashMap<Integer, Double[]>();
                indicatorGraphData.put(indicatorCode, graphData);
            }
            graphData.put(year, new Double[]{estimation, ecart});
            if (estimation > 1.0E9) {
                multiplicator = 1000000;
            }
            if (estimation > 1000000.0 && multiplicator < 1000000) {
                multiplicator = 1000;
            }
            if ((subDataStorage = (DataStorage)indicatorStorages.get(indicatorCode)) == null) {
                subDataStorage = new MemoryDataStorage();
                if ("fr".equals(locale.getLanguage())) {
                    subDataStorage.add(new String[]{"Campagne", "Indice", "Liste", "Strate", "Ann\u00e9e", "Estimation", "EcartType", "CV"});
                } else {
                    subDataStorage.add(new String[]{"Survey", "Index", "List", "Stratum", "Year", "Estimate", "StandardDeviation", "CV"});
                }
                indicatorStorages.put(indicatorCode, subDataStorage);
            }
            subDataStorage.add(tuple);
        }
        for (String indicator : indicatorGraphData.keySet()) {
            String chartTitle = zoneDisplayName;
            String indicatorName = (String)indicatorMap.get((Object)indicator, (Object)locale.getLanguage());
            String unit = (String)indicatorMap.get((Object)indicator, (Object)"unit");
            chartTitle = chartTitle + " - " + indicatorName;
            String localList = (String)indicatorLists.get(indicator);
            String listLetter = String.valueOf(localList.charAt(0));
            DataStorage dataStorageType = this.commonService.loadCSVFile(codeTypeEspecesFile, ';');
            Iterator<String[]> typeIterator = dataStorageType.iterator(true);
            while (typeIterator.hasNext()) {
                String[] tuple = typeIterator.next();
                if (!tuple[4].equals(listLetter)) continue;
                if (tuple[4].equalsIgnoreCase("T")) {
                    if ("fr".equals(locale.getLanguage())) {
                        chartTitle = chartTitle + " - Tous Liste " + localList.charAt(1);
                        break;
                    }
                    if ("es".equals(locale.getLanguage())) {
                        chartTitle = chartTitle + " - Todo Lista " + localList.charAt(1);
                        break;
                    }
                    chartTitle = chartTitle + " - All List " + localList.charAt(1);
                    break;
                }
                if ("fr".equals(locale.getLanguage())) {
                    chartTitle = chartTitle + " - " + tuple[0] + " Liste " + localList.charAt(1);
                    break;
                }
                if ("es".equals(locale.getLanguage())) {
                    chartTitle = chartTitle + " - " + tuple[0] + " Lista " + localList.charAt(1);
                    break;
                }
                chartTitle = chartTitle + " - " + tuple[0] + " List " + localList.charAt(1);
                break;
            }
            Map graphData = (Map)indicatorGraphData.get(indicator);
            DefaultStatisticalCategoryDataset statisticalDataset = new DefaultStatisticalCategoryDataset();
            for (int indexYear = minYear; indexYear <= maxYear; ++indexYear) {
                Double[] entry = (Double[])graphData.get(indexYear);
                if (entry != null) {
                    Double estimation = entry[0] / (double)multiplicator;
                    Double ecart = entry[1] / (double)multiplicator;
                    statisticalDataset.add((Number)estimation, (Number)ecart, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
                    continue;
                }
                statisticalDataset.add(null, null, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
            }
            String yearAxis = "Year";
            if ("fr".equals(locale.getLanguage())) {
                yearAxis = "Ann\u00e9e";
            } else if ("es".equals(locale.getLanguage())) {
                yearAxis = "A\u00f1o";
            }
            CategoryAxis categoryAxis = new CategoryAxis(yearAxis);
            categoryAxis.setCategoryMargin(0.0);
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            String legendY = indicatorName;
            if (multiplicator != 1) {
                legendY = legendY + " (" + unit + "*" + multiplicator + ")";
            } else if (StringUtils.isNotEmpty((CharSequence)unit)) {
                legendY = legendY + " (" + unit + ")";
            }
            NumberAxis valueAxis = new NumberAxis(legendY);
            valueAxis.setUpperMargin(0.1);
            StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(false, true);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)statisticalDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(PlotOrientation.VERTICAL);
            JFreeChart chart = new JFreeChart(chartTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.removeLegend();
            chart.setBackgroundPaint((Paint)Color.WHITE);
            try {
                File chartFile = File.createTempFile("coser-chart-", ".png");
                chartFile.deleteOnExit();
                ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)chart, (int)width, (int)height);
                DataStorage subDataStorage = (DataStorage)indicatorStorages.get(indicator);
                StringWriter writer = new StringWriter();
                this.commonService.storeDataWhithoutQuote(subDataStorage, writer, null, null);
                result.put(indicator, new Object[]{chartFile, writer.toString()});
            }
            catch (IOException ex) {
                throw new CoserBusinessException("Can't save chart", ex);
            }
        }
        return result;
    }

    public Map<String, Object[]> getRsufiResultPopCharts(Project project, File resultDirectory, RSufiResult rsufiResult, Collection<String> species, Collection<String> indicators, String zoneDisplayName, MultiKeyMap indicatorMap, Locale locale, int width, int height) throws CoserBusinessException {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        File estPopIndFile = new File(resultDirectory, rsufiResult.getEstPopIndName());
        DataStorage dataStorage = this.commonService.loadCSVFile(estPopIndFile, '\t');
        int multiplicator = 1;
        int minYear = Integer.MAX_VALUE;
        int maxYear = Integer.MIN_VALUE;
        MultiKeyMap indicatorGraphData = new MultiKeyMap();
        MultiKeyMap indicatorStorages = new MultiKeyMap();
        Iterator<String[]> estPopIndIterator = dataStorage.iterator(true);
        while (estPopIndIterator.hasNext()) {
            DataStorage subDataStorage;
            HashMap<Integer, Double[]> graphData;
            String[] tuple = estPopIndIterator.next();
            String speciesCode = tuple[3];
            String indicatorCode = tuple[1];
            if (!species.contains(speciesCode) || !indicators.contains(indicatorCode)) continue;
            Double estimation = Double.parseDouble(tuple[6]);
            Double ecart = Double.parseDouble(tuple[7]);
            int year = Integer.parseInt(tuple[5]);
            if (year < minYear) {
                minYear = year;
            }
            if (year > maxYear) {
                maxYear = year;
            }
            if ((graphData = (HashMap<Integer, Double[]>)indicatorGraphData.get((Object)indicatorCode, (Object)speciesCode)) == null) {
                graphData = new HashMap<Integer, Double[]>();
                indicatorGraphData.put((Object)indicatorCode, (Object)speciesCode, graphData);
            }
            graphData.put(year, new Double[]{estimation, ecart});
            if (estimation > 1.0E9) {
                multiplicator = 1000000;
            }
            if (estimation > 1000000.0 && multiplicator < 1000000) {
                multiplicator = 1000;
            }
            if ((subDataStorage = (DataStorage)indicatorStorages.get((Object)indicatorCode, (Object)speciesCode)) == null) {
                subDataStorage = new MemoryDataStorage();
                if ("fr".equals(locale.getLanguage())) {
                    subDataStorage.add(new String[]{"Campagne", "Indice", "Liste", "Esp\u00e8ce", "Strate", "Annee", "Estimation", "EcartType", "CV"});
                } else {
                    subDataStorage.add(new String[]{"Survey", "Index", "List", "Species", "Stratum", "Year", "Estimate", "StandardDeviation", "CV"});
                }
                indicatorStorages.put((Object)indicatorCode, (Object)speciesCode, (Object)subDataStorage);
            }
            subDataStorage.add(tuple);
        }
        for (MultiKey indicatorSpecies : indicatorGraphData.keySet()) {
            String indicator = (String)indicatorSpecies.getKey(0);
            String aSpecies = (String)indicatorSpecies.getKey(1);
            String title = zoneDisplayName;
            String indicatorName = (String)indicatorMap.get((Object)indicator, (Object)locale.getLanguage());
            String unit = (String)indicatorMap.get((Object)indicator, (Object)"unit");
            title = title + " - " + indicatorName;
            title = title + " - " + this.commonService.getReportDisplayName(project, aSpecies);
            DefaultStatisticalCategoryDataset statisticalDataset = new DefaultStatisticalCategoryDataset();
            Map graphData = (Map)indicatorGraphData.get((Object)indicator, (Object)aSpecies);
            for (int indexYear = minYear; indexYear <= maxYear; ++indexYear) {
                Double[] entry = (Double[])graphData.get(indexYear);
                if (entry != null) {
                    Double estimation = entry[0] / (double)multiplicator;
                    Double ecart = entry[1] / (double)multiplicator;
                    statisticalDataset.add((Number)estimation, (Number)ecart, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
                    continue;
                }
                statisticalDataset.add(null, null, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
            }
            String yearAxis = "Year";
            if ("fr".equals(locale.getLanguage())) {
                yearAxis = "Ann\u00e9e";
            } else if ("es".equals(locale.getLanguage())) {
                yearAxis = "Ann\u00e9e";
            }
            CategoryAxis categoryAxis = new CategoryAxis(yearAxis);
            categoryAxis.setCategoryMargin(0.0);
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            String legendY = indicatorName;
            if (multiplicator != 1) {
                legendY = legendY + " (" + unit + "*" + multiplicator + ")";
            } else if (StringUtils.isNotEmpty((CharSequence)unit)) {
                legendY = legendY + " (" + unit + ")";
            }
            NumberAxis valueAxis = new NumberAxis(legendY);
            valueAxis.setUpperMargin(0.1);
            StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(false, true);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)statisticalDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(PlotOrientation.VERTICAL);
            JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.removeLegend();
            chart.setBackgroundPaint((Paint)Color.WHITE);
            try {
                File chartFile = File.createTempFile("coser-chart-", ".png");
                chartFile.deleteOnExit();
                ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)chart, (int)width, (int)height);
                DataStorage subDataStorage = (DataStorage)indicatorStorages.get((Object)indicator, (Object)aSpecies);
                StringWriter writer = new StringWriter();
                this.commonService.storeDataWhithoutQuote(subDataStorage, writer, null, null);
                result.put(indicator + "-" + aSpecies, new Object[]{chartFile, writer.toString()});
            }
            catch (IOException ex) {
                throw new CoserBusinessException("Can't save chart", ex);
            }
        }
        return result;
    }

    public File getRsufiResultComChartData(File resultDirectory, RSufiResult rsufiResult, String indicator, String list) throws CoserBusinessException {
        File result = null;
        try {
            result = File.createTempFile("coser-chart-", ".csv");
            result.deleteOnExit();
            File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
            DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
            MemoryDataStorage subDataStorage = new MemoryDataStorage();
            Iterator estComIndIterator = dataStorage.iterator();
            String[] headers = (String[])estComIndIterator.next();
            subDataStorage.add(headers);
            String localList = list;
            while (estComIndIterator.hasNext()) {
                String[] tuple = (String[])estComIndIterator.next();
                String indicatorCode = tuple[1];
                String indicatorList = tuple[2];
                if (!indicatorCode.equals(indicator)) continue;
                if (StringUtils.isBlank((CharSequence)localList)) {
                    localList = indicatorList;
                }
                if (!indicatorList.equals(localList)) continue;
                subDataStorage.add(tuple);
            }
            this.commonService.storeDataWhithoutQuote((DataStorage)subDataStorage, result, null, null);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't save csv file", ex);
        }
        return result;
    }

    public File getRsufiResultPopChartData(File resultDirectory, RSufiResult rsufiResult, String species, String indicator) throws CoserBusinessException {
        File result = null;
        try {
            result = File.createTempFile("coser-graph-", ".csv");
            result.deleteOnExit();
            File estPopIndFile = new File(resultDirectory, rsufiResult.getEstPopIndName());
            DataStorage dataStorage = this.commonService.loadCSVFile(estPopIndFile, '\t');
            MemoryDataStorage subDataStorage = new MemoryDataStorage();
            Iterator estPopIndIterator = dataStorage.iterator();
            String[] headers = (String[])estPopIndIterator.next();
            subDataStorage.add(headers);
            String localList = null;
            while (estPopIndIterator.hasNext()) {
                String[] tuple = (String[])estPopIndIterator.next();
                String indicatorCode = tuple[1];
                String indicatorList = tuple[2];
                String speciesCode = tuple[3];
                if (!speciesCode.equals(species) || !indicatorCode.equals(indicator)) continue;
                if (StringUtils.isBlank(localList)) {
                    localList = indicatorList;
                }
                if (!indicatorList.equals(localList)) continue;
                subDataStorage.add(tuple);
            }
            this.commonService.storeDataWhithoutQuote((DataStorage)subDataStorage, result, null, null);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't save csv file", ex);
        }
        return result;
    }
}

