/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.util;

import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.CoserRequestContext;
import fr.ifremer.coser.result.result.ExtractRawDataAndResultsResult;
import fr.ifremer.coser.result.util.Reports;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ZipUtil;

public class Extracts {
    private static final Log log = LogFactory.getLog(Extracts.class);

    public File assemblyExtractResult(CoserRequestContext context, File extractDirectory, List<String> zoneList, List<ExtractRawDataAndResultsResult> results) {
        Locale locale = context.getLocale();
        MultiKeyMap pdfMaps = new MultiKeyMap();
        MultiKeyMap pdfCharts = new MultiKeyMap();
        for (ExtractRawDataAndResultsResult result : results) {
            Pair<MultiKeyMap<String, File>, MultiKeyMap<String, Pair<File, String>>> repositoryResult = result.getResult();
            MultiKeyMap pdfMap = (MultiKeyMap)repositoryResult.getLeft();
            MultiKeyMap pdfChart = (MultiKeyMap)repositoryResult.getRight();
            if (MapUtils.isNotEmpty((Map)pdfMap)) {
                pdfMaps.putAll((Map)pdfMap);
            }
            if (!MapUtils.isNotEmpty((Map)pdfChart)) continue;
            pdfCharts.putAll((Map)pdfChart);
        }
        Reports reports = context.getReports();
        if (MapUtils.isNotEmpty((Map)pdfMaps) || MapUtils.isNotEmpty((Map)pdfCharts)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Generated Extract PDF");
            }
            reports.generateExtractPDF(extractDirectory, zoneList, (MultiKeyMap<String, File>)pdfMaps, (MultiKeyMap<String, Pair<File, String>>)pdfCharts, context.getZoneMap(), locale);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Generated decharge PDF");
        }
        String filename = Reports.getDechargeFilename(locale);
        File dechargePDF = new File(extractDirectory, filename);
        Date lastDataUpdateDate = context.getConfig().getLastDataUpdateDate();
        reports.generateDechargePDF(dechargePDF, locale, lastDataUpdateDate, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Make final archive");
        }
        try {
            File resultZip = File.createTempFile("coser-extract-", ".zip");
            resultZip.deleteOnExit();
            ZipUtil.compress((File)resultZip, (File)extractDirectory);
            FileUtils.deleteDirectory((File)extractDirectory.getParentFile());
            File file = resultZip;
            return file;
        }
        catch (IOException ex) {
            throw new CoserTechnicalException("Can't create zip file", ex);
        }
        finally {
            FileUtils.deleteQuietly((File)extractDirectory.getParentFile());
        }
    }
}

