/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.result.ResultRepositoryInitializationException;
import fr.ifremer.coser.result.ResultType;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.repository.ResultRepositoryProvider;
import fr.ifremer.coser.result.repository.echobase.EchoBaseResultRepositoryProvider;
import fr.ifremer.coser.result.repository.legacy.LegacyResultRepositoryProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoserMainRepositoryProvider {
    private static final Log log = LogFactory.getLog(CoserMainRepositoryProvider.class);
    protected final Set<ResultRepositoryProvider<?>> repositoryProviders;
    protected Set<ResultRepository> repositories;

    public static Set<ResultRepositoryProvider<?>> createDefaultRepositoryProviders(CoserBusinessConfig config) {
        Preconditions.checkNotNull((Object)((Object)config));
        HashSet result = Sets.newHashSet();
        Preconditions.checkNotNull((Object)config.getWebMapsProjectsDirectory());
        result.add(new LegacyResultRepositoryProvider(config, config.getWebMapsProjectsDirectory(), ResultType.MAP));
        Preconditions.checkNotNull((Object)config.getWebIndicatorsProjectsDirectory());
        result.add(new LegacyResultRepositoryProvider(config, config.getWebIndicatorsProjectsDirectory(), ResultType.INDICATOR));
        Preconditions.checkNotNull((Object)config.getWebEchobaseProjectsDirectory());
        result.add(new EchoBaseResultRepositoryProvider(config.getWebEchobaseProjectsDirectory()));
        return result;
    }

    public CoserMainRepositoryProvider(Set<ResultRepositoryProvider<?>> repositoryProviders) {
        Preconditions.checkNotNull(repositoryProviders);
        this.repositoryProviders = Collections.unmodifiableSet(repositoryProviders);
    }

    public Set<ResultRepositoryProvider<?>> getRepositoryProviders() {
        return this.repositoryProviders;
    }

    public void resetRepositories() {
        this.repositories = null;
    }

    public Set<ResultRepository> getResultRepositories() {
        if (this.repositories == null) {
            HashSet ids = Sets.newHashSet();
            HashSet resultRepositories = Sets.newHashSet();
            for (ResultRepositoryProvider<?> repositoryProvider : this.repositoryProviders) {
                Set<ResultRepository> repos = this.loadFromRepositoryProvider(repositoryProvider, ids);
                resultRepositories.addAll(repos);
            }
            this.repositories = Collections.unmodifiableSet(resultRepositories);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + this.repositories.size() + " result repository(ies)."));
            }
        }
        return this.repositories;
    }

    protected Set<ResultRepository> loadFromRepositoryProvider(ResultRepositoryProvider<?> repositoryProvider, Set<String> ids) {
        Set<?> resultRepositories = repositoryProvider.loadRepositories();
        HashSet result = Sets.newHashSet();
        for (ResultRepository resultRepository : resultRepositories) {
            String id = resultRepository.getId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try to register result Repository: " + id));
            }
            if (!ids.add(id)) {
                throw new ResultRepositoryInitializationException(repositoryProvider, "Duplicate result repository with id: " + id, null);
            }
            result.add(resultRepository);
        }
        return result;
    }
}

