/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractEntity;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.bean.SpeciesFieldType;
import fr.ifremer.coser.storage.DataStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Project
extends AbstractEntity {
    private static final long serialVersionUID = 8372568232663922521L;
    public static final String[] REFTAX_SPECIES_HEADER = new String[]{"C_Perm", "NumSys", "NivSys", "C_VALIDE", "L_VALIDE", "AA_VALIDE", "C_TxP\u00e8re", "Taxa"};
    public static final String[] TYPE_ESPECE_HEADER = new String[]{"Types", "Commentaire", "NumSys min", "NumSys max", "Code"};
    public static final String PROPERTY_SELECTIONS = "selections";
    protected String name;
    protected String author;
    protected String catchFile;
    protected String haulFile;
    protected String lengthFile;
    protected String strataFile;
    protected String catchFileName;
    protected String haulFileName;
    protected String lengthFileName;
    protected String strataFileName;
    protected List<File> maps;
    protected String comment;
    protected Date creationDate;
    protected Control control;
    protected Map<String, Selection> selections;
    protected DataStorage refTaxSpecies;
    protected LinkedHashMap<String, String> refTaxSpeciesMap;
    protected DataStorage typeEspeces;
    protected SpeciesFieldType storageSpeciesType = SpeciesFieldType.C_Valide;
    protected SpeciesFieldType displaySpeciesType = SpeciesFieldType.C_Valide;
    protected SpeciesFieldType outputSpeciesType = SpeciesFieldType.C_Valide;

    public Project() {
    }

    public Project(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.getPropertyChangeSupport().firePropertyChange("name", oldValue, name);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        String oldValue = this.author;
        this.author = author;
        this.getPropertyChangeSupport().firePropertyChange("author", oldValue, author);
    }

    public String getCatchFile() {
        return this.catchFile;
    }

    public void setCatchFile(String catchFile) {
        String oldValue = this.catchFile;
        this.catchFile = catchFile;
        this.getPropertyChangeSupport().firePropertyChange("catchFile", oldValue, catchFile);
    }

    public String getHaulFile() {
        return this.haulFile;
    }

    public void setHaulFile(String haulFile) {
        String oldValue = this.haulFile;
        this.haulFile = haulFile;
        this.getPropertyChangeSupport().firePropertyChange("haulFile", oldValue, haulFile);
    }

    public String getLengthFile() {
        return this.lengthFile;
    }

    public void setLengthFile(String lengthFile) {
        String oldValue = this.lengthFile;
        this.lengthFile = lengthFile;
        this.getPropertyChangeSupport().firePropertyChange("lengthFile", oldValue, lengthFile);
    }

    public String getStrataFile() {
        return this.strataFile;
    }

    public void setStrataFile(String strataFile) {
        String oldValue = this.strataFile;
        this.strataFile = strataFile;
        this.getPropertyChangeSupport().firePropertyChange("strataFile", oldValue, strataFile);
    }

    public String getCatchFileName() {
        return this.catchFileName;
    }

    public void setCatchFileName(String catchFileName) {
        this.catchFileName = catchFileName;
    }

    public String getHaulFileName() {
        return this.haulFileName;
    }

    public void setHaulFileName(String haulFileName) {
        this.haulFileName = haulFileName;
    }

    public String getLengthFileName() {
        return this.lengthFileName;
    }

    public void setLengthFileName(String lengthFileName) {
        this.lengthFileName = lengthFileName;
    }

    public String getStrataFileName() {
        return this.strataFileName;
    }

    public void setStrataFileName(String strataFileName) {
        this.strataFileName = strataFileName;
    }

    public void setMaps(List<File> maps) {
        this.maps = maps;
    }

    public List<File> getMaps() {
        return this.maps;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.getPropertyChangeSupport().firePropertyChange("comment", oldValue, comment);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        Control oldValue = this.control;
        this.control = control;
        this.getPropertyChangeSupport().firePropertyChange("control", oldValue, control);
    }

    public Map<String, Selection> getSelections() {
        return this.selections;
    }

    public void setSelections(Map<String, Selection> selections) {
        this.selections = selections;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SELECTIONS, null, selections);
    }

    public void addSelections(Selection selection) {
        this.selections.put(selection.getName(), selection);
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SELECTIONS, null, this.selections);
    }

    public DataStorage getRefTaxSpecies() {
        return this.refTaxSpecies;
    }

    public void setRefTaxSpecies(DataStorage refTaxSpecies) {
        this.refTaxSpecies = refTaxSpecies;
    }

    public LinkedHashMap<String, String> getRefTaxSpeciesMap() {
        return this.refTaxSpeciesMap;
    }

    public void setRefTaxSpeciesMap(LinkedHashMap<String, String> refTaxSpeciesMap) {
        this.refTaxSpeciesMap = refTaxSpeciesMap;
    }

    public String getDisplaySpeciesText(String speciesCode) {
        String speciesText = speciesCode;
        if (this.refTaxSpeciesMap.containsKey(speciesCode)) {
            speciesText = this.refTaxSpeciesMap.get(speciesCode);
        }
        return speciesText;
    }

    public DataStorage getTypeEspeces() {
        return this.typeEspeces;
    }

    public void setTypeEspeces(DataStorage typeEspeces) {
        this.typeEspeces = typeEspeces;
    }

    public SpeciesFieldType getStorageSpeciesType() {
        return this.storageSpeciesType;
    }

    public void setStorageSpeciesType(SpeciesFieldType storageSpeciesType) {
        SpeciesFieldType oldValue = this.storageSpeciesType;
        this.storageSpeciesType = storageSpeciesType;
        this.getPropertyChangeSupport().firePropertyChange("storageSpeciesType", (Object)oldValue, (Object)storageSpeciesType);
    }

    public SpeciesFieldType getDisplaySpeciesType() {
        return this.displaySpeciesType;
    }

    public void setDisplaySpeciesType(SpeciesFieldType displaySpeciesType) {
        SpeciesFieldType oldValue = this.displaySpeciesType;
        this.displaySpeciesType = displaySpeciesType;
        this.getPropertyChangeSupport().firePropertyChange("displaySpeciesType", (Object)oldValue, (Object)displaySpeciesType);
    }

    public SpeciesFieldType getOutputSpeciesType() {
        return this.outputSpeciesType;
    }

    public void setOutputSpeciesType(SpeciesFieldType outputSpeciesType) {
        SpeciesFieldType oldValue = this.outputSpeciesType;
        this.outputSpeciesType = outputSpeciesType;
        this.getPropertyChangeSupport().firePropertyChange("outputSpeciesType", (Object)oldValue, (Object)outputSpeciesType);
    }

    public void clearData() {
        if (this.control != null) {
            this.control.clearData();
        }
        if (this.selections != null) {
            for (Selection selection : this.selections.values()) {
                selection.clearData();
            }
        }
    }

    public Properties toProperties() {
        Properties props = new Properties();
        if (this.author != null) {
            props.setProperty("project.author", this.author);
        }
        if (this.catchFileName != null) {
            props.setProperty("project.catchFileName", this.catchFileName);
        }
        if (this.lengthFileName != null) {
            props.setProperty("project.lengthFileName", this.lengthFileName);
        }
        if (this.haulFileName != null) {
            props.setProperty("project.haulFileName", this.haulFileName);
        }
        if (this.strataFileName != null) {
            props.setProperty("project.strataFileName", this.strataFileName);
        }
        if (CollectionUtils.isNotEmpty(this.maps)) {
            StringBuilder mapsAsString = new StringBuilder();
            Iterator<File> itMaps = this.maps.iterator();
            while (itMaps.hasNext()) {
                mapsAsString.append(itMaps.next().getName());
                if (!itMaps.hasNext()) continue;
                mapsAsString.append(',');
            }
            props.setProperty("project.maps", mapsAsString.toString());
        }
        if (this.comment != null) {
            props.setProperty("project.comment", this.comment);
        }
        if (this.creationDate != null) {
            props.setProperty("project.creationdate", String.valueOf(this.creationDate.getTime()));
        }
        if (this.storageSpeciesType != null) {
            props.setProperty("project.storageSpeciesType", this.storageSpeciesType.toString());
        }
        if (this.displaySpeciesType != null) {
            props.setProperty("project.displaySpeciesType", this.displaySpeciesType.toString());
        }
        if (this.outputSpeciesType != null) {
            props.setProperty("project.outputSpeciesType", this.outputSpeciesType.toString());
        }
        return props;
    }

    public void fromProperties(Properties props, File mapDirectory) {
        if (props.containsKey("project.author")) {
            this.setAuthor(props.getProperty("project.author"));
        }
        if (props.containsKey("project.catchFileName")) {
            this.setCatchFileName(props.getProperty("project.catchFileName"));
        }
        if (props.containsKey("project.lengthFileName")) {
            this.setLengthFileName(props.getProperty("project.lengthFileName"));
        }
        if (props.containsKey("project.haulFileName")) {
            this.setHaulFileName(props.getProperty("project.haulFileName"));
        }
        if (props.containsKey("project.strataFileName")) {
            this.setStrataFileName(props.getProperty("project.strataFileName"));
        }
        if (StringUtils.isNotBlank((CharSequence)props.getProperty("project.maps"))) {
            List<String> mapsAsString = CoserUtils.splitAsList(props.getProperty("project.maps"));
            ArrayList<File> maps = new ArrayList<File>();
            for (String mapAsString : mapsAsString) {
                File mapFile = new File(mapDirectory, mapAsString);
                maps.add(mapFile);
            }
            this.setMaps(maps);
        }
        if (props.containsKey("project.comment")) {
            this.setComment(props.getProperty("project.comment"));
        }
        if (props.containsKey("project.creationdate")) {
            Date date = new Date(Long.parseLong(props.getProperty("project.creationdate")));
            this.setCreationDate(date);
        }
        if (props.containsKey("project.storageSpeciesType")) {
            this.setStorageSpeciesType(SpeciesFieldType.valueOf(props.getProperty("project.storageSpeciesType")));
        } else {
            this.setStorageSpeciesType(SpeciesFieldType.C_Valide);
        }
        if (props.containsKey("project.displaySpeciesType")) {
            this.setDisplaySpeciesType(SpeciesFieldType.valueOf(props.getProperty("project.displaySpeciesType")));
        } else {
            this.setDisplaySpeciesType(SpeciesFieldType.C_Valide);
        }
        if (props.containsKey("project.outputSpeciesType")) {
            this.setOutputSpeciesType(SpeciesFieldType.valueOf(props.getProperty("project.outputSpeciesType")));
        } else {
            this.setOutputSpeciesType(SpeciesFieldType.C_Valide);
        }
    }

    public String getDataStorageFileName(CoserConstants.Category category, String suffix) {
        String result = null;
        switch (category) {
            case CATCH: {
                result = this.getCatchFileName();
                break;
            }
            case HAUL: {
                result = this.getHaulFileName();
                break;
            }
            case LENGTH: {
                result = this.getLengthFileName();
                break;
            }
            case STRATA: {
                result = this.getStrataFileName();
            }
        }
        if (suffix != null) {
            result = CoserUtils.addSuffixBeforeExtension(result, suffix);
        }
        return result;
    }
}

