/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarApp = angular.module("coselmarApp", ['ngRoute', 'ngResource', 'ngMessages', 'angular-jwt', 'coselmarControllers', 'coselmarServices']);

coselmarApp.config(['$routeProvider', function($routeProvider) {
    $routeProvider
    //documents
    .when('/documents', {
        controller : 'DocumentsCtrl',
        templateUrl : 'views/documents/documents.html'

    }).when('/documents/new', {
        controller : 'NewDocumentCtrl',
        templateUrl : 'views/documents/newdocument.html'

    }).when('/documents/:documentId', {
        controller : 'DocumentViewCtrl',
        templateUrl : 'views/documents/document.html'

    //users
    }).when('/users', {
        controller : 'UsersCtrl',
        templateUrl : 'views/users/users.html'

    }).when('/users/new', {
        controller : 'NewUserCtrl',
        templateUrl : 'views/users/newuser.html'

    }).when('/users/:userId', {
        controller : 'UserViewCtrl',
        templateUrl : 'views/users/user.html'

    }).otherwise({
        redirectTo: '/',
        templateUrl : 'views/home.html'
    });
}]);

// Inject Json Web Token if present in all request
coselmarApp.config(function Config($httpProvider, jwtInterceptorProvider) {
	jwtInterceptorProvider.tokenGetter = function() {
    	return localStorage.getItem('coselmar-jwt');
  	}
  	$httpProvider.interceptors.push('jwtInterceptor');
})