/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.conditions;

import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.ConditionGroup;
import de.huxhorn.sulky.conditions.ConditionWrapper;
import java.util.List;

public final class Conditions {
    private Conditions() {
    }

    public static boolean contains(Condition condition, Condition otherCondition) {
        if (condition == null) {
            return false;
        }
        if (condition.equals(otherCondition)) {
            return true;
        }
        if (condition instanceof ConditionWrapper) {
            ConditionWrapper conditionWrapper = (ConditionWrapper)condition;
            Condition wrappedCondition = conditionWrapper.getCondition();
            if (wrappedCondition == null) {
                return false;
            }
            return Conditions.contains(wrappedCondition, otherCondition);
        }
        if (condition instanceof ConditionGroup) {
            ConditionGroup conditionGroup = (ConditionGroup)condition;
            List<Condition> conditions = conditionGroup.getConditions();
            if (conditions == null) {
                return false;
            }
            for (Condition c : conditions) {
                if (!Conditions.contains(c, otherCondition)) continue;
                return true;
            }
        }
        return false;
    }
}

