/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6320441996003349426L;
    public static final String CAUSED_BY_PREFIX = "Caused by: ";
    public static final String SUPPRESSED_PREFIX = "Suppressed: ";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String name;
    private String message;
    private ExtendedStackTraceElement[] stackTrace;
    private int omittedElements;
    private ThrowableInfo[] suppressed;
    private ThrowableInfo cause;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExtendedStackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(ExtendedStackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public ThrowableInfo[] getSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(ThrowableInfo[] suppressed) {
        this.suppressed = suppressed;
    }

    public ThrowableInfo getCause() {
        return this.cause;
    }

    public void setCause(ThrowableInfo cause) {
        this.cause = cause;
    }

    public int getOmittedElements() {
        return this.omittedElements;
    }

    public void setOmittedElements(int omittedElements) {
        this.omittedElements = omittedElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrowableInfo that = (ThrowableInfo)o;
        if (this.omittedElements != that.omittedElements) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (!Arrays.equals(this.stackTrace, that.stackTrace)) {
            return false;
        }
        if (!Arrays.equals(this.suppressed, that.suppressed)) {
            return false;
        }
        return !(this.cause == null ? that.cause != null : !this.cause.equals(that.cause));
    }

    public int hashCode() {
        int result = this.omittedElements;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 29 * result + (this.suppressed != null ? Arrays.hashCode(this.suppressed) : 0);
        result = 29 * result + (this.cause != null ? this.cause.hashCode() : 0);
        return result;
    }

    public ThrowableInfo clone() throws CloneNotSupportedException {
        Cloneable current;
        int i;
        ThrowableInfo result = (ThrowableInfo)super.clone();
        if (this.stackTrace != null) {
            result.stackTrace = new ExtendedStackTraceElement[this.stackTrace.length];
            for (i = 0; i < this.stackTrace.length; ++i) {
                current = this.stackTrace[i];
                if (current == null) continue;
                result.stackTrace[i] = ((ExtendedStackTraceElement)current).clone();
            }
        }
        if (this.suppressed != null) {
            result.suppressed = new ThrowableInfo[this.suppressed.length];
            for (i = 0; i < this.suppressed.length; ++i) {
                current = this.suppressed[i];
                if (current == null) continue;
                result.suppressed[i] = ((ThrowableInfo)current).clone();
            }
        }
        if (this.cause != null) {
            result.cause = this.cause.clone();
        }
        return result;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean extended) {
        return this.appendTo(null, extended).toString();
    }

    public StringBuilder appendTo(StringBuilder result, boolean extended) {
        if (result == null) {
            result = new StringBuilder();
        }
        HashSet<ThrowableInfo> dejaVu = new HashSet<ThrowableInfo>();
        ThrowableInfo.recursiveAppend(result, dejaVu, null, 0, this, extended);
        return result;
    }

    private static void recursiveAppend(StringBuilder sb, Set<ThrowableInfo> dejaVu, String prefix, int indent, ThrowableInfo throwableInfo, boolean extended) {
        String name;
        if (throwableInfo == null) {
            return;
        }
        ThrowableInfo.appendIndent(sb, indent);
        if (prefix != null) {
            sb.append(prefix);
        }
        if ((name = throwableInfo.getName()) != null) {
            sb.append(name);
            String message = throwableInfo.getMessage();
            if (message != null && !name.equals(message)) {
                sb.append(": ").append(throwableInfo.getMessage());
            }
        } else {
            sb.append(throwableInfo.getMessage());
        }
        if (dejaVu.contains(throwableInfo)) {
            sb.append("[CIRCULAR REFERENCE]");
            return;
        }
        dejaVu.add(throwableInfo);
        sb.append(LINE_SEPARATOR);
        ThrowableInfo.appendSTEArray(sb, indent + 1, throwableInfo, extended);
        ThrowableInfo[] suppressed = throwableInfo.getSuppressed();
        if (suppressed != null) {
            for (ThrowableInfo current : suppressed) {
                ThrowableInfo.recursiveAppend(sb, dejaVu, SUPPRESSED_PREFIX, indent + 1, current, extended);
            }
        }
        ThrowableInfo.recursiveAppend(sb, dejaVu, CAUSED_BY_PREFIX, indent, throwableInfo.getCause(), extended);
    }

    private static void appendIndent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
    }

    private static void appendSTEArray(StringBuilder sb, int indentLevel, ThrowableInfo throwableInfo, boolean extended) {
        ExtendedStackTraceElement[] steArray = throwableInfo.getStackTrace();
        int commonFrames = throwableInfo.getOmittedElements();
        if (steArray != null) {
            for (int i = 0; i < steArray.length; ++i) {
                ExtendedStackTraceElement ste = steArray[i];
                if (ste == null) continue;
                ThrowableInfo.appendIndent(sb, indentLevel);
                sb.append("at ");
                ste.appendTo(sb, extended);
                sb.append(LINE_SEPARATOR);
            }
        }
        if (commonFrames > 0) {
            ThrowableInfo.appendIndent(sb, indentLevel);
            sb.append("... ").append(commonFrames).append(" more").append(LINE_SEPARATOR);
        }
    }
}

