/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marker
implements Serializable {
    private static final long serialVersionUID = -4828769420328139691L;
    private String name;
    private Map<String, Marker> references;

    public Marker() {
        this("Marker");
    }

    public Marker(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Markername must not be null!");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Marker> getReferences() {
        if (this.references == null) {
            return null;
        }
        return new HashMap<String, Marker>(this.references);
    }

    public void remove(Marker marker) {
        if (this.references != null) {
            this.references.remove(marker.getName());
        }
    }

    public void add(Marker marker) {
        if (this.references == null) {
            this.references = new HashMap<String, Marker>();
        }
        if (!this.references.containsKey(marker.getName())) {
            this.references.put(marker.getName(), marker);
        }
    }

    public void setReferences(Map<String, Marker> references) {
        this.references = references;
    }

    public boolean hasReferences() {
        return this.references != null && this.references.size() != 0;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(other.name)) {
            return true;
        }
        if (this.hasReferences()) {
            Set<String> collectedMarkers = Marker.collectMarkerNames(this, null);
            return collectedMarkers.contains(other.getName());
        }
        return false;
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            return this.collectMarkerNames().contains(name);
        }
        return false;
    }

    public Set<String> collectMarkerNames() {
        return Marker.collectMarkerNames(this, null);
    }

    private static Set<String> collectMarkerNames(Marker marker, Set<String> collectedMarkerNames) {
        if (collectedMarkerNames == null) {
            collectedMarkerNames = new HashSet<String>();
        }
        if (!collectedMarkerNames.contains(marker.getName())) {
            collectedMarkerNames.add(marker.getName());
            if (marker.hasReferences()) {
                for (Map.Entry<String, Marker> current : marker.getReferences().entrySet()) {
                    Marker child = current.getValue();
                    if (collectedMarkerNames.contains(child.getName())) continue;
                    Marker.collectMarkerNames(child, collectedMarkerNames);
                }
            }
        }
        return collectedMarkerNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marker marker = (Marker)o;
        return !(this.name == null ? marker.name != null : !this.name.equals(marker.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }
}

