/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.xml;

import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.xml.LoggingEventSchemaConstants;
import de.huxhorn.lilith.data.logging.xml.StackTraceElementReader;
import de.huxhorn.sulky.stax.DateTimeFormatter;
import de.huxhorn.sulky.stax.GenericStreamReader;
import de.huxhorn.sulky.stax.StaxUtilities;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventReader
implements GenericStreamReader<LoggingEvent>,
LoggingEventSchemaConstants {
    private DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private StackTraceElementReader steReader = new StackTraceElementReader();

    public LoggingEvent read(XMLStreamReader reader) throws XMLStreamException {
        LoggingEvent result = null;
        String rootNamespace = "http://lilith.sf.net/schema/logging/14";
        int type = reader.getEventType();
        if (7 == type) {
            reader.nextTag();
            type = reader.getEventType();
            rootNamespace = null;
        }
        if (1 == type && "LoggingEvent".equals(reader.getLocalName())) {
            result = new LoggingEvent();
            result.setLogger(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"logger"));
            result.setLevel(LoggingEvent.Level.valueOf((String)StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"level")));
            String sequence = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"sequence");
            if (sequence != null) {
                try {
                    result.setSequenceNumber(Long.valueOf(Long.parseLong(sequence)));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            String threadName = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"threadName");
            String threadIdStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"threadId");
            String threadGroupName = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"threadGroup");
            String threadGroupIdStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"threadGroupId");
            Long threadId = null;
            if (threadIdStr != null) {
                try {
                    threadId = Long.valueOf(threadIdStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            Long threadGroupId = null;
            if (threadGroupIdStr != null) {
                try {
                    threadGroupId = Long.valueOf(threadGroupIdStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (threadName != null || threadId != null || threadGroupName != null || threadGroupId != null) {
                result.setThreadInfo(new ThreadInfo(threadId, threadName, threadGroupId, threadGroupName));
            }
            result.setTimeStamp(this.readTimeStamp(reader, "timeStampMillis", "timeStamp"));
            reader.nextTag();
            Message message = null;
            String messagePattern = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"Message");
            List<String> args = this.readArguments(reader);
            if (messagePattern != null || args != null) {
                message = args != null ? new Message(messagePattern, args.toArray(new String[args.size()])) : new Message(messagePattern);
            }
            result.setMessage(message);
            this.readThrowable(reader, result);
            result.setMdc(this.readMdc(reader));
            result.setNdc(this.readNdc(reader));
            this.readMarker(reader, result);
            this.readCallStack(reader, result);
            result.setLoggerContext(this.readLoggerContext(reader));
            reader.require(2, null, "LoggingEvent");
        }
        return result;
    }

    private Long readTimeStamp(XMLStreamReader reader, String millisName, String formattedName) {
        String timeStampStr;
        Long timeStamp = null;
        String timeStampMillis = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)millisName);
        if (timeStampMillis != null) {
            try {
                timeStamp = Long.parseLong(timeStampMillis);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (timeStamp == null && (timeStampStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)formattedName)) != null) {
            try {
                timeStamp = this.dateTimeFormatter.parse(timeStampStr).getTime();
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return timeStamp;
    }

    private LoggerContext readLoggerContext(XMLStreamReader reader) throws XMLStreamException {
        LoggerContext result = null;
        int type = reader.getEventType();
        if (1 == type && "LoggerContext".equals(reader.getLocalName())) {
            result = new LoggerContext();
            result.setName(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"name"));
            result.setBirthTime(this.readTimeStamp(reader, "birthTimeMillis", "birthTime"));
            reader.nextTag();
            result.setProperties(this.readLoggerContextProperties(reader));
            reader.require(2, null, "LoggerContext");
            reader.nextTag();
        }
        return result;
    }

    private Map<String, String> readLoggerContextProperties(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Properties".equals(reader.getLocalName())) {
            StringMapEntry entry;
            HashMap<String, String> map = new HashMap<String, String>();
            reader.nextTag();
            while ((entry = this.readStringMapEntry(reader)) != null) {
                map.put(entry.key, entry.value);
            }
            reader.require(2, null, "Properties");
            reader.nextTag();
            return map;
        }
        return null;
    }

    private void readCallStack(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        event.setCallStack(this.readStackTraceNode(reader, "CallStack"));
    }

    private ExtendedStackTraceElement[] readStackTraceNode(XMLStreamReader reader, String nodeName) throws XMLStreamException {
        int type = reader.getEventType();
        ArrayList<ExtendedStackTraceElement> ste = new ArrayList<ExtendedStackTraceElement>();
        if (1 == type && nodeName.equals(reader.getLocalName())) {
            ExtendedStackTraceElement elem;
            reader.nextTag();
            while ((elem = this.steReader.read(reader)) != null) {
                reader.nextTag();
                ste.add(elem);
            }
            reader.require(2, null, nodeName);
            reader.nextTag();
            return ste.toArray(new ExtendedStackTraceElement[ste.size()]);
        }
        return null;
    }

    private void readMarker(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Marker".equals(reader.getLocalName())) {
            HashMap<String, Marker> markers = new HashMap<String, Marker>();
            Marker marker = this.recursiveReadMarker(reader, markers);
            event.setMarker(marker);
        }
    }

    private Marker recursiveReadMarker(XMLStreamReader reader, Map<String, Marker> markers) throws XMLStreamException {
        Marker marker = null;
        int type = reader.getEventType();
        if (1 == type && "Marker".equals(reader.getLocalName())) {
            Marker child;
            String name = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"name");
            marker = new Marker(name);
            markers.put(name, marker);
            reader.nextTag();
            while ((child = this.recursiveReadMarker(reader, markers)) != null) {
                markers.put(child.getName(), child);
                marker.add(child);
            }
            reader.require(2, null, "Marker");
            reader.nextTag();
        } else if (1 == type && "MarkerReference".equals(reader.getLocalName())) {
            String ref = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"ref");
            marker = markers.get(ref);
            reader.nextTag();
            reader.require(2, null, "MarkerReference");
            reader.nextTag();
        }
        return marker;
    }

    private Map<String, String> readMdc(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "MDC".equals(reader.getLocalName())) {
            StringMapEntry entry;
            HashMap<String, String> mdc = new HashMap<String, String>();
            reader.nextTag();
            while ((entry = this.readStringMapEntry(reader)) != null) {
                mdc.put(entry.key, entry.value);
            }
            reader.require(2, null, "MDC");
            reader.nextTag();
            return mdc;
        }
        return null;
    }

    private Message[] readNdc(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "NDC".equals(reader.getLocalName())) {
            Message entry;
            ArrayList<Message> ndc = new ArrayList<Message>();
            reader.nextTag();
            while ((entry = this.readNdcEntry(reader)) != null) {
                ndc.add(entry);
            }
            reader.require(2, null, "NDC");
            reader.nextTag();
            return ndc.toArray(new Message[ndc.size()]);
        }
        return null;
    }

    private StringMapEntry readStringMapEntry(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Entry".equals(reader.getLocalName())) {
            StringMapEntry entry = new StringMapEntry();
            entry.key = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"key");
            entry.value = StaxUtilities.readText((XMLStreamReader)reader);
            reader.require(2, null, "Entry");
            reader.nextTag();
            return entry;
        }
        return null;
    }

    private Message readNdcEntry(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Entry".equals(reader.getLocalName())) {
            reader.nextTag();
            Message entry = new Message();
            entry.setMessagePattern(StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"Message"));
            List<String> args = this.readArguments(reader);
            if (args != null) {
                entry.setArguments(args.toArray(new String[args.size()]));
            }
            reader.require(2, null, "Entry");
            reader.nextTag();
            return entry;
        }
        return null;
    }

    private void readThrowable(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        event.setThrowable(this.recursiveReadThrowable(reader, "Throwable"));
    }

    private ThrowableInfo recursiveReadThrowable(XMLStreamReader reader, String nodeName) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && nodeName.equals(reader.getLocalName())) {
            ThrowableInfo throwable = new ThrowableInfo();
            String name = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"name");
            throwable.setName(name);
            String omittedStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/14", (String)"omittedElements");
            if (omittedStr != null) {
                try {
                    int omitted = Integer.parseInt(omittedStr);
                    throwable.setOmittedElements(omitted);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            reader.nextTag();
            throwable.setMessage(StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"Message"));
            throwable.setStackTrace(this.readStackTraceNode(reader, "StackTrace"));
            type = reader.getEventType();
            if (1 == type && "Suppressed".equals(reader.getLocalName())) {
                ThrowableInfo current;
                reader.nextTag();
                ArrayList<ThrowableInfo> suppressedList = new ArrayList<ThrowableInfo>();
                while ((current = this.recursiveReadThrowable(reader, "Throwable")) != null) {
                    suppressedList.add(current);
                }
                ThrowableInfo[] suppressed = new ThrowableInfo[suppressedList.size()];
                suppressed = suppressedList.toArray(suppressed);
                throwable.setSuppressed(suppressed);
                reader.require(2, null, "Suppressed");
                reader.nextTag();
            }
            throwable.setCause(this.recursiveReadThrowable(reader, "Cause"));
            reader.require(2, null, nodeName);
            reader.nextTag();
            return throwable;
        }
        return null;
    }

    private List<String> readArguments(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Arguments".equals(reader.getLocalName())) {
            reader.nextTag();
            ArrayList<String> args = new ArrayList<String>();
            while (true) {
                if (2 == (type = reader.getEventType()) && "Arguments".equals(reader.getLocalName())) break;
                String arg = this.readArgument(reader);
                args.add(arg);
            }
            reader.nextTag();
            return args;
        }
        return null;
    }

    private String readArgument(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "null".equals(reader.getLocalName())) {
            reader.nextTag();
            reader.require(2, null, "null");
            reader.nextTag();
            return null;
        }
        return StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"Argument");
    }

    private static class StringMapEntry {
        public String key;
        public String value;

        private StringMapEntry() {
        }
    }
}

