/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.json.LoggingModule;
import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingJsonEncoder
implements Encoder<LoggingEvent> {
    private boolean compressing;
    private boolean indenting;
    private boolean sortingProperties;
    private ObjectMapper mapper = new ObjectMapper();

    public LoggingJsonEncoder(boolean compressing) {
        this(compressing, false, false);
    }

    public LoggingJsonEncoder(boolean compressing, boolean indenting, boolean sortingProperties) {
        this.mapper.registerModule((Module)new LoggingModule());
        this.mapper.registerModule((Module)new AfterburnerModule());
        this.setCompressing(compressing);
        this.setIndenting(indenting);
        this.setSortingProperties(sortingProperties);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, indenting);
    }

    public boolean isSortingProperties() {
        return this.sortingProperties;
    }

    public void setSortingProperties(boolean sortingProperties) {
        this.sortingProperties = sortingProperties;
        this.mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, sortingProperties);
    }

    public byte[] encode(LoggingEvent event) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            if (!this.compressing) {
                this.mapper.writeValue((OutputStream)output, (Object)event);
                return output.toByteArray();
            }
            GZIPOutputStream gzos = new GZIPOutputStream(output);
            this.mapper.writeValue((OutputStream)gzos, (Object)event);
            gzos.flush();
            gzos.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

