/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import it.sauronsoftware.junique.Connection;
import it.sauronsoftware.junique.ConnectionListener;
import it.sauronsoftware.junique.MessageHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

class Server
implements Runnable,
ConnectionListener {
    private String id;
    private MessageHandler messageHandler;
    private Object synchLock = new Object();
    private ServerSocket serverSocket = null;
    private Thread thread = null;
    private ArrayList connections = new ArrayList();

    public Server(String string, MessageHandler messageHandler) {
        this.id = string;
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.serverSocket != null) {
                throw new IllegalStateException("JUnique/Server for id \"" + this.id + "\" already started");
            }
            try {
                this.serverSocket = new ServerSocket();
                InetAddress inetAddress = InetAddress.getLocalHost();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, 0);
                this.serverSocket.bind(inetSocketAddress);
            }
            catch (IOException iOException) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw new RuntimeException("Unexpected IOException while starting JUnique/Server for id \"" + this.id + "\"", iOException);
            }
            this.thread = new Thread((Runnable)this, "JUnique/Server/" + this.id);
            this.thread.setDaemon(true);
            this.thread.start();
            while (true) {
                try {
                    this.synchLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.serverSocket == null) {
                throw new IllegalStateException("JUnique/Server for id \"" + this.id + "\" not started");
            }
            while (this.connections.size() > 0) {
                Connection connection = (Connection)this.connections.remove(0);
                connection.stop();
            }
            this.thread.interrupt();
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.serverSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.synchLock;
        synchronized (object) {
            this.synchLock.notify();
        }
        while (!Thread.interrupted()) {
            try {
                object = this.serverSocket.accept();
                Connection connection = new Connection(this.id, (Socket)object, this);
                Object object2 = this.synchLock;
                synchronized (object2) {
                    this.connections.add(connection);
                    connection.start();
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenedPort() throws IllegalStateException {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.serverSocket == null) {
                throw new IllegalStateException("JUnique/Server for id \"" + this.id + "\" not started");
            }
            return this.serverSocket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String messageReceived(Connection connection, String string) {
        if (this.messageHandler != null) {
            MessageHandler messageHandler = this.messageHandler;
            synchronized (messageHandler) {
                return this.messageHandler.handle(string);
            }
        }
        return null;
    }
}

