/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;

public class LocalArtifactStore {
    public static boolean checkArtifact(IDownloadConfig runtime, Distribution distribution) {
        return LocalArtifactStore.getArtifact(runtime, distribution) != null;
    }

    public static boolean store(IDownloadConfig runtime, Distribution distribution, File download) {
        File dir = LocalArtifactStore.createOrGetBaseDir(runtime);
        String artifactFileName = runtime.getPackageResolver().getPath(distribution);
        File artifactFile = new File(dir, artifactFileName);
        LocalArtifactStore.createOrCheckDir(artifactFile.getParentFile());
        if (!Files.moveFile(download, artifactFile)) {
            throw new IllegalArgumentException("Could not move " + download + " to " + artifactFile);
        }
        File checkFile = new File(dir, artifactFileName);
        return checkFile.exists() & checkFile.isFile() & checkFile.canRead();
    }

    private static File createOrGetBaseDir(IDownloadConfig runtime) {
        File dir = new File(runtime.getArtifactStorePathNaming().getPath());
        LocalArtifactStore.createOrCheckDir(dir);
        return dir;
    }

    private static void createOrCheckDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Could NOT create Directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("" + dir + " is not a Directory");
        }
    }

    public static File getArtifact(IDownloadConfig runtime, Distribution distribution) {
        File dir = LocalArtifactStore.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, runtime.getPackageResolver().getPath(distribution));
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile;
        }
        return null;
    }
}

