/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class Network {
    private static Logger logger = Logger.getLogger(Network.class.getName());
    public static final int IP_LENGTH = 4;

    private Network() {
        throw new IllegalAccessError("singleton");
    }

    public static boolean localhostIsIPv6() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        byte[] ipAddr = addr.getAddress();
        return ipAddr.length > 4;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress ret = InetAddress.getLocalHost();
        if (!ret.isLoopbackAddress() && !(ret = InetAddress.getByName("localhost")).isLoopbackAddress()) {
            logger.severe("" + ret.getHostAddress() + " is not a loopback address");
        }
        return ret;
    }

    public static int getFreeServerPort() throws IOException {
        return Network.getFreeServerPort(Network.getLocalHost());
    }

    public static int getFreeServerPort(InetAddress hostAdress) throws IOException {
        ServerSocket socket = new ServerSocket(0, 0, hostAdress);
        int ret = socket.getLocalPort();
        socket.close();
        return ret;
    }
}

