/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1;

import com.webcohesion.enunciate.CompletionFailureException;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicProviderModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeDetectingModule;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.Jackson1ApiRegistry;
import com.webcohesion.enunciate.modules.jackson1.model.AccessorVisibilityChecker;
import com.webcohesion.enunciate.modules.jackson1.model.types.KnownJsonType;
import com.webcohesion.enunciate.util.MediaTypeUtils;
import com.webcohesion.enunciate.util.OneTimeLogMessage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.codehaus.jackson.annotate.JacksonAnnotation;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.reflections.adapters.MetadataAdapter;

public class Jackson1Module
extends BasicProviderModule
implements TypeDetectingModule,
MediaTypeDefinitionModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private boolean jacksonDetected = false;
    private boolean jaxbSupportDetected = false;
    private EnunciateJackson1Context jacksonContext;
    private ApiRegistry apiRegistry;

    public String getName() {
        return "jackson1";
    }

    public boolean isHonorJaxbAnnotations() {
        return this.config.getBoolean("[@honorJaxb]", this.jaxbSupportDetected);
    }

    public boolean isCollapseTypeHierarchy() {
        return this.config.getBoolean("[@collapse-type-hierarchy]", false);
    }

    public boolean isWrapRootValue() {
        return this.config.getBoolean("[@wrapRootValue]", false);
    }

    public boolean isPropertiesAlphabetical() {
        return this.config.getBoolean("[@propertiesAlphabetical]", false);
    }

    public String getPropertyNamingStrategy() {
        return this.config.getString("[@propertyNamingStrategy]", null);
    }

    public KnownJsonType getDateFormat() {
        String dateFormatString = this.config.getString("[@dateFormat]", KnownJsonType.WHOLE_NUMBER.name());
        KnownJsonType knownType = KnownJsonType.valueOf(dateFormatString.toUpperCase());
        if (knownType == KnownJsonType.STRING) {
            knownType = KnownJsonType.DATE_STRING;
        }
        return knownType;
    }

    public boolean isDisableExamples() {
        return this.config.getBoolean("[@disableExamples]", false);
    }

    public ApiRegistry getApiRegistry() {
        return new Jackson1ApiRegistry(this.jacksonContext);
    }

    public EnunciateJackson1Context getJacksonContext() {
        return this.jacksonContext;
    }

    public void call(EnunciateContext context) {
        this.jacksonContext = new EnunciateJackson1Context(context, this.isHonorJaxbAnnotations(), this.getDateFormat(), this.isCollapseTypeHierarchy(), this.getMixins(), this.getExternalExamples(), this.getDefaultVisibility(), this.isDisableExamples(), this.isWrapRootValue(), this.getPropertyNamingStrategy(), this.isPropertiesAlphabetical());
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        switch (detectionStrategy) {
            case aggressive: {
                for (Element declaration : context.getApiElements()) {
                    this.addPotentialJacksonElement(declaration, new LinkedList<Element>());
                }
                break;
            }
            case local: {
                for (Element declaration : context.getLocalApiElements()) {
                    this.addPotentialJacksonElement(declaration, new LinkedList<Element>());
                }
            }
            default: {
                if (!context.hasExplicitIncludes()) break;
                for (Element declaration : context.getApiElements()) {
                    this.addPotentialJacksonElement(declaration, new LinkedList<Element>());
                }
            }
        }
    }

    protected boolean isEnabledByDefault() {
        return this.jacksonDetected && super.isEnabledByDefault();
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.defaultDataTypeDetectionStrategy == null ? ApiRegistryProviderModule.DataTypeDetectionStrategy.local : this.defaultDataTypeDetectionStrategy;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public void addDataTypeDefinitions(TypeMirror type, Set<String> declaredMediaTypes, LinkedList<Element> contextStack) {
        if (MediaTypeUtils.isJsonCompatible(declaredMediaTypes)) {
            type = this.jacksonContext.resolveSyntheticType((DecoratedTypeMirror)type);
            this.jacksonContext.addReferencedTypeDefinitions(type, contextStack);
        } else {
            this.debug("Element %s is NOT to be added as a Jackson data type because %s doesn't seem to include JSON.", new Object[]{type, declaredMediaTypes});
        }
    }

    public Map<String, String> getMixins() {
        HashMap<String, String> mixins = new HashMap<String, String>();
        List mixinElements = this.config.configurationsAt("mixin");
        for (HierarchicalConfiguration mixinElement : mixinElements) {
            mixins.put(mixinElement.getString("[@target]", ""), mixinElement.getString("[@source]", ""));
        }
        return mixins;
    }

    public Map<String, String> getExternalExamples() {
        HashMap<String, String> examples = new HashMap<String, String>();
        List exampleElements = this.config.configurationsAt("examples.example");
        for (HierarchicalConfiguration exampleElement : exampleElements) {
            examples.put(exampleElement.getString("[@type]", ""), exampleElement.getString("[@example]", "..."));
        }
        return examples;
    }

    public AccessorVisibilityChecker getDefaultVisibility() {
        List visibilityElements = this.config.configurationsAt("accessor-visibility");
        AccessorVisibilityChecker checker = AccessorVisibilityChecker.DEFAULT_CHECKER;
        for (HierarchicalConfiguration visibilityElement : visibilityElements) {
            JsonMethod method = JsonMethod.valueOf((String)visibilityElement.getString("[@type]", "").toUpperCase());
            JsonAutoDetect.Visibility visibility = JsonAutoDetect.Visibility.valueOf((String)visibilityElement.getString("[@visibility]", "").toUpperCase());
            checker = checker.withVisibility(method, visibility);
        }
        return checker;
    }

    protected void addPotentialJacksonElement(Element declaration, LinkedList<Element> contextStack) {
        try {
            if (declaration instanceof TypeElement && !this.jacksonContext.isKnownTypeDefinition((TypeElement)declaration) && this.isExplicitTypeDefinition(declaration, this.jacksonContext.isHonorJaxb())) {
                OneTimeLogMessage.JACKSON_1_DEPRECATED.log(this.context);
                this.jacksonContext.add(this.jacksonContext.createTypeDefinition((TypeElement)declaration), contextStack);
            }
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().endsWith("CompletionFailure")) {
                contextStack = new LinkedList<Element>(contextStack);
                contextStack.push(declaration);
                throw new CompletionFailureException(contextStack, (Throwable)e);
            }
            throw e;
        }
    }

    protected boolean isExplicitTypeDefinition(Element declaration, boolean honorJaxb) {
        if (declaration.getKind() != ElementKind.CLASS && declaration.getKind() != ElementKind.ENUM) {
            this.debug("%s isn't a potential Jackson type because it's not a class or an enum.", new Object[]{declaration});
            return false;
        }
        PackageElement pckg = this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration);
        if (pckg != null && pckg.getAnnotation(Ignore.class) != null) {
            this.debug("%s isn't a potential Jackson type because its package is annotated as to be ignored.", new Object[]{declaration});
            return false;
        }
        if (this.isThrowable(declaration)) {
            this.debug("%s isn't a potential Jackson type because it's an instance of java.lang.Throwable.", new Object[]{declaration});
            return false;
        }
        List<? extends AnnotationMirror> annotationMirrors = declaration.getAnnotationMirrors();
        boolean explicitXMLTypeOrElement = false;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element annotationDeclaration = annotationMirror.getAnnotationType().asElement();
            if (annotationDeclaration != null) {
                String fqn;
                String string = fqn = annotationDeclaration instanceof TypeElement ? ((TypeElement)annotationDeclaration).getQualifiedName().toString() : "";
                if (JsonIgnore.class.getName().equals(fqn) || fqn.startsWith("javax.xml.ws") || fqn.startsWith("javax.ws.rs") || fqn.startsWith("javax.jws")) {
                    this.debug("%s isn't a potential Jackson type because of annotation %s.", new Object[]{declaration, fqn});
                    return false;
                }
                if (honorJaxb) {
                    if (XmlTransient.class.getName().equals(fqn)) {
                        this.debug("%s isn't a potential Jackson type because of annotation %s.", new Object[]{declaration, fqn});
                        return false;
                    }
                    if (XmlType.class.getName().equals(fqn) || XmlRootElement.class.getName().equals(fqn)) {
                        this.debug("%s will be considered a Jackson type because we're honoring the %s annotation.", new Object[]{declaration, fqn});
                        explicitXMLTypeOrElement = true;
                    }
                }
                boolean bl = explicitXMLTypeOrElement = explicitXMLTypeOrElement || this.isJacksonSerializationAnnotation(fqn);
            }
            if (!explicitXMLTypeOrElement) continue;
            break;
        }
        return explicitXMLTypeOrElement;
    }

    protected boolean isThrowable(Element declaration) {
        return declaration.getKind() == ElementKind.CLASS && ((DecoratedTypeMirror)declaration.asType()).isInstanceOf(Throwable.class);
    }

    public boolean internal(Object type, MetadataAdapter metadata) {
        String classname = metadata.getClassName(type);
        this.jacksonDetected |= ObjectMapper.class.getName().equals(classname);
        this.jaxbSupportDetected |= "org.codehaus.jackson.xc.JaxbAnnotationIntrospector".equals(classname);
        return classname.startsWith("org.codehaus.jackson");
    }

    public boolean typeDetected(Object type, MetadataAdapter metadata) {
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String fqn : classAnnotations) {
                if (!this.isJacksonSerializationAnnotation(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isJacksonSerializationAnnotation(String fqn) {
        return !JacksonAnnotation.class.getName().equals(fqn) && JsonSerialize.class.getName().equals(fqn);
    }
}

