/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.integration.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.ClasspathBuilder;
import org.codehaus.mojo.gwt.ClasspathBuilderException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateWidgetsetMojo
extends AbstractMojo {
    public static final String WIDGETSET_BUILDER_CLASS = "com.vaadin.terminal.gwt.widgetsetutils.WidgetSetBuilder";
    public static final String GWT_MODULE_EXTENSION = ".gwt.xml";
    private MavenProject project;
    private String[] modules;
    private String module;
    private File sourceDirectory;
    private String extraJvmArgs;
    private String jvm;
    protected ClasspathBuilder classpathBuilder;
    protected StreamConsumer out = new StreamConsumer(){

        public void consumeLine(String line) {
            UpdateWidgetsetMojo.this.getLog().info((CharSequence)line);
        }
    };
    protected StreamConsumer err = new StreamConsumer(){

        public void consumeLine(String line) {
            UpdateWidgetsetMojo.this.getLog().error((CharSequence)line);
        }
    };

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"GWT compilation is skipped");
            return;
        }
        String[] modules = this.getModules();
        if (modules.length > 0) {
            for (String module : modules) {
                this.updateWidgetset(module);
            }
        } else {
            this.getLog().info((CharSequence)"No widgetsets to update.");
            this.getLog().info((CharSequence)"To create a widgetset, define a non-existing module in your pom.xml .");
        }
    }

    private void updateWidgetset(String module) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Updating widgetset " + module));
        JavaCommand cmd = new JavaCommand(WIDGETSET_BUILDER_CLASS).withinScope("compile");
        cmd.arg(module);
        cmd.execute();
    }

    public String[] getModules() {
        if (this.module != null) {
            return new String[]{this.module};
        }
        if (this.modules == null) {
            HashSet<String> mods = new HashSet<String>();
            if (this.sourceDirectory.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(this.sourceDirectory.getAbsolutePath());
                scanner.setIncludes(new String[]{"**/*.gwt.xml"});
                scanner.scan();
                mods.addAll(Arrays.asList(scanner.getIncludedFiles()));
            }
            List resources = this.project.getResources();
            for (Resource resource : resources) {
                File resourceDirectoryFile = new File(resource.getDirectory());
                if (!resourceDirectoryFile.exists()) continue;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(resource.getDirectory());
                scanner.setIncludes(new String[]{"**/*.gwt.xml"});
                scanner.scan();
                mods.addAll(Arrays.asList(scanner.getIncludedFiles()));
            }
            if (mods.isEmpty()) {
                this.getLog().warn((CharSequence)"GWT plugin is configured to detect modules, but none were found.");
            }
            this.modules = new String[mods.size()];
            int i = 0;
            for (String fileName : mods) {
                String path = fileName.substring(0, fileName.length() - GWT_MODULE_EXTENSION.length());
                this.modules[i++] = path.replace(File.separatorChar, '.');
            }
            if (this.modules.length > 0) {
                this.getLog().info((CharSequence)("auto discovered modules " + Arrays.asList(this.modules)));
            }
        }
        return this.modules;
    }

    private String getJavaCommand() throws MojoExecutionException {
        File jvmFile;
        if (StringUtils.isEmpty((String)this.jvm)) {
            this.jvm = System.getProperty("java.home");
        }
        if (!(jvmFile = new File(this.jvm)).exists()) {
            throw new MojoExecutionException("the configured jvm " + this.jvm + " doesn't exists please check your environnement");
        }
        if (jvmFile.isDirectory()) {
            return jvmFile.getAbsolutePath() + File.separator + "bin" + File.separator + "java";
        }
        return this.jvm;
    }

    public List<String> getJvmArgs() {
        ArrayList<String> extra = new ArrayList<String>();
        String userExtraJvmArgs = this.extraJvmArgs;
        if (userExtraJvmArgs != null) {
            for (String extraArg : userExtraJvmArgs.split(" ")) {
                extra.add(extraArg);
            }
        }
        return extra;
    }

    public Collection<File> getClasspath(String scope) throws MojoExecutionException {
        try {
            return this.classpathBuilder.buildClasspathList(this.project, "compile", this.project.getArtifacts());
        }
        catch (ClasspathBuilderException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String quote(String arg) {
        if (arg.startsWith("'") || arg.startsWith("\"")) {
            return arg;
        }
        return '\"' + arg + '\"';
    }

    public class JavaCommand {
        private String className;
        private List<File> classpath = new LinkedList<File>();
        private List<String> args = new ArrayList<String>();

        public JavaCommand(String className) {
            this.className = className;
        }

        public JavaCommand withinScope(String scope) throws MojoExecutionException {
            this.classpath.addAll(UpdateWidgetsetMojo.this.getClasspath(scope));
            return this;
        }

        public JavaCommand arg(String arg) {
            this.args.add(arg);
            return this;
        }

        public void execute() throws MojoExecutionException {
            ArrayList<String> command = new ArrayList<String>();
            command.addAll(UpdateWidgetsetMojo.this.getJvmArgs());
            command.add("-classpath");
            ArrayList<String> path = new ArrayList<String>(this.classpath.size());
            for (File file : this.classpath) {
                path.add(UpdateWidgetsetMojo.this.quote(file.getAbsolutePath()));
            }
            command.add(StringUtils.join(path.iterator(), (String)File.pathSeparator));
            command.add(this.className);
            command.addAll(this.args);
            try {
                String[] arguments = command.toArray(new String[command.size()]);
                Commandline cmd = Os.isFamily((String)"windows") ? new Commandline((Shell)new JavaShell()) : new Commandline();
                cmd.setExecutable(UpdateWidgetsetMojo.this.getJavaCommand());
                cmd.addArguments(arguments);
                cmd.getShell().setQuotedArgumentsEnabled(false);
                UpdateWidgetsetMojo.this.getLog().debug((CharSequence)("Execute command :\n" + cmd.toString()));
                int status = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)UpdateWidgetsetMojo.this.out, (StreamConsumer)UpdateWidgetsetMojo.this.err);
                if (status != 0) {
                    throw new MojoExecutionException("Command [[\n" + cmd.toString() + "\n]] failed with status " + status);
                }
            }
            catch (CommandLineTimeOutException e) {
                throw new MojoExecutionException("Time-out on command line execution :\n" + command);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to execute command line :\n" + command);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaShell
    extends Shell {
        private JavaShell() {
        }

        protected List<String> getRawCommandLine(String executable, String[] arguments) {
            ArrayList<String> commandLine = new ArrayList<String>();
            if (executable != null) {
                commandLine.add(executable);
            }
            for (String arg : arguments) {
                commandLine.add(arg);
            }
            return commandLine;
        }
    }
}

