/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ReusableReferralConnector;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedRequest;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReferralHelper {
    private ReferralHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static LDAPResult handleReferral(@NotNull AddRequest addRequest, @NotNull LDAPResult referralResult, @NotNull LDAPConnection connection) {
        int depth = addRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new LDAPResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getResponseControls());
        }
        ReferralConnector referralConnector = addRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = ReferralHelper.getReferralURLs(referralResult.getReferralURLs()).iterator();
        while (iterator.hasNext()) {
            AddRequest referralFollowingRequest;
            LDAPURL referralURL = iterator.next();
            if (referralURL.baseDNProvided()) {
                referralFollowingRequest = addRequest.duplicate();
                referralFollowingRequest.setDN(referralURL.getBaseDN());
            } else {
                referralFollowingRequest = addRequest;
            }
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    return referralInterface.add(referralFollowingRequest);
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    LDAPResult addResult;
                    LDAPResult lDAPResult = addResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return lDAPResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                addRequest.setReferralDepth(depth + 1);
                return ReferralHelper.handleReferral(addRequest, ((LDAPException)e).toLDAPResult(), connection);
            }
            break;
        }
        return referralResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static CompareResult handleReferral(@NotNull CompareRequest compareRequest, @NotNull CompareResult referralResult, @NotNull LDAPConnection connection) {
        int depth = compareRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new CompareResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getResponseControls());
        }
        ReferralConnector referralConnector = compareRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = ReferralHelper.getReferralURLs(referralResult.getReferralURLs()).iterator();
        while (iterator.hasNext()) {
            CompareRequest referralFollowingRequest;
            LDAPURL referralURL = iterator.next();
            if (referralURL.baseDNProvided()) {
                referralFollowingRequest = compareRequest.duplicate();
                referralFollowingRequest.setDN(referralURL.getBaseDN());
            } else {
                referralFollowingRequest = compareRequest;
            }
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    return referralInterface.compare(referralFollowingRequest);
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    CompareResult compareResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return compareResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                compareRequest.setReferralDepth(depth + 1);
                return ReferralHelper.handleReferral(compareRequest, new CompareResult((LDAPException)e), connection);
            }
            break;
        }
        return referralResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static LDAPResult handleReferral(@NotNull DeleteRequest deleteRequest, @NotNull LDAPResult referralResult, @NotNull LDAPConnection connection) {
        int depth = deleteRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new LDAPResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getResponseControls());
        }
        ReferralConnector referralConnector = deleteRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = ReferralHelper.getReferralURLs(referralResult.getReferralURLs()).iterator();
        while (iterator.hasNext()) {
            DeleteRequest referralFollowingRequest;
            LDAPURL referralURL = iterator.next();
            if (referralURL.baseDNProvided()) {
                referralFollowingRequest = deleteRequest.duplicate();
                referralFollowingRequest.setDN(referralURL.getBaseDN());
            } else {
                referralFollowingRequest = deleteRequest;
            }
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    return referralInterface.delete(referralFollowingRequest);
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    LDAPResult lDAPResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return lDAPResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                deleteRequest.setReferralDepth(depth + 1);
                return ReferralHelper.handleReferral(deleteRequest, ((LDAPException)e).toLDAPResult(), connection);
            }
            break;
        }
        return referralResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static LDAPResult handleReferral(@NotNull ModifyRequest modifyRequest, @NotNull LDAPResult referralResult, @NotNull LDAPConnection connection) {
        int depth = modifyRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new LDAPResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getResponseControls());
        }
        ReferralConnector referralConnector = modifyRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = ReferralHelper.getReferralURLs(referralResult.getReferralURLs()).iterator();
        while (iterator.hasNext()) {
            ModifyRequest referralFollowingRequest;
            LDAPURL referralURL = iterator.next();
            if (referralURL.baseDNProvided()) {
                referralFollowingRequest = modifyRequest.duplicate();
                referralFollowingRequest.setDN(referralURL.getBaseDN());
            } else {
                referralFollowingRequest = modifyRequest;
            }
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    return referralInterface.modify(referralFollowingRequest);
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    LDAPResult lDAPResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return lDAPResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                modifyRequest.setReferralDepth(depth + 1);
                return ReferralHelper.handleReferral(modifyRequest, ((LDAPException)e).toLDAPResult(), connection);
            }
            break;
        }
        return referralResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static LDAPResult handleReferral(@NotNull ModifyDNRequest modifyDNRequest, @NotNull LDAPResult referralResult, @NotNull LDAPConnection connection) {
        int depth = modifyDNRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new LDAPResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getResponseControls());
        }
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return referralResult;
        }
        ReferralConnector referralConnector = modifyDNRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = ReferralHelper.getReferralURLs(referralResult.getReferralURLs()).iterator();
        while (iterator.hasNext()) {
            ModifyDNRequest referralFollowingRequest;
            LDAPURL referralURL = iterator.next();
            if (referralURL.baseDNProvided()) {
                referralFollowingRequest = modifyDNRequest.duplicate();
                referralFollowingRequest.setDN(referralURL.getBaseDN());
            } else {
                referralFollowingRequest = modifyDNRequest;
            }
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    return referralInterface.modifyDN(referralFollowingRequest);
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    LDAPResult lDAPResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return lDAPResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                modifyDNRequest.setReferralDepth(depth + 1);
                return ReferralHelper.handleReferral(modifyDNRequest, ((LDAPException)e).toLDAPResult(), connection);
            }
            break;
        }
        return referralResult;
    }

    @NotNull
    public static SearchResult handleReferral(@NotNull SearchRequest searchRequest, @NotNull SearchResult referralResult, @NotNull LDAPConnection connection) {
        int depth = searchRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new SearchResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getEntryCount(), referralResult.getReferenceCount(), referralResult.getResponseControls());
        }
        SearchResult result = ReferralHelper.handleReferral(searchRequest, ReferralHelper.getReferralURLs(referralResult.getReferralURLs()), connection);
        if (result == null) {
            return referralResult;
        }
        return result;
    }

    @NotNull
    public static SearchResult handleReferral(@NotNull SearchRequest searchRequest, @NotNull SearchResultReference searchReference, @NotNull LDAPConnection connection) {
        int depth = searchRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new SearchResult(searchReference.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), null, searchReference.getReferralURLs(), 0, 0, null);
        }
        SearchResult result = ReferralHelper.handleReferral(searchRequest, ReferralHelper.getReferralURLs(searchReference.getReferralURLs()), connection);
        if (result == null) {
            return new SearchResult(searchReference.getMessageID(), ResultCode.REFERRAL, null, null, searchReference.getReferralURLs(), 0, 0, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static SearchResult handleReferral(@NotNull SearchRequest searchRequest, @NotNull List<LDAPURL> referralURLs, @NotNull LDAPConnection connection) {
        ReferralConnector referralConnector = searchRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = referralURLs.iterator();
        while (iterator.hasNext()) {
            LDAPURL referralURL = iterator.next();
            SearchRequest referralFollowingRequest = searchRequest.duplicate();
            if (referralURL.baseDNProvided()) {
                referralFollowingRequest.setBaseDN(referralURL.getBaseDN());
            }
            if (referralURL.scopeProvided()) {
                referralFollowingRequest.setScope(referralURL.getScope());
            }
            if (referralURL.filterProvided()) {
                referralFollowingRequest.setFilter(referralURL.getFilter());
            }
            int depth = searchRequest.getReferralDepth();
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    return referralInterface.search(referralFollowingRequest);
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    SearchResult searchResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return searchResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                searchRequest.setReferralDepth(depth + 1);
                return ReferralHelper.handleReferral(searchRequest, new SearchResult((LDAPException)e), connection);
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PasswordModifyExtendedResult handleReferral(@NotNull PasswordModifyExtendedRequest pwModifyRequest, @NotNull PasswordModifyExtendedResult referralResult, @NotNull LDAPConnection connection) {
        int depth = pwModifyRequest.getReferralDepth();
        if (depth > connection.getConnectionOptions().getReferralHopLimit()) {
            return new PasswordModifyExtendedResult(referralResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(), referralResult.getMatchedDN(), referralResult.getReferralURLs(), referralResult.getRawGeneratedPassword(), referralResult.getResponseControls());
        }
        ReferralConnector referralConnector = pwModifyRequest.getReferralConnector(connection);
        ReusableReferralConnector reusableReferralConnector = referralConnector instanceof ReusableReferralConnector ? (ReusableReferralConnector)referralConnector : null;
        Iterator<LDAPURL> iterator = ReferralHelper.getReferralURLs(referralResult.getReferralURLs()).iterator();
        while (iterator.hasNext()) {
            ExtendedResult extendedResult;
            LDAPURL referralURL = iterator.next();
            String userIdentity = referralURL.getBaseDN().isNullDN() ? pwModifyRequest.getUserIdentity() : referralURL.getBaseDN().toString();
            PasswordModifyExtendedRequest referralFollowingRequest = new PasswordModifyExtendedRequest(userIdentity, pwModifyRequest.getOldPassword(), pwModifyRequest.getNewPassword(), pwModifyRequest.getControls());
            referralFollowingRequest.setResponseTimeoutMillis(pwModifyRequest.getResponseTimeoutMillis(connection));
            referralFollowingRequest.setIntermediateResponseListener(pwModifyRequest.getIntermediateResponseListener());
            referralFollowingRequest.setReferralConnector(pwModifyRequest.getReferralConnector(connection));
            referralFollowingRequest.setReferralDepth(depth + 1);
            try {
                if (reusableReferralConnector != null) {
                    FullLDAPInterface referralInterface = reusableReferralConnector.getReferralInterface(referralURL, connection);
                    extendedResult = referralInterface.processExtendedOperation(referralFollowingRequest);
                    if (!(extendedResult instanceof PasswordModifyExtendedResult)) return new PasswordModifyExtendedResult(extendedResult);
                    return (PasswordModifyExtendedResult)extendedResult;
                }
                LDAPConnection referralConnection = referralConnector.getReferralConnection(referralURL, connection);
                try {
                    PasswordModifyExtendedResult passwordModifyExtendedResult = referralFollowingRequest.process(referralConnection, depth + 1);
                    return passwordModifyExtendedResult;
                }
                finally {
                    referralConnection.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConnection.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof LDAPException) || ((LDAPException)e).getResultCode() != ResultCode.REFERRAL) continue;
                pwModifyRequest.setReferralDepth(depth + 1);
                extendedResult = new ExtendedResult((LDAPException)e);
                try {
                    return ReferralHelper.handleReferral(pwModifyRequest, new PasswordModifyExtendedResult(extendedResult), connection);
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
            }
        }
        return referralResult;
    }

    @NotNull
    private static List<LDAPURL> getReferralURLs(@NotNull String[] urlStrings) {
        ArrayList<LDAPURL> ldapURLs = new ArrayList<LDAPURL>(urlStrings.length);
        for (String urlString : urlStrings) {
            try {
                LDAPURL ldapURL = new LDAPURL(urlString);
                if (!ldapURL.hostProvided()) continue;
                ldapURLs.add(ldapURL);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return ldapURLs;
    }
}

