/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertMessages;
import java.security.Permission;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class ManageCertificatesSecurityManager
extends SecurityManager {
    private volatile boolean exitCalledWithNonZeroStatus = false;
    private volatile boolean exitCalledWithZeroStatus = false;
    private final SecurityManager delegateSecurityManager = System.getSecurityManager();

    ManageCertificatesSecurityManager() {
    }

    @Override
    public void checkExit(int status) throws SecurityException {
        if (status == 0) {
            this.exitCalledWithZeroStatus = true;
        } else {
            this.exitCalledWithNonZeroStatus = true;
        }
        throw new SecurityException(CertMessages.ERR_MANAGE_CERTS_SECURITY_MANAGER_EXIT_NOT_ALLOWED.get());
    }

    @Override
    public void checkPermission(Permission permission) throws SecurityException {
        if (permission == null || permission.getName() == null) {
            if (this.delegateSecurityManager != null) {
                this.delegateSecurityManager.checkPermission(permission);
            }
            return;
        }
        String permissionName = StaticUtils.toLowerCase(permission.getName());
        if (permissionName.equals("exitvm") || permissionName.equals("exitvm.0")) {
            this.exitCalledWithZeroStatus = true;
            throw new SecurityException(CertMessages.ERR_MANAGE_CERTS_SECURITY_MANAGER_EXIT_NOT_ALLOWED.get());
        }
        if (permissionName.startsWith("exitvm.")) {
            this.exitCalledWithNonZeroStatus = true;
            throw new SecurityException(CertMessages.ERR_MANAGE_CERTS_SECURITY_MANAGER_EXIT_NOT_ALLOWED.get());
        }
        if (this.delegateSecurityManager != null) {
            this.delegateSecurityManager.checkPermission(permission);
        }
    }

    boolean exitCalledWithZeroStatus() {
        return this.exitCalledWithZeroStatus;
    }

    boolean exitCalledWithNonZeroStatus() {
        return this.exitCalledWithNonZeroStatus;
    }
}

