/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class LDIFChangeRecord
implements LDIFRecord {
    private static final long serialVersionUID = 6917212392170911115L;
    private final List<Control> controls;
    private volatile DN parsedDN;
    private final String dn;

    protected LDIFChangeRecord(String dn, List<Control> controls) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
        this.parsedDN = null;
        this.controls = controls == null ? Collections.emptyList() : Collections.unmodifiableList(controls);
    }

    @Override
    public final String getDN() {
        return this.dn;
    }

    @Override
    public final DN getParsedDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn);
        }
        return this.parsedDN;
    }

    public abstract ChangeType getChangeType();

    public List<Control> getControls() {
        return this.controls;
    }

    public abstract LDIFChangeRecord duplicate(Control ... var1);

    public final LDAPResult processChange(LDAPInterface connection) throws LDAPException {
        return this.processChange(connection, true);
    }

    public abstract LDAPResult processChange(LDAPInterface var1, boolean var2) throws LDAPException;

    final Entry toEntry() throws LDIFException {
        return new Entry(this.toLDIF());
    }

    @Override
    public final String[] toLDIF() {
        return this.toLDIF(0);
    }

    @Override
    public abstract String[] toLDIF(int var1);

    static void encodeNameAndValue(String name, ASN1OctetString value, List<String> lines) {
        String line = LDIFWriter.encodeNameAndValue(name, value);
        if (LDIFWriter.commentAboutBase64EncodedValues() && line.startsWith(name + "::")) {
            StringTokenizer tokenizer = new StringTokenizer(line, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                lines.add(tokenizer.nextToken());
            }
        } else {
            lines.add(line);
        }
    }

    @Override
    public final void toLDIF(ByteStringBuffer buffer) {
        this.toLDIF(buffer, 0);
    }

    @Override
    public abstract void toLDIF(ByteStringBuffer var1, int var2);

    @Override
    public final String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, 0);
        return buffer.toString();
    }

    @Override
    public final String toLDIFString(int wrapColumn) {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, wrapColumn);
        return buffer.toString();
    }

    @Override
    public final void toLDIFString(StringBuilder buffer) {
        this.toLDIFString(buffer, 0);
    }

    @Override
    public abstract void toLDIFString(StringBuilder var1, int var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static ASN1OctetString encodeControlString(Control c) {
        ByteStringBuffer buffer = new ByteStringBuffer();
        buffer.append(c.getOID());
        if (c.isCritical()) {
            buffer.append(" true");
        } else {
            buffer.append(" false");
        }
        ASN1OctetString value = c.getValue();
        if (value != null) {
            LDIFWriter.encodeValue(value, buffer);
        }
        return buffer.toByteString().toASN1OctetString();
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public abstract void toString(StringBuilder var1);
}

