/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToCodeArgHelper {
    private final List<String> argStrings;
    private final String comment;

    private ToCodeArgHelper(String argString, String comment) {
        this.argStrings = Collections.singletonList(argString);
        this.comment = comment;
    }

    private ToCodeArgHelper(List<String> argStrings, String comment) {
        this.argStrings = argStrings;
        this.comment = comment;
    }

    public static ToCodeArgHelper createByte(byte b, boolean includeComment) {
        String s = "0x" + StaticUtils.toHex(b);
        if ((b & 0x80) != 0) {
            s = "(byte) " + s;
        }
        String comment = includeComment && StaticUtils.isPrintableString(new byte[]{b}) ? "\"" + (char)b + '\"' : null;
        return new ToCodeArgHelper(s, comment);
    }

    public static ToCodeArgHelper createByteArray(byte[] b, boolean includeComments, String comment) {
        return new ToCodeArgHelper(ToCodeArgHelper.getByteArrayLines(b, includeComments), comment);
    }

    private static List<String> getByteArrayLines(byte[] b, boolean includeComments) {
        if (b == null) {
            return Collections.singletonList("(byte[]) null");
        }
        if (b.length == 0) {
            return Collections.singletonList("new byte[0]");
        }
        ArrayList<String> lines = new ArrayList<String>(3 + b.length);
        lines.add("new byte[]");
        lines.add("{");
        byte[] oneByteString = new byte[1];
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            buffer.setLength(0);
            buffer.append("  ");
            if ((b[i] & 0x80) != 0) {
                buffer.append("(byte) 0x");
                StaticUtils.toHex(b[i], buffer);
                if (i < b.length - 1) {
                    buffer.append(',');
                }
            } else {
                buffer.append("0x");
                StaticUtils.toHex(b[i], buffer);
                if (i < b.length - 1) {
                    buffer.append(',');
                }
                oneByteString[0] = b[i];
                if (includeComments && StaticUtils.isPrintableString(oneByteString)) {
                    buffer.append(" // \"");
                    buffer.append((char)b[i]);
                    buffer.append('\"');
                }
            }
            lines.add(buffer.toString());
        }
        lines.add("}");
        return lines;
    }

    public static ToCodeArgHelper createBoolean(boolean b, String comment) {
        return new ToCodeArgHelper(b ? "true" : "false", comment);
    }

    public static ToCodeArgHelper createInteger(long i, String comment) {
        String valueString = String.valueOf(i);
        if (i > Integer.MAX_VALUE || i < Integer.MIN_VALUE) {
            valueString = valueString + 'L';
        }
        return new ToCodeArgHelper(valueString, comment);
    }

    public static ToCodeArgHelper createString(String s, String comment) {
        if (s == null) {
            return new ToCodeArgHelper("(String) null", comment);
        }
        return new ToCodeArgHelper('\"' + s.replace("\"", "\\\"") + '\"', comment);
    }

    public static ToCodeArgHelper createASN1OctetString(ASN1OctetString s, String comment) {
        if (s == null) {
            return new ToCodeArgHelper("(ASN1OctetString) null", comment);
        }
        ArrayList<String> lines = new ArrayList<String>(10);
        boolean universalType = s.getType() == 4;
        byte[] valueBytes = s.getValue();
        if (valueBytes.length == 0) {
            if (universalType) {
                lines.add("new ASN1OctetString()");
            } else {
                lines.add("new ASN1OctetString(");
                lines.add("     (byte) 0x" + StaticUtils.toHex(s.getType()) + ')');
            }
        } else {
            boolean isPrintable;
            lines.add("new ASN1OctetString(");
            if (!universalType) {
                lines.add("     (byte) 0x" + StaticUtils.toHex(s.getType()) + ',');
            }
            if (isPrintable = StaticUtils.isPrintableString(valueBytes)) {
                lines.add("     \"" + s.stringValue() + "\")");
            } else {
                StringBuilder line = new StringBuilder();
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(valueBytes, true).iterator();
                while (iterator.hasNext()) {
                    line.setLength(0);
                    line.append("     ");
                    line.append(iterator.next());
                    if (!iterator.hasNext()) {
                        line.append(')');
                    }
                    lines.add(line.toString());
                }
            }
        }
        return new ToCodeArgHelper(lines, comment);
    }

    public static ToCodeArgHelper createModificationType(ModificationType t, String comment) {
        if (t == null) {
            return new ToCodeArgHelper("(ModificationType) null", comment);
        }
        ModificationType definedType = ModificationType.definedValueOf(t.intValue());
        if (definedType == null) {
            return new ToCodeArgHelper("ModificationType.valueOf(" + t.intValue() + ')', comment);
        }
        return new ToCodeArgHelper("ModificationType." + definedType.getName(), comment);
    }

    public static ToCodeArgHelper createScope(SearchScope s, String comment) {
        if (s == null) {
            return new ToCodeArgHelper("(SearchScope) null", comment);
        }
        SearchScope definedScope = SearchScope.definedValueOf(s.intValue());
        if (definedScope == null) {
            return new ToCodeArgHelper("SearchScope.valueOf(" + s.intValue() + ')', comment);
        }
        return new ToCodeArgHelper("SearchScope." + definedScope.getName(), comment);
    }

    public static ToCodeArgHelper createDerefPolicy(DereferencePolicy p, String comment) {
        if (p == null) {
            return new ToCodeArgHelper("(DereferencePolicy) null", comment);
        }
        DereferencePolicy definedPolicy = DereferencePolicy.definedValueOf(p.intValue());
        if (definedPolicy == null) {
            return new ToCodeArgHelper("DereferencePolicy.valueOf(" + p.intValue() + ')', comment);
        }
        return new ToCodeArgHelper("DereferencePolicy." + definedPolicy.getName(), comment);
    }

    public static ToCodeArgHelper createAttribute(Attribute a, String comment) {
        if (a == null) {
            return new ToCodeArgHelper("(Attribute) null", comment);
        }
        if (!a.hasValue()) {
            return new ToCodeArgHelper("new Attribute(\"" + a.getName() + "\")", comment);
        }
        ASN1OctetString[] rawValues = a.getRawValues();
        ArrayList<String> lines = new ArrayList<String>(2 + rawValues.length);
        lines.add("new Attribute(");
        lines.add("     \"" + a.getName() + "\",");
        if (StaticUtils.isSensitiveToCodeAttribute(a.getName())) {
            if (rawValues.length == 1) {
                lines.add("     \"---redacted-value---\")");
            } else {
                for (int i = 1; i <= rawValues.length; ++i) {
                    String suffix = i == rawValues.length ? ")" : ",";
                    lines.add("     \"---redacted-value-" + i + "---\"" + suffix);
                }
            }
        } else if (ToCodeArgHelper.allPrintable(rawValues)) {
            for (int i = 0; i < rawValues.length; ++i) {
                String suffix = i == rawValues.length - 1 ? ")" : ",";
                lines.add("     \"" + rawValues[i].stringValue().replace("\"", "\\\"") + '\"' + suffix);
            }
        } else {
            for (int i = 0; i < rawValues.length; ++i) {
                String suffix = i < rawValues.length - 1 ? "," : ")";
                Iterator<String> byteArrayLineIterator = ToCodeArgHelper.getByteArrayLines(rawValues[i].getValue(), true).iterator();
                while (byteArrayLineIterator.hasNext()) {
                    String s = byteArrayLineIterator.next();
                    if (byteArrayLineIterator.hasNext()) {
                        lines.add("     " + s);
                        continue;
                    }
                    lines.add("     " + s + suffix);
                }
            }
        }
        return new ToCodeArgHelper(lines, comment);
    }

    public static ToCodeArgHelper createModification(Modification m, String comment) {
        if (m == null) {
            return new ToCodeArgHelper("(Modification) null", comment);
        }
        ASN1OctetString[] rawValues = m.getRawValues();
        ArrayList<String> lines = new ArrayList<String>(3 + rawValues.length);
        lines.add("new Modification(");
        lines.add("     " + ToCodeArgHelper.createModificationType(m.getModificationType(), null).getLines().get(0) + ',');
        if (rawValues.length == 0) {
            lines.add("     \"" + m.getAttributeName() + "\")");
        } else {
            lines.add("     \"" + m.getAttributeName() + "\",");
            if (StaticUtils.isSensitiveToCodeAttribute(m.getAttributeName())) {
                if (rawValues.length == 1) {
                    lines.add("     \"---redacted-value---\")");
                } else {
                    for (int i = 1; i <= rawValues.length; ++i) {
                        String suffix = i == rawValues.length ? ")" : ",";
                        lines.add("     \"---redacted-value-" + i + "---\"" + suffix);
                    }
                }
            } else if (ToCodeArgHelper.allPrintable(rawValues)) {
                for (int i = 0; i < rawValues.length; ++i) {
                    String suffix = i == rawValues.length - 1 ? ")" : ",";
                    lines.add("     \"" + rawValues[i].stringValue().replace("\"", "\\\"") + '\"' + suffix);
                }
            } else {
                for (int i = 0; i < rawValues.length; ++i) {
                    String suffix = i == rawValues.length - 1 ? ")" : ",";
                    Iterator<String> byteArrayLineIterator = ToCodeArgHelper.getByteArrayLines(rawValues[i].getValue(), true).iterator();
                    while (byteArrayLineIterator.hasNext()) {
                        String s = byteArrayLineIterator.next();
                        if (byteArrayLineIterator.hasNext()) {
                            lines.add("     " + s);
                            continue;
                        }
                        lines.add("     " + s + suffix);
                    }
                }
            }
        }
        return new ToCodeArgHelper(lines, comment);
    }

    public static ToCodeArgHelper createFilter(Filter f, String comment) {
        if (f == null) {
            return new ToCodeArgHelper("(Filter) null", comment);
        }
        ArrayList<String> lines = new ArrayList<String>(10);
        ToCodeArgHelper.addFilterLines(lines, f, "", "");
        return new ToCodeArgHelper(lines, comment);
    }

    private static void addFilterLines(List<String> lines, Filter f, String indent, String suffix) {
        String nestedIndent = indent + "     ";
        switch (f.getFilterType()) {
            case -96: 
            case -95: {
                Filter[] components = f.getComponents();
                if (f.getFilterType() == -96) {
                    if (components.length == 0) {
                        lines.add(indent + "Filter.createANDFilter()" + suffix);
                        return;
                    }
                    lines.add(indent + "Filter.createANDFilter(");
                } else {
                    if (components.length == 0) {
                        lines.add(indent + "Filter.createORFilter()" + suffix);
                        return;
                    }
                    lines.add(indent + "Filter.createORFilter(");
                }
                for (int i = 0; i < components.length; ++i) {
                    if (i == components.length - 1) {
                        ToCodeArgHelper.addFilterLines(lines, components[i], nestedIndent, ')' + suffix);
                        continue;
                    }
                    ToCodeArgHelper.addFilterLines(lines, components[i], nestedIndent, ",");
                }
                break;
            }
            case -94: {
                lines.add(indent + "Filter.createNOTFilter(");
                ToCodeArgHelper.addFilterLines(lines, f.getNOTComponent(), nestedIndent, ')' + suffix);
                break;
            }
            case -121: {
                lines.add(indent + "Filter.createPresenceFilter(");
                lines.add(nestedIndent + '\"' + f.getAttributeName() + "\")" + suffix);
                break;
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                switch (f.getFilterType()) {
                    case -93: {
                        lines.add(indent + "Filter.createEqualityFilter(");
                        break;
                    }
                    case -91: {
                        lines.add(indent + "Filter.createGreaterOrEqualFilter(");
                        break;
                    }
                    case -90: {
                        lines.add(indent + "Filter.createLessOrEqualFilter(");
                        break;
                    }
                    case -88: {
                        lines.add(indent + "Filter.createApproximateMatchFilter(");
                    }
                }
                lines.add(nestedIndent + '\"' + f.getAttributeName() + "\",");
                if (StaticUtils.isSensitiveToCodeAttribute(f.getAttributeName())) {
                    lines.add(nestedIndent + "\"---redacted-value---\")" + suffix);
                    break;
                }
                if (StaticUtils.isPrintableString(f.getAssertionValueBytes())) {
                    lines.add(nestedIndent + '\"' + f.getAssertionValue() + "\")" + suffix);
                    break;
                }
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(f.getAssertionValueBytes(), true).iterator();
                while (iterator.hasNext()) {
                    String line = iterator.next();
                    if (iterator.hasNext()) {
                        lines.add(nestedIndent + line);
                        continue;
                    }
                    lines.add(nestedIndent + line + ')' + suffix);
                }
                break;
            }
            case -92: {
                int i;
                Iterator<String> iterator;
                boolean allPrintable;
                lines.add(indent + "Filter.createSubstringFilter(");
                lines.add(nestedIndent + '\"' + f.getAttributeName() + "\",");
                if (StaticUtils.isSensitiveToCodeAttribute(f.getAttributeName())) {
                    if (f.getRawSubInitialValue() == null) {
                        lines.add(nestedIndent + "null,");
                    } else {
                        lines.add(nestedIndent + "\"---redacted-subInitial---\",");
                    }
                    if (f.getRawSubAnyValues().length == 0) {
                        lines.add(nestedIndent + "null,");
                    } else if (f.getRawSubAnyValues().length == 1) {
                        lines.add(nestedIndent + "new String[]");
                        lines.add(nestedIndent + '{');
                        lines.add(nestedIndent + "  \"---redacted-subAny---\"");
                        lines.add(nestedIndent + "},");
                    } else {
                        lines.add(nestedIndent + "new String[]");
                        lines.add(nestedIndent + '{');
                        for (int i2 = 1; i2 <= f.getRawSubAnyValues().length; ++i2) {
                            String comma = i2 == f.getRawSubAnyValues().length ? "" : ",";
                            lines.add(nestedIndent + "  \"---redacted-subAny-" + i2 + "---\"" + comma);
                        }
                        lines.add(nestedIndent + "},");
                    }
                    if (f.getRawSubFinalValue() == null) {
                        lines.add(nestedIndent + "null)" + suffix);
                        break;
                    }
                    lines.add(nestedIndent + "\"---redacted-subFinal---\")" + suffix);
                    break;
                }
                boolean bl = allPrintable = !(f.getRawSubInitialValue() != null && !StaticUtils.isPrintableString(f.getSubInitialBytes()) || f.getRawSubFinalValue() != null && !StaticUtils.isPrintableString(f.getSubFinalBytes()));
                if (allPrintable && f.getRawSubAnyValues().length > 0) {
                    for (byte[] b : f.getSubAnyBytes()) {
                        if (StaticUtils.isPrintableString(b)) continue;
                        allPrintable = false;
                        break;
                    }
                }
                if (f.getRawSubInitialValue() == null) {
                    lines.add(nestedIndent + "null,");
                } else if (allPrintable) {
                    lines.add(nestedIndent + '\"' + f.getSubInitialString().replace("\"", "\\\"") + "\",");
                } else {
                    iterator = ToCodeArgHelper.getByteArrayLines(f.getSubInitialBytes(), true).iterator();
                    while (iterator.hasNext()) {
                        String line = iterator.next();
                        if (iterator.hasNext()) {
                            lines.add(nestedIndent + line);
                            continue;
                        }
                        lines.add(nestedIndent + line + ',');
                    }
                }
                if (f.getRawSubAnyValues().length == 0) {
                    lines.add(nestedIndent + "null,");
                } else if (allPrintable) {
                    lines.add(nestedIndent + "new String[]");
                    lines.add(nestedIndent + '{');
                    String[] subAnyStrings = f.getSubAnyStrings();
                    for (i = 0; i < subAnyStrings.length; ++i) {
                        String comma = i == subAnyStrings.length - 1 ? "" : ",";
                        lines.add(nestedIndent + "  \"" + subAnyStrings[i] + '\"' + comma);
                    }
                    lines.add(nestedIndent + "},");
                } else {
                    lines.add(nestedIndent + "new byte[][]");
                    lines.add(nestedIndent + '{');
                    byte[][] subAnyBytes = f.getSubAnyBytes();
                    for (i = 0; i < subAnyBytes.length; ++i) {
                        String comma = i == subAnyBytes.length - 1 ? "" : ",";
                        Iterator<String> iterator2 = ToCodeArgHelper.getByteArrayLines(subAnyBytes[i], true).iterator();
                        while (iterator2.hasNext()) {
                            String line = iterator2.next();
                            if (iterator2.hasNext()) {
                                lines.add(nestedIndent + "  " + line);
                                continue;
                            }
                            lines.add(nestedIndent + "  " + line + comma);
                        }
                    }
                    lines.add(nestedIndent + "},");
                }
                if (f.getRawSubFinalValue() == null) {
                    lines.add(nestedIndent + "null)" + suffix);
                    break;
                }
                if (allPrintable) {
                    lines.add(nestedIndent + '\"' + f.getSubFinalString().replace("\"", "\\\"") + "\")" + suffix);
                    break;
                }
                iterator = ToCodeArgHelper.getByteArrayLines(f.getSubFinalBytes(), true).iterator();
                while (iterator.hasNext()) {
                    String line = iterator.next();
                    if (iterator.hasNext()) {
                        lines.add(nestedIndent + line);
                        continue;
                    }
                    lines.add(nestedIndent + line + ')' + suffix);
                }
                break;
            }
            case -87: {
                lines.add(indent + "Filter.createExtensibleMatchFilter(");
                if (f.getAttributeName() == null) {
                    lines.add(nestedIndent + "null,");
                } else {
                    lines.add(nestedIndent + '\"' + f.getAttributeName() + "\",");
                }
                if (f.getMatchingRuleID() == null) {
                    lines.add(nestedIndent + "null,");
                } else {
                    lines.add(nestedIndent + '\"' + f.getMatchingRuleID() + "\",");
                }
                lines.add(nestedIndent + f.getDNAttributes() + ',');
                if (f.getAttributeName() != null && StaticUtils.isSensitiveToCodeAttribute(f.getAttributeName())) {
                    lines.add(nestedIndent + "\"---redacted-value---\")" + suffix);
                    break;
                }
                if (StaticUtils.isPrintableString(f.getAssertionValueBytes())) {
                    lines.add(nestedIndent + '\"' + f.getAssertionValue().replace("\"", "\\\"") + "\")" + suffix);
                    break;
                }
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(f.getAssertionValueBytes(), true).iterator();
                while (iterator.hasNext()) {
                    String line = iterator.next();
                    if (iterator.hasNext()) {
                        lines.add(nestedIndent + line);
                        continue;
                    }
                    lines.add(nestedIndent + line + ')' + suffix);
                }
                break;
            }
        }
    }

    public static ToCodeArgHelper createControl(Control c, String comment) {
        if (c == null) {
            return new ToCodeArgHelper("(Control) null", comment);
        }
        ArrayList<String> lines = new ArrayList<String>(10);
        lines.add("new Control(");
        lines.add("     \"" + c.getOID() + "\",");
        if (c.hasValue()) {
            lines.add("     " + c.isCritical() + ',');
            List<String> valueLines = ToCodeArgHelper.createASN1OctetString((ASN1OctetString)c.getValue(), null).argStrings;
            Iterator<String> valueLineIterator = valueLines.iterator();
            while (valueLineIterator.hasNext()) {
                String s = valueLineIterator.next();
                if (valueLineIterator.hasNext()) {
                    lines.add("     " + s);
                    continue;
                }
                lines.add("     " + s + ')');
            }
        } else {
            lines.add("     " + c.isCritical() + ')');
        }
        return new ToCodeArgHelper(lines, comment);
    }

    public static ToCodeArgHelper createControlArray(Control[] c, String comment) {
        if (c == null) {
            return new ToCodeArgHelper("(Control[]) null", comment);
        }
        if (c.length == 0) {
            return new ToCodeArgHelper("new Control[0]", comment);
        }
        ArrayList<String> lines = new ArrayList<String>(10);
        lines.add("new Control[]");
        lines.add("{");
        for (int i = 0; i < c.length; ++i) {
            ToCodeArgHelper h = ToCodeArgHelper.createControl(c[i], null);
            List<String> hLines = h.argStrings;
            Iterator<String> iterator = hLines.iterator();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!iterator.hasNext() && i < c.length - 1) {
                    lines.add("  " + line + ',');
                    continue;
                }
                lines.add("  " + line);
            }
        }
        lines.add("}");
        return new ToCodeArgHelper(lines, comment);
    }

    public static ToCodeArgHelper createRaw(String s, String comment) {
        return new ToCodeArgHelper(s, comment);
    }

    public static ToCodeArgHelper createRaw(List<String> s, String comment) {
        return new ToCodeArgHelper(s, comment);
    }

    private static boolean allPrintable(ASN1OctetString ... values) {
        for (ASN1OctetString s : values) {
            if (StaticUtils.isPrintableString(s.getValue())) continue;
            return false;
        }
        return true;
    }

    public List<String> getLines() {
        return this.argStrings;
    }

    public String getComment() {
        return this.comment;
    }
}

