/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeIterator;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexIterator;
import com.tinkerpop.blueprints.impls.orient.OrientVertexQuery;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrientVertex
extends OrientElement
implements Vertex {
    public static final String CLASS_NAME = "V";
    public static final String CONNECTION_OUT_PREFIX = "out_";
    public static final String CONNECTION_IN_PREFIX = "in_";
    private static final long serialVersionUID = 1L;

    protected OrientVertex(OrientBaseGraph graph, String className, Object ... fields) {
        super(graph, null);
        if (className != null) {
            className = this.checkForClassInSchema(OrientBaseGraph.encodeClassName(className));
        }
        this.rawElement = new ODocument(className == null ? CLASS_NAME : className);
        this.setProperties(fields);
    }

    protected OrientVertex(OrientBaseGraph graph, OIdentifiable record) {
        super(graph, record);
    }

    public Set<String> getPropertyKeys() {
        this.graph.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        HashSet<String> result = new HashSet<String>();
        for (String field : doc.fieldNames()) {
            if (this.graph.isUseVertexFieldsForEdgeLabels()) {
                if (field.startsWith(CONNECTION_OUT_PREFIX) || field.startsWith(CONNECTION_IN_PREFIX)) continue;
                result.add(field);
                continue;
            }
            if (field.equals("out") || field.equals("in")) continue;
            result.add(field);
        }
        return result;
    }

    public Iterable<Vertex> getVertices(Direction iDirection, String ... iLabels) {
        this.graph.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        OMultiCollectionIterator iterable = new OMultiCollectionIterator();
        for (String fieldName : doc.fieldNames()) {
            Object fieldValue;
            OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
            if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, fieldValue, iLabels);
                continue;
            }
            if (!(fieldValue instanceof Collection)) continue;
            Collection coll = (Collection)fieldValue;
            if (coll.size() == 1) {
                if (coll instanceof ORecordLazyMultiValue) {
                    this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, ((ORecordLazyMultiValue)coll).rawIterator().next(), iLabels);
                    continue;
                }
                if (coll instanceof List) {
                    this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, ((List)coll).get(0), iLabels);
                    continue;
                }
                this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, coll.iterator().next(), iLabels);
                continue;
            }
            if (coll instanceof ORecordLazyMultiValue) {
                iterable.add((Object)new OrientVertexIterator(this, ((ORecordLazyMultiValue)coll).rawIterator(), connection, iLabels, ((ORecordLazyMultiValue)coll).size()));
                continue;
            }
            iterable.add((Object)new OrientVertexIterator(this, coll.iterator(), connection, iLabels, -1));
        }
        return iterable;
    }

    public OrientVertexQuery query() {
        this.graph.setCurrentGraphInThreadLocal();
        return new OrientVertexQuery(this);
    }

    public OTraverse traverse() {
        this.graph.setCurrentGraphInThreadLocal();
        return new OTraverse().target(new OIdentifiable[]{this.getRecord()});
    }

    @Override
    public void remove() {
        this.checkClass();
        this.graph.autoStartTransaction();
        ODocument doc = this.getRecord();
        if (doc == null) {
            return;
        }
        Iterator<OrientIndex<? extends OrientElement>> it = this.graph.getManualIndices().iterator();
        if (it.hasNext()) {
            HashSet<Edge> allEdges = new HashSet<Edge>();
            for (Edge e : this.getEdges(Direction.BOTH, new String[0])) {
                allEdges.add(e);
            }
            while (it.hasNext()) {
                OrientIndex idx;
                Index index = it.next();
                if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
                    idx = (OrientIndex)index;
                    idx.removeElement(this);
                }
                if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
                idx = (OrientIndex)index;
                for (Edge e : allEdges) {
                    idx.removeElement((OrientEdge)e);
                }
            }
        }
        for (String fieldName : doc.fieldNames()) {
            OPair<Direction, String> connection = this.getConnection(Direction.BOTH, fieldName, new String[0]);
            if (connection == null) continue;
            OrientVertex.removeEdges(doc, fieldName, null, true, this.graph.isUseVertexFieldsForEdgeLabels());
        }
        super.remove();
    }

    public Edge addEdge(String label, Vertex inVertex) {
        return this.addEdge(label, (OrientVertex)inVertex, null, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName) {
        return this.addEdge(label, inVertex, iClassName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        if (inVertex == null) {
            throw new IllegalArgumentException("destination vertex is null");
        }
        this.graph.autoStartTransaction();
        OMVRBTreeRID.getLock().acquireExclusiveLock();
        try {
            OrientEdge edge;
            ODocument to;
            OIdentifiable from;
            ODocument outDocument = this.getRecord();
            ODocument inDocument = inVertex.getRecord();
            label = OrientBaseGraph.encodeClassName(label);
            if (label == null && iClassName != null) {
                label = OrientBaseGraph.encodeClassName(iClassName);
            }
            boolean useVertexFieldsForEdgeLabels = this.graph.isUseVertexFieldsForEdgeLabels();
            String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, label, useVertexFieldsForEdgeLabels);
            String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, label, useVertexFieldsForEdgeLabels);
            if (label == null) {
                throw ExceptionFactory.edgeLabelCanNotBeNull();
            }
            if (this.canCreateDynamicEdge(outDocument, inDocument, outFieldName, inFieldName, fields, label)) {
                from = this.rawElement;
                to = inDocument;
                edge = new OrientEdge(this.graph, from, (OIdentifiable)to, label);
            } else {
                edge = new OrientEdge(this.graph, label, fields);
                if (this.graph.isKeepInMemoryReferences()) {
                    edge.getRecord().fields("out", (Object)this.rawElement.getIdentity(), new Object[]{"in", inDocument.getIdentity()});
                } else {
                    edge.getRecord().fields("out", (Object)this.rawElement, new Object[]{"in", inDocument});
                }
                from = edge.getRecord();
                to = edge.getRecord();
            }
            if (this.graph.isKeepInMemoryReferences()) {
                from = from.getIdentity();
                to = to.getIdentity();
            }
            OrientVertex.createLink(outDocument, (OIdentifiable)to, outFieldName);
            OrientVertex.createLink(inDocument, from, inFieldName);
            edge.save(iClusterName);
            inDocument.save();
            outDocument.save();
            OrientEdge orientEdge = edge;
            return orientEdge;
        }
        finally {
            OMVRBTreeRID.getLock().releaseExclusiveLock();
        }
    }

    private boolean canCreateDynamicEdge(ODocument iFromVertex, ODocument iToVertex, String iOutFieldName, String iInFieldName, Object[] fields, String label) {
        if (!this.graph.isUseVertexFieldsForEdgeLabels() && label != null) {
            return false;
        }
        if (this.graph.isUseLightweightEdges() && (fields == null || fields.length == 0 || fields[0] == null)) {
            OClass cls;
            Object field = iFromVertex.field(iOutFieldName);
            if (field != null) {
                if (field instanceof OIdentifiable) {
                    if (field.equals(iToVertex)) {
                        new OrientEdge(this.graph, (OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                        return false;
                    }
                } else if (field instanceof OMVRBTreeRIDSet && ((OMVRBTreeRIDSet)field).contains((Object)iToVertex)) {
                    new OrientEdge(this.graph, (OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                    return false;
                }
            }
            if ((field = iToVertex.field(iInFieldName)) != null) {
                if (field instanceof OIdentifiable) {
                    if (field.equals(iFromVertex)) {
                        new OrientEdge(this.graph, (OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                        return false;
                    }
                } else if (field instanceof OMVRBTreeRIDSet && ((OMVRBTreeRIDSet)field).contains((Object)iFromVertex)) {
                    new OrientEdge(this.graph, (OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                    return false;
                }
            }
            if (this.graph.isUseClassForEdgeLabel() && (cls = this.graph.getEdgeType(label)) != null) {
                for (OProperty p : cls.properties()) {
                    if (!p.isMandatory() && !p.isNotNull()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public long countEdges(Direction iDirection, String ... iLabels) {
        long counter = 0L;
        if (this.graph.isUseVertexFieldsForEdgeLabels() || iLabels == null || iLabels.length == 0) {
            ODocument doc = this.getRecord();
            for (String fieldName : doc.fieldNames()) {
                Object fieldValue;
                OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
                if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
                if (fieldValue instanceof Collection) {
                    counter += (long)((Collection)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof Map) {
                    counter += (long)((Map)fieldValue).size();
                    continue;
                }
                ++counter;
            }
        } else {
            for (Edge e : this.getEdges(iDirection, iLabels)) {
                if (e == null) continue;
                ++counter;
            }
        }
        return counter;
    }

    public Iterable<Edge> getEdges(Direction iDirection, String ... iLabels) {
        return this.getEdges(null, iDirection, iLabels);
    }

    public Iterable<Edge> getEdges(Vertex iDestination, Direction iDirection, String ... iLabels) {
        this.graph.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        OMultiCollectionIterator iterable = new OMultiCollectionIterator().setEmbedded(true);
        for (String fieldName : doc.fieldNames()) {
            OIdentifiable destinationVId;
            Object fieldValue;
            OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
            if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
            OIdentifiable oIdentifiable = destinationVId = iDestination != null ? (OIdentifiable)iDestination.getId() : null;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, fieldValue, destinationVId, iLabels);
                continue;
            }
            if (!(fieldValue instanceof Collection)) continue;
            Collection coll = (Collection)fieldValue;
            if (coll.size() == 1) {
                if (coll instanceof ORecordLazyMultiValue) {
                    this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, ((ORecordLazyMultiValue)coll).rawIterator().next(), destinationVId, iLabels);
                    continue;
                }
                if (coll instanceof List) {
                    this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, ((List)coll).get(0), destinationVId, iLabels);
                    continue;
                }
                this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, coll.iterator().next(), destinationVId, iLabels);
                continue;
            }
            if (coll instanceof ORecordLazyMultiValue) {
                iterable.add((Object)new OrientEdgeIterator(this, ((ORecordLazyMultiValue)coll).rawIterator(), connection, iLabels, ((ORecordLazyMultiValue)coll).size()));
                continue;
            }
            iterable.add((Object)new OrientEdgeIterator(this, coll.iterator(), connection, iLabels, -1));
        }
        return iterable;
    }

    public String getLabel() {
        String clsName;
        this.graph.setCurrentGraphInThreadLocal();
        if (this.graph.isUseClassForVertexLabel() && !CLASS_NAME.equals(clsName = this.getRecord().getClassName())) {
            return clsName;
        }
        return (String)this.getRecord().field("label");
    }

    @Override
    public String getBaseClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getElementType() {
        return "Vertex";
    }

    public String toString() {
        this.graph.setCurrentGraphInThreadLocal();
        String clsName = this.getRecord().getClassName();
        if (clsName.equals(CLASS_NAME)) {
            return StringFactory.vertexString((Vertex)this);
        }
        return "v(" + clsName + ")" + "[" + this.getId() + "]";
    }

    protected OPair<Direction, String> getConnection(Direction iDirection, String iFieldName, String ... iClassNames) {
        if (iDirection == Direction.OUT || iDirection == Direction.BOTH) {
            if (this.graph.isUseVertexFieldsForEdgeLabels()) {
                if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair((Comparable)Direction.OUT, (Object)this.getConnectionClass(Direction.OUT, iFieldName));
                    }
                    for (String clsName : iClassNames) {
                        clsName = OrientBaseGraph.encodeClassName(clsName);
                        if (!iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) continue;
                        return new OPair((Comparable)Direction.OUT, (Object)clsName);
                    }
                }
            } else if (iFieldName.equals("out")) {
                return new OPair((Comparable)Direction.OUT, null);
            }
        }
        if (iDirection == Direction.IN || iDirection == Direction.BOTH) {
            if (this.graph.isUseVertexFieldsForEdgeLabels()) {
                if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair((Comparable)Direction.IN, (Object)this.getConnectionClass(Direction.IN, iFieldName));
                    }
                    for (String clsName : iClassNames) {
                        if (!iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) continue;
                        return new OPair((Comparable)Direction.IN, (Object)clsName);
                    }
                }
            } else if (iFieldName.equals("in")) {
                return new OPair((Comparable)Direction.IN, null);
            }
        }
        return null;
    }

    public static String getConnectionFieldName(Direction iDirection, String iClassName, boolean useVertexFieldsForEdgeLabels) {
        if (iDirection == null || iDirection == Direction.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        if (useVertexFieldsForEdgeLabels) {
            String prefix;
            String string = prefix = iDirection == Direction.OUT ? CONNECTION_OUT_PREFIX : CONNECTION_IN_PREFIX;
            if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
                return prefix;
            }
            return prefix + iClassName;
        }
        return iDirection == Direction.OUT ? "out" : "in";
    }

    public static Object createLink(ODocument iFromVertex, OIdentifiable iTo, String iFieldName) {
        OIdentifiable out;
        Object found = iFromVertex.field(iFieldName);
        if (found == null) {
            out = iTo;
        } else if (found instanceof OIdentifiable) {
            if (found.equals(iTo)) {
                return found;
            }
            out = new OMVRBTreeRIDSet((ORecord)iFromVertex);
            ((OMVRBTreeRIDSet)out).add((OIdentifiable)found);
            ((OMVRBTreeRIDSet)out).add(iTo);
        } else if (found instanceof OMVRBTreeRIDSet) {
            out = null;
            ((OMVRBTreeRIDSet)found).add(iTo);
        } else {
            throw new IllegalStateException("Relationship content is invalid on field " + iFieldName + ". Found: " + found);
        }
        if (out != null) {
            iFromVertex.field(iFieldName, (Object)out);
        }
        return out;
    }

    public static Direction getConnectionDirection(String iConnectionField, boolean useVertexFieldsForEdgeLabels) {
        if (iConnectionField == null) {
            throw new IllegalArgumentException("Cannot return direction of NULL connection ");
        }
        if (useVertexFieldsForEdgeLabels) {
            if (iConnectionField.startsWith(CONNECTION_OUT_PREFIX)) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith(CONNECTION_IN_PREFIX)) {
                return Direction.IN;
            }
        } else {
            if (iConnectionField.equals("out")) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith("in")) {
                return Direction.IN;
            }
        }
        throw new IllegalArgumentException("Cannot return direction of connection " + iConnectionField);
    }

    public String getConnectionClass(Direction iDirection, String iFieldName) {
        if (iDirection == Direction.OUT) {
            if (iFieldName.length() > CONNECTION_OUT_PREFIX.length()) {
                return iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
        } else if (iDirection == Direction.IN && iFieldName.length() > CONNECTION_IN_PREFIX.length()) {
            return iFieldName.substring(CONNECTION_IN_PREFIX.length());
        }
        return "E";
    }

    public static String getInverseConnectionFieldName(String iFieldName, boolean useVertexFieldsForEdgeLabels) {
        if (useVertexFieldsForEdgeLabels) {
            if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                if (iFieldName.length() == CONNECTION_OUT_PREFIX.length()) {
                    return CONNECTION_IN_PREFIX;
                }
                return CONNECTION_IN_PREFIX + iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
            if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                if (iFieldName.length() == CONNECTION_IN_PREFIX.length()) {
                    return CONNECTION_OUT_PREFIX;
                }
                return CONNECTION_OUT_PREFIX + iFieldName.substring(CONNECTION_IN_PREFIX.length());
            }
            throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
        }
        if (iFieldName.equals("out")) {
            return "in";
        }
        if (iFieldName.equals("in")) {
            return "out";
        }
        throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEdges(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels) {
        if (iVertex == null) {
            return;
        }
        OMVRBTreeRID.getLock().acquireExclusiveLock();
        try {
            Object fieldValue;
            Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
            if (fieldValue == null) {
                return;
            }
            if (fieldValue instanceof OIdentifiable) {
                if (iVertexToRemove != null) {
                    if (!fieldValue.equals(iVertexToRemove)) {
                        return;
                    }
                    iVertex.removeField(iFieldName);
                }
                if (iAlsoInverse) {
                    OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, fieldValue, useVertexFieldsForEdgeLabels);
                }
                OrientVertex.deleteEdgeIfAny((OIdentifiable)fieldValue);
            } else if (fieldValue instanceof OMVRBTreeRIDSet) {
                if (iVertexToRemove != null) {
                    if (!((OMVRBTreeRIDSet)fieldValue).remove((Object)iVertexToRemove)) {
                        boolean found = false;
                        OLazyIterator it = ((OMVRBTreeRIDSet)fieldValue).iterator(false);
                        while (it.hasNext()) {
                            Direction direction;
                            ODocument curr = (ODocument)((OIdentifiable)it.next()).getRecord();
                            if (iVertexToRemove.equals(curr)) {
                                it.remove();
                                if (iAlsoInverse) {
                                    OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                                }
                                found = true;
                                break;
                            }
                            if (!curr.getSchemaClass().isSubClassOf("E") || !curr.getSchemaClass().isSubClassOf("E") || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                            it.remove();
                            if (iAlsoInverse) {
                                OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                            }
                            found = true;
                            break;
                        }
                        if (!found) {
                            OLogManager.instance().warn(null, "[OrientVertex.removeEdges] edge %s not found in field %s", new Object[]{iVertexToRemove, iFieldName});
                        }
                    }
                    OrientVertex.deleteEdgeIfAny(iVertexToRemove);
                } else {
                    OLazyIterator it = ((OMVRBTreeRIDSet)fieldValue).iterator(false);
                    while (it.hasNext()) {
                        OrientVertex.deleteEdgeIfAny((OIdentifiable)it.next());
                    }
                }
            }
        }
        finally {
            OMVRBTreeRID.getLock().releaseExclusiveLock();
        }
    }

    private static void deleteEdgeIfAny(OIdentifiable iRecord) {
        ODocument doc;
        if (iRecord != null && (doc = (ODocument)iRecord.getRecord()) != null && doc.getSchemaClass() != null && doc.getSchemaClass().isSubClassOf("E")) {
            doc.delete();
        }
    }

    private static void removeInverseEdge(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, Object iFieldValue, boolean useVertexFieldsForEdgeLabels) {
        ODocument r = (ODocument)((OIdentifiable)iFieldValue).getRecord();
        if (r == null) {
            return;
        }
        String inverseFieldName = OrientVertex.getInverseConnectionFieldName(iFieldName, useVertexFieldsForEdgeLabels);
        if (r.getSchemaClass().isSubClassOf(CLASS_NAME)) {
            OrientVertex.removeEdges(r, inverseFieldName, (OIdentifiable)iVertex, false, useVertexFieldsForEdgeLabels);
        } else if (r.getSchemaClass().isSubClassOf("E")) {
            OIdentifiable otherVertex = OrientEdge.getConnection(r, OrientVertex.getConnectionDirection(inverseFieldName, useVertexFieldsForEdgeLabels));
            if (otherVertex != null) {
                if (iVertexToRemove == null || otherVertex.equals(iVertexToRemove)) {
                    OrientVertex.removeEdges((ODocument)otherVertex.getRecord(), inverseFieldName, (OIdentifiable)iFieldValue, false, useVertexFieldsForEdgeLabels);
                }
            } else {
                throw new IllegalStateException("Invalid content found in " + iFieldName + " field");
            }
        }
    }

    private void addSingleVertex(ODocument doc, OMultiCollectionIterator<Vertex> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, String[] iLabels) {
        OrientVertex toAdd;
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        if (fieldRecord.getSchemaClass().isSubClassOf(CLASS_NAME)) {
            toAdd = new OrientVertex(this.graph, (OIdentifiable)fieldRecord);
        } else if (fieldRecord.getSchemaClass().isSubClassOf("E")) {
            if (this.graph.isUseVertexFieldsForEdgeLabels() || OrientEdge.isLabeled(OrientEdge.getRecordLabel((OIdentifiable)fieldRecord), iLabels)) {
                OIdentifiable vertexDoc = OrientEdge.getConnection(fieldRecord, ((Direction)connection.getKey()).opposite());
                if (vertexDoc == null) {
                    fieldRecord.reload();
                    if (vertexDoc == null) {
                        OLogManager.instance().warn((Object)this, "Cannot load edge " + fieldRecord + " to get the " + ((Direction)connection.getKey()).opposite() + " vertex", new Object[0]);
                        return;
                    }
                }
                toAdd = new OrientVertex(this.graph, vertexDoc);
            } else {
                toAdd = null;
            }
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        if (toAdd != null) {
            iterable.add((Object)toAdd);
        }
    }

    private void addSingleEdge(ODocument doc, OMultiCollectionIterator<Edge> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientEdge toAdd;
        if (iTargetVertex != null && !iTargetVertex.equals(fieldValue)) {
            return;
        }
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        if (fieldRecord.getSchemaClass().isSubClassOf(CLASS_NAME)) {
            toAdd = connection.getKey() == Direction.OUT ? new OrientEdge(this.graph, (OIdentifiable)doc, (OIdentifiable)fieldRecord, (String)connection.getValue()) : new OrientEdge(this.graph, (OIdentifiable)fieldRecord, (OIdentifiable)doc, (String)connection.getValue());
        } else if (fieldRecord.getSchemaClass().isSubClassOf("E")) {
            toAdd = new OrientEdge(this.graph, (OIdentifiable)fieldRecord);
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        if (this.graph.isUseVertexFieldsForEdgeLabels() || toAdd.isLabeled(iLabels)) {
            iterable.add((Object)toAdd);
        }
    }
}

