/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphContext;

public abstract class OrientTransactionalGraph
extends OrientBaseGraph
implements TransactionalGraph {
    protected boolean autoStartTx = true;

    public OrientTransactionalGraph(ODatabaseDocumentTx iDatabase) {
        super(iDatabase);
    }

    public OrientTransactionalGraph(String url) {
        super(url, "admin", "admin");
    }

    public OrientTransactionalGraph(String url, String username, String password) {
        super(url, username, password);
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        OrientGraphContext context = this.getContext(false);
        if (context == null) {
            return;
        }
        if (context.rawGraph.isClosed() || context.rawGraph.getTransaction() instanceof OTransactionNoTx || context.rawGraph.getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            return;
        }
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        OrientGraphContext context = this.getContext(false);
        if (context == null) {
            return;
        }
        context.rawGraph.commit();
    }

    @Override
    public void rollback() {
        OrientGraphContext context = this.getContext(false);
        if (context == null) {
            return;
        }
        context.rawGraph.rollback();
    }

    @Override
    protected void autoStartTransaction() {
        super.autoStartTransaction();
        if (!this.autoStartTx) {
            return;
        }
        OrientGraphContext context = this.getContext(true);
        if (context.rawGraph.getTransaction() instanceof OTransactionNoTx && context.rawGraph.getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            context.rawGraph.begin();
        }
    }

    public boolean isAutoStartTx() {
        return this.autoStartTx;
    }

    public void setAutoStartTx(boolean autoStartTx) {
        this.autoStartTx = autoStartTx;
    }
}

