/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.util.DefaultGraphQuery;
import com.tinkerpop.blueprints.util.DefaultQuery;
import java.util.Collection;
import java.util.Collections;

public class OrientGraphQuery
extends DefaultGraphQuery {
    protected static final char SPACE = ' ';
    protected static final String OPERATOR_DIFFERENT = "<>";
    protected static final String OPERATOR_NOT = "not ";
    protected static final String OPERATOR_IS_NOT = "is not";
    protected static final String OPERATOR_LET = "<=";
    protected static final char OPERATOR_LT = '<';
    protected static final String OPERATOR_GTE = ">=";
    protected static final char OPERATOR_GT = '>';
    protected static final String OPERATOR_EQUALS = "=";
    protected static final String OPERATOR_IS = "is";
    protected static final String OPERATOR_IN = " in ";
    protected static final String QUERY_FILTER_AND = " and ";
    protected static final String QUERY_FILTER_OR = " or ";
    protected static final char QUERY_STRING = '\'';
    protected static final char QUERY_SEPARATOR = ',';
    protected static final char COLLECTION_BEGIN = '[';
    protected static final char COLLECTION_END = ']';
    protected static final char PARENTHESIS_BEGIN = '(';
    protected static final char PARENTHESIS_END = ')';
    protected static final String QUERY_LABEL_BEGIN = " and label in [";
    protected static final String QUERY_LABEL_END = "]";
    protected static final String QUERY_WHERE = " where ";
    protected static final String QUERY_SELECT_FROM = "select from ";
    protected static final String LIMIT = " LIMIT ";
    protected String fetchPlan;

    public OrientGraphQuery(Graph iGraph) {
        super(iGraph);
    }

    public Query labels(String ... labels) {
        this.labels = labels;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterable<Vertex> vertices() {
        if (this.limit == 0) {
            return Collections.emptyList();
        }
        if (((OrientBaseGraph)this.graph).getRawGraph().getTransaction().isActive()) {
            return super.vertices();
        }
        StringBuilder text = new StringBuilder();
        text.append(QUERY_SELECT_FROM);
        if (((OrientBaseGraph)this.graph).isUseClassForVertexLabel() && this.labels != null && this.labels.length > 0) {
            if (this.labels.length != 1) return super.vertices();
            text.append(OrientBaseGraph.encodeClassName(this.labels[0]));
        } else {
            text.append("V");
        }
        text.append(QUERY_WHERE);
        this.manageFilters(text);
        if (!((OrientBaseGraph)this.graph).isUseClassForVertexLabel()) {
            this.manageLabels(text);
        }
        if (this.limit > 0 && (long)this.limit < Long.MAX_VALUE) {
            text.append(LIMIT);
            text.append(this.limit);
        }
        OSQLSynchQuery query = new OSQLSynchQuery(text.toString());
        if (this.fetchPlan == null) return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, new Object[0]));
        query.setFetchPlan(this.fetchPlan);
        return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, new Object[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterable<Edge> edges() {
        if (this.limit == 0) {
            return Collections.emptyList();
        }
        if (((OrientBaseGraph)this.graph).getRawGraph().getTransaction().isActive()) {
            return super.edges();
        }
        if (((OrientBaseGraph)this.graph).isUseLightweightEdges()) {
            return super.edges();
        }
        StringBuilder text = new StringBuilder();
        text.append(QUERY_SELECT_FROM);
        if (((OrientBaseGraph)this.graph).isUseClassForEdgeLabel() && this.labels != null && this.labels.length > 0) {
            if (this.labels.length != 1) return super.edges();
            text.append(OrientBaseGraph.encodeClassName(this.labels[0]));
        } else {
            text.append("E");
        }
        text.append(QUERY_WHERE);
        this.manageFilters(text);
        if (!((OrientBaseGraph)this.graph).isUseClassForEdgeLabel()) {
            this.manageLabels(text);
        }
        OSQLSynchQuery query = new OSQLSynchQuery(text.toString());
        if (this.fetchPlan != null) {
            query.setFetchPlan(this.fetchPlan);
        }
        if (this.limit <= 0 || (long)this.limit >= Long.MAX_VALUE) return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, new Object[0]));
        query.setLimit(this.limit);
        return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, new Object[0]));
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    protected void manageLabels(StringBuilder text) {
        if (this.labels != null && this.labels.length > 0) {
            text.append(QUERY_LABEL_BEGIN);
            for (int i = 0; i < this.labels.length; ++i) {
                if (i > 0) {
                    text.append(',');
                }
                text.append('\'');
                text.append(this.labels[i]);
                text.append('\'');
            }
            text.append(QUERY_LABEL_END);
        }
    }

    protected void manageFilters(StringBuilder text) {
        boolean firstPredicate = true;
        for (DefaultQuery.HasContainer has : this.hasContainers) {
            if (!firstPredicate) {
                text.append(QUERY_FILTER_AND);
            } else {
                firstPredicate = false;
            }
            if (has.predicate instanceof Contains) {
                if (has.predicate == Contains.NOT_IN) {
                    text.append(OPERATOR_NOT);
                    text.append('(');
                }
                text.append(has.key);
                text.append(OPERATOR_IN);
                text.append('[');
                boolean firstItem = true;
                for (Object o : (Collection)has.value) {
                    if (!firstItem) {
                        text.append(',');
                    } else {
                        firstItem = false;
                    }
                    this.generateFilterValue(text, o);
                }
                text.append(']');
                if (has.predicate != Contains.NOT_IN) continue;
                text.append(')');
                continue;
            }
            text.append(has.key);
            text.append(' ');
            if (has.predicate instanceof Compare) {
                Compare compare = (Compare)has.predicate;
                switch (compare) {
                    case EQUAL: {
                        if (has.value == null) {
                            text.append(OPERATOR_IS);
                            break;
                        }
                        text.append(OPERATOR_EQUALS);
                        break;
                    }
                    case GREATER_THAN: {
                        text.append('>');
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        text.append(OPERATOR_GTE);
                        break;
                    }
                    case LESS_THAN: {
                        text.append('<');
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        text.append(OPERATOR_LET);
                        break;
                    }
                    case NOT_EQUAL: {
                        if (has.value == null) {
                            text.append(OPERATOR_IS_NOT);
                            break;
                        }
                        text.append(OPERATOR_DIFFERENT);
                    }
                }
                text.append(' ');
                this.generateFilterValue(text, has.value);
            }
            if (!(has.value instanceof Collection)) continue;
            text.append(')');
        }
    }

    protected void generateFilterValue(StringBuilder text, Object iValue) {
        if (iValue instanceof String) {
            text.append('\'');
        }
        text.append(iValue);
        if (iValue instanceof String) {
            text.append('\'');
        }
    }
}

