/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.MetaGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientElementScanIterable;
import com.tinkerpop.blueprints.impls.orient.OrientGraphCommand;
import com.tinkerpop.blueprints.impls.orient.OrientGraphContext;
import com.tinkerpop.blueprints.impls.orient.OrientGraphQuery;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class OrientBaseGraph
implements IndexableGraph,
MetaGraph<ODatabaseDocumentTx>,
KeyIndexableGraph {
    public static final String CONNECTION_OUT = "out";
    public static final String CONNECTION_IN = "in";
    public static final String CLASS_PREFIX = "class:";
    public static final String CLUSTER_PREFIX = "cluster:";
    protected static final String ADMIN = "admin";
    protected boolean useLightweightEdges = true;
    protected boolean useClassForEdgeLabel = true;
    protected boolean useClassForVertexLabel = true;
    protected boolean keepInMemoryReferences = false;
    protected boolean useVertexFieldsForEdgeLabels = true;
    protected boolean saveOriginalIds = false;
    protected THREAD_MODE threadMode = THREAD_MODE.AUTOSET_IFNULL;
    private String url;
    private String username;
    private String password;
    private static final ThreadLocal<OrientGraphContext> threadContext = new ThreadLocal();
    private static final List<OrientGraphContext> contexts = new ArrayList<OrientGraphContext>();

    public OrientBaseGraph(ODatabaseDocumentTx iDatabase) {
        this.reuse(iDatabase);
        this.config();
    }

    public OrientBaseGraph(String url) {
        this(url, ADMIN, ADMIN);
    }

    public OrientBaseGraph(String url, String username, String password) {
        this.url = OFileUtils.getPath((String)url);
        this.username = username;
        this.password = password;
        this.openOrCreate();
        this.config();
    }

    private void config() {
        List custom = (List)this.getRawGraph().get(ODatabase.ATTRIBUTES.CUSTOM);
        for (OStorageEntryConfiguration c : custom) {
            if (c.name.equals("useLightweightEdges")) {
                this.setUseLightweightEdges(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForEdgeLabel")) {
                this.setUseClassForEdgeLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForVertexLabel")) {
                this.setUseClassForVertexLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (!c.name.equals("useVertexFieldsForEdgeLabels")) continue;
            this.setUseVertexFieldsForEdgeLabels(Boolean.parseBoolean(c.value));
        }
    }

    public void drop() {
        this.getRawGraph().drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        OrientGraphContext context = this.getContext(true);
        this.commitAnyActiveTx("create index '" + indexName + "'");
        List<OrientGraphContext> list = contexts;
        synchronized (list) {
            if (context.manualIndices.containsKey(indexName)) {
                throw ExceptionFactory.indexAlreadyExists((String)indexName);
            }
            OrientIndex index = new OrientIndex(this, indexName, indexClass, null);
            for (OrientGraphContext ctx : contexts) {
                ctx.manualIndices.put(index.getIndexName(), index);
            }
            this.saveIndexConfiguration();
            return index;
        }
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        OrientGraphContext context = this.getContext(true);
        Index index = context.manualIndices.get(indexName);
        if (null == index) {
            return null;
        }
        if (indexClass.isAssignableFrom(index.getIndexClass())) {
            return index;
        }
        throw ExceptionFactory.indexDoesNotSupportClass((String)indexName, indexClass);
    }

    public Iterable<Index<? extends Element>> getIndices() {
        OrientGraphContext context = this.getContext(true);
        ArrayList<Index<? extends Element>> list = new ArrayList<Index<? extends Element>>();
        for (Index index : context.manualIndices.values()) {
            list.add((Index<? extends Element>)index);
        }
        return list;
    }

    protected Iterable<OrientIndex<? extends OrientElement>> getManualIndices() {
        return this.getContext((boolean)true).manualIndices.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String indexName) {
        this.commitAnyActiveTx("drop index");
        try {
            List<OrientGraphContext> list = contexts;
            synchronized (list) {
                for (OrientGraphContext ctx : contexts) {
                    ctx.manualIndices.remove(indexName);
                }
            }
            this.getRawGraph().getMetadata().getIndexManager().dropIndex(indexName);
            this.saveIndexConfiguration();
        }
        catch (Exception e) {
            this.rollback();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public OrientVertex addVertex(Object id) {
        return this.addVertex(id, (Object[])null);
    }

    public OrientVertex addVertex(Object id, Object ... prop) {
        String className = null;
        String clusterName = null;
        Object[] fields = null;
        if (id != null) {
            if (id instanceof String) {
                String[] args;
                for (String s : args = ((String)id).split(",")) {
                    if (s.startsWith(CLASS_PREFIX)) {
                        className = s.substring(CLASS_PREFIX.length());
                        continue;
                    }
                    if (!s.startsWith(CLUSTER_PREFIX)) continue;
                    clusterName = s.substring(CLUSTER_PREFIX.length());
                }
            }
            if (this.saveOriginalIds) {
                fields = new Object[]{OrientElement.DEF_ORIGINAL_ID_FIELDNAME, id};
            }
        }
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, className, fields);
        vertex.setProperties(prop);
        if (clusterName != null) {
            vertex.save(clusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    public OrientVertex addVertex(String iClassName, String iClusterName) {
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, iClassName, new Object[0]);
        if (iClusterName != null) {
            vertex.save(iClusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    public OrientVertex addTemporaryVertex(String iClassName, Object ... prop) {
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, iClassName, new Object[0]);
        vertex.setProperties(prop);
        return vertex;
    }

    public OrientEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Object[] objectArray;
        String className = null;
        if (id != null && id instanceof String && id.toString().startsWith(CLASS_PREFIX)) {
            className = id.toString().substring(CLASS_PREFIX.length());
        }
        if (this.saveOriginalIds && id != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = OrientElement.DEF_ORIGINAL_ID_FIELDNAME;
            objectArray = objectArray2;
            objectArray2[1] = id;
        } else {
            objectArray = null;
        }
        Object[] fields = objectArray;
        return ((OrientVertex)outVertex).addEdge(label, (OrientVertex)inVertex, className, null, fields);
    }

    public OrientVertex getVertex(Object id) {
        ORID rid;
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof OrientVertex) {
            return (OrientVertex)id;
        }
        if (id instanceof ODocument) {
            return new OrientVertex(this, (OIdentifiable)id);
        }
        this.setCurrentGraphInThreadLocal();
        if (id instanceof OIdentifiable) {
            rid = ((OIdentifiable)id).getIdentity();
        } else {
            try {
                rid = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        if (!rid.isValid()) {
            return null;
        }
        ODocument doc = (ODocument)rid.getRecord();
        if (doc == null) {
            return null;
        }
        return new OrientVertex(this, (OIdentifiable)doc);
    }

    public void removeVertex(Vertex vertex) {
        vertex.remove();
    }

    public Iterable<Vertex> getVertices() {
        return this.getVerticesOfClass("V", true);
    }

    public Iterable<Vertex> getVertices(boolean iPolymorphic) {
        return this.getVerticesOfClass("V", iPolymorphic);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName) {
        return this.getVerticesOfClass(iClassName, true);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName, boolean iPolymorphic) {
        this.getContext(true);
        return new OrientElementScanIterable(this, iClassName, iPolymorphic);
    }

    public Iterable<Vertex> getVertices(String iKey, Object iValue) {
        String key;
        String indexName;
        if (iKey.equals("@class")) {
            return this.getVerticesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            key = iKey.substring(iKey.indexOf(46) + 1);
        } else {
            indexName = "V." + iKey;
            key = iKey;
        }
        OIndex idx = this.getContext((boolean)true).rawGraph.getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            List<Object> indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        return this.query().has(key, iValue).vertices();
    }

    public Iterable<Edge> getEdges() {
        return this.getEdgesOfClass("E", true);
    }

    public Iterable<Edge> getEdges(boolean iPolymorphic) {
        return this.getEdgesOfClass("E", iPolymorphic);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName) {
        return this.getEdgesOfClass(iClassName, true);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName, boolean iPolymorphic) {
        this.getContext(true);
        return new OrientElementScanIterable(this, iClassName, iPolymorphic);
    }

    public Iterable<Edge> getEdges(String iKey, Object iValue) {
        String key;
        String indexName;
        if (iKey.equals("@class")) {
            return this.getEdgesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            key = iKey.substring(iKey.indexOf(46) + 1);
        } else {
            indexName = "E." + iKey;
            key = iKey;
        }
        OIndex idx = this.getContext((boolean)true).rawGraph.getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            List<Object> indexValue = (List<Object>)idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, indexValue);
        }
        return this.query().has(key, iValue).edges();
    }

    public OrientEdge getEdge(Object id) {
        OIdentifiable rec;
        if (null == id) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        if (id instanceof OrientEdge) {
            return (OrientEdge)id;
        }
        if (id instanceof ODocument) {
            return new OrientEdge(this, (OIdentifiable)id);
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            String str = id.toString();
            int pos = str.indexOf("->");
            if (pos > -1) {
                String from = str.substring(0, pos);
                String to = str.substring(pos + 2);
                return new OrientEdge(this, (OIdentifiable)new ORecordId(from), (OIdentifiable)new ORecordId(to));
            }
            try {
                rec = new ORecordId(str);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc == null) {
            return null;
        }
        return new OrientEdge(this, rec);
    }

    public void removeEdge(Edge edge) {
        edge.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrientBaseGraph reuse(ODatabaseDocumentTx iDatabase) {
        this.url = iDatabase.getURL();
        this.username = iDatabase.getUser() != null ? iDatabase.getUser().getName() : null;
        OrientBaseGraph orientBaseGraph = this;
        synchronized (orientBaseGraph) {
            OrientGraphContext context = threadContext.get();
            if (context == null || !context.rawGraph.getName().equals(iDatabase.getName())) {
                this.removeContext();
                context = new OrientGraphContext();
                context.rawGraph = iDatabase;
                this.checkForGraphSchema(iDatabase);
                threadContext.set(context);
            }
        }
        return this;
    }

    protected void checkForGraphSchema(ODatabaseDocumentTx iDatabase) {
        OSchema schema = iDatabase.getMetadata().getSchema();
        schema.getOrCreateClass("ORIDs");
        OClass vertexBaseClass = schema.getClass("V");
        OClass edgeBaseClass = schema.getClass("E");
        if (vertexBaseClass == null) {
            schema.createClass("V").setOverSize(2.0f);
        }
        if (edgeBaseClass == null) {
            schema.createClass("E");
        }
        boolean warn = false;
        String MSG_SUFFIX = ". Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it";
        if (vertexBaseClass != null) {
            if (!vertexBaseClass.getName().equals("V")) {
                OLogManager.instance().warn((Object)this, "Found Vertex class %s. Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it", new Object[]{vertexBaseClass.getName()});
                warn = true;
            }
            if (vertexBaseClass.existsProperty(CONNECTION_OUT) || vertexBaseClass.existsProperty(CONNECTION_IN)) {
                OLogManager.instance().warn((Object)this, "Found property in/out against V", new Object[0]);
                warn = true;
            }
        }
        if (edgeBaseClass != null) {
            if (!warn && !edgeBaseClass.getName().equals("E")) {
                OLogManager.instance().warn((Object)this, "Found Edge class %s. Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it", new Object[]{edgeBaseClass.getName()});
                warn = true;
            }
            if (edgeBaseClass.existsProperty(CONNECTION_OUT) || edgeBaseClass.existsProperty(CONNECTION_IN)) {
                OLogManager.instance().warn((Object)this, "Found property in/out against E", new Object[0]);
                warn = true;
            }
        }
    }

    public boolean isClosed() {
        return this.getRawGraph().isClosed();
    }

    public void shutdown() {
        this.removeContext();
        this.url = null;
        this.username = null;
        this.password = null;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.getRawGraph().getURL());
    }

    public ODatabaseDocumentTx getRawGraph() {
        return this.getContext((boolean)true).rawGraph;
    }

    public void commit() {
    }

    public void rollback() {
    }

    public OClass getVertexBaseType() {
        return this.getRawGraph().getMetadata().getSchema().getClass("V");
    }

    public final OClass getVertexType(String iTypeName) {
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls != null) {
            this.checkVertexType(cls);
        }
        return cls;
    }

    public OClass createVertexType(String iClassName) {
        this.commitAnyActiveTx("create vertex type '" + iClassName + "'");
        return this.getRawGraph().getMetadata().getSchema().createClass(iClassName, this.getVertexBaseType());
    }

    public OClass createVertexType(String iClassName, String iSuperClassName) {
        this.commitAnyActiveTx("create vertex type '" + iClassName + "' as subclass of '" + iSuperClassName + "'");
        return this.getRawGraph().getMetadata().getSchema().createClass(iClassName, this.getVertexType(iSuperClassName));
    }

    public OClass createVertexType(String iClassName, OClass iSuperClass) {
        this.checkVertexType(iSuperClass);
        this.commitAnyActiveTx("create vertex type '" + iClassName + "' as subclass of '" + iSuperClass.getName() + "'");
        return this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass);
    }

    public final void dropVertexType(String iTypeName) {
        this.commitAnyActiveTx("drop vertex type '" + iTypeName + "'");
        this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
    }

    public OClass getEdgeBaseType() {
        return this.getRawGraph().getMetadata().getSchema().getClass("E");
    }

    public final OClass getEdgeType(String iTypeName) {
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls != null) {
            this.checkEdgeType(cls);
        }
        return cls;
    }

    public OClass createEdgeType(String iClassName) {
        this.commitAnyActiveTx("create edge type '" + iClassName + "'");
        return this.getRawGraph().getMetadata().getSchema().createClass(iClassName, this.getEdgeBaseType());
    }

    public OClass createEdgeType(String iClassName, String iSuperClassName) {
        this.commitAnyActiveTx("create edge type '" + iClassName + "' as subclass of '" + iSuperClassName + "'");
        return this.getRawGraph().getMetadata().getSchema().createClass(iClassName, this.getEdgeType(iSuperClassName));
    }

    public OClass createEdgeType(String iClassName, OClass iSuperClass) {
        this.checkEdgeType(iSuperClass);
        this.commitAnyActiveTx("create edge type '" + iClassName + "' as subclass of '" + iSuperClass.getName() + "'");
        return this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass);
    }

    public final void dropEdgeType(String iTypeName) {
        this.commitAnyActiveTx("drop edge type '" + iTypeName + "'");
        this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
    }

    protected final void checkVertexType(OClass iType) {
        if (iType == null) {
            throw new IllegalArgumentException("Vertex class is null");
        }
        if (!iType.isSubClassOf("V")) {
            throw new IllegalArgumentException("Type error. The class " + iType + " does not extend class '" + "V" + "' and therefore cannot be considered a Vertex");
        }
    }

    protected final void checkEdgeType(OClass iType) {
        if (iType == null) {
            throw new IllegalArgumentException("Edge class is null");
        }
        if (!iType.isSubClassOf("E")) {
            throw new IllegalArgumentException("Type error. The class " + iType + " does not extend class '" + "E" + "' and therefore cannot be considered an Edge");
        }
    }

    public OrientElement getElement(Object id) {
        OIdentifiable rec;
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof OrientElement) {
            return (OrientElement)id;
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            try {
                rec = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc != null) {
            OClass schemaClass = doc.getSchemaClass();
            if (schemaClass.isSubClassOf("V")) {
                return new OrientVertex(this, (OIdentifiable)doc);
            }
            if (schemaClass.isSubClassOf("E")) {
                return new OrientEdge(this, (OIdentifiable)doc);
            }
            throw new IllegalArgumentException("Type error. The class " + schemaClass + " does not extend class neither '" + "V" + "' nor '" + "E" + "'");
        }
        return null;
    }

    protected void autoStartTransaction() {
        this.setCurrentGraphInThreadLocal();
    }

    protected void saveIndexConfiguration() {
        this.getRawGraph().getMetadata().getIndexManager().getConfiguration().save();
    }

    protected OrientGraphContext getContext(boolean create) {
        OrientGraphContext context = threadContext.get();
        if ((context == null || !context.rawGraph.getURL().equals(this.url)) && create) {
            context = this.openOrCreate();
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrientGraphContext openOrCreate() {
        if (this.url == null) {
            throw new IllegalStateException("Database is closed");
        }
        OrientBaseGraph orientBaseGraph = this;
        synchronized (orientBaseGraph) {
            OrientGraphContext context = threadContext.get();
            if (context != null) {
                this.removeContext();
            }
            context = new OrientGraphContext();
            threadContext.set(context);
            List<OrientGraphContext> list = contexts;
            synchronized (list) {
                contexts.add(context);
            }
            context.rawGraph = new ODatabaseDocumentTx(this.url);
            if (this.url.startsWith("remote:") || context.rawGraph.exists()) {
                context.rawGraph.open(this.username, this.password);
                for (OIndex idx : context.rawGraph.getMetadata().getIndexManager().getIndexes()) {
                    if (idx.getConfiguration().field("blueprintsIndexClass") == null) continue;
                    this.loadIndex(idx);
                }
            } else {
                context.rawGraph.create();
            }
            this.checkForGraphSchema(context.rawGraph);
            return context;
        }
    }

    private OrientIndex<?> loadIndex(OIndex<?> rawIndex) {
        OrientIndex index = new OrientIndex(this, rawIndex);
        this.getContext((boolean)true).manualIndices.put(index.getIndexName(), index);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContext() {
        OrientGraphContext context = this.getContext(false);
        if (context != null) {
            for (Index index : context.manualIndices.values()) {
                ((OrientIndex)index).close();
            }
            context.manualIndices.clear();
            if (!context.rawGraph.isClosed()) {
                context.rawGraph.commit();
                context.rawGraph.close();
            }
            List<OrientGraphContext> list = contexts;
            synchronized (list) {
                contexts.remove(context);
            }
            threadContext.set(null);
        }
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        this.commitAnyActiveTx("drop key index");
        String className = this.getClassName(elementClass);
        this.getRawGraph().getMetadata().getIndexManager().dropIndex(className + "." + key);
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        ODatabaseDocumentTx db;
        OSchema schema;
        OClass cls;
        OProperty property;
        this.commitAnyActiveTx("create key index");
        String indexType = OClass.INDEX_TYPE.NOTUNIQUE.name();
        OType keyType = OType.STRING;
        String className = null;
        String ancestorClassName = this.getClassName(elementClass);
        for (Parameter p : indexParameters) {
            if (p.getKey().equals("type")) {
                indexType = p.getValue().toString().toUpperCase();
                continue;
            }
            if (p.getKey().equals("keytype")) {
                keyType = OType.valueOf((String)p.getValue().toString().toUpperCase());
                continue;
            }
            if (!p.getKey().equals("class")) continue;
            className = p.getValue().toString();
        }
        if (className == null) {
            className = ancestorClassName;
        }
        if ((property = (cls = (schema = (db = this.getRawGraph()).getMetadata().getSchema()).getOrCreateClass(className, schema.getClass(ancestorClassName))).getProperty(key)) != null) {
            keyType = property.getType();
        }
        db.getMetadata().getIndexManager().createIndex(className + "." + key, indexType, (OIndexDefinition)new OPropertyIndexDefinition(className, key, keyType), cls.getPolymorphicClusterIds(), null);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        OSchema schema = this.getRawGraph().getMetadata().getSchema();
        String elementOClassName = this.getClassName(elementClass);
        HashSet<String> result = new HashSet<String>();
        Collection indexes = this.getRawGraph().getMetadata().getIndexManager().getIndexes();
        for (OIndex index : indexes) {
            String oClassName;
            OClass oClass;
            String indexName = index.getName();
            int point = indexName.indexOf(".");
            if (point <= 0 || !(oClass = schema.getClass(oClassName = indexName.substring(0, point))).isSubClassOf(elementOClassName)) continue;
            result.add((String)index.getDefinition().getFields().get(0));
        }
        return result;
    }

    public GraphQuery query() {
        return new OrientGraphQuery((Graph)this);
    }

    public OTraverse traverse() {
        return new OTraverse();
    }

    public OCommandRequest command(OCommandRequest iCommand) {
        return new OrientGraphCommand(this, this.getRawGraph().command(iCommand));
    }

    public boolean isUseLightweightEdges() {
        return this.useLightweightEdges;
    }

    public void setUseLightweightEdges(boolean useDynamicEdges) {
        this.useLightweightEdges = useDynamicEdges;
    }

    public boolean isSaveOriginalIds() {
        return this.saveOriginalIds;
    }

    public void setSaveOriginalIds(boolean saveIds) {
        this.saveOriginalIds = saveIds;
    }

    public long countVertices() {
        return this.getRawGraph().countClass("V");
    }

    public long countVertices(String iClassName) {
        return this.getRawGraph().countClass(iClassName);
    }

    public long countEdges() {
        if (this.useLightweightEdges) {
            throw new UnsupportedOperationException("Graph set to use Lightweight Edges, count against edges is not supported");
        }
        return this.getRawGraph().countClass("E");
    }

    public long countEdges(String iClassName) {
        if (this.useLightweightEdges) {
            throw new UnsupportedOperationException("Graph set to use Lightweight Edges, count against edges is not supported");
        }
        return this.getRawGraph().countClass(iClassName);
    }

    public boolean isKeepInMemoryReferences() {
        return this.keepInMemoryReferences;
    }

    public void setKeepInMemoryReferences(boolean useReferences) {
        this.keepInMemoryReferences = useReferences;
    }

    public boolean isUseClassForEdgeLabel() {
        return this.useClassForEdgeLabel;
    }

    public void setUseClassForEdgeLabel(boolean useCustomClassesForEdges) {
        this.useClassForEdgeLabel = useCustomClassesForEdges;
    }

    public boolean isUseClassForVertexLabel() {
        return this.useClassForVertexLabel;
    }

    public void setUseClassForVertexLabel(boolean useCustomClassesForVertex) {
        this.useClassForVertexLabel = useCustomClassesForVertex;
    }

    public boolean isUseVertexFieldsForEdgeLabels() {
        return this.useVertexFieldsForEdgeLabels;
    }

    public void setUseVertexFieldsForEdgeLabels(boolean useVertexFieldsForEdgeLabels) {
        this.useVertexFieldsForEdgeLabels = useVertexFieldsForEdgeLabels;
    }

    public static String encodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (Character.isDigit(iClassName.charAt(0))) {
            iClassName = "-" + iClassName;
        }
        try {
            return URLEncoder.encode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return iClassName;
        }
    }

    public static String decodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (iClassName.charAt(0) == '-') {
            iClassName = iClassName.substring(1);
        }
        try {
            return URLDecoder.decode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return iClassName;
        }
    }

    protected <T> String getClassName(Class<T> elementClass) {
        if (elementClass.isAssignableFrom(Vertex.class)) {
            return "V";
        }
        if (elementClass.isAssignableFrom(Edge.class)) {
            return "E";
        }
        throw new IllegalArgumentException("Class '" + elementClass + "' is neither a Vertex, nor an Edge");
    }

    protected void commitAnyActiveTx(String iOperation) {
        if (this.getRawGraph().getTransaction().isActive()) {
            OLogManager.instance().warn((Object)this, "Committing the active transaction to %s. To avoid this behavior do it outside the transaction", new Object[]{iOperation});
            this.commit();
        }
    }

    protected Object convertKey(OIndex<?> idx, Object iValue) {
        if (iValue != null) {
            OType[] types = idx.getKeyTypes();
            iValue = types.length == 0 ? iValue.toString() : OType.convert((Object)iValue, (Class)types[0].getDefaultJavaType());
        }
        return iValue;
    }

    public THREAD_MODE getThreadMode() {
        return this.threadMode;
    }

    public OrientBaseGraph setThreadMode(THREAD_MODE iControl) {
        this.threadMode = iControl;
        return this;
    }

    protected void setCurrentGraphInThreadLocal() {
        OrientGraphContext ctx;
        if (this.threadMode == THREAD_MODE.MANUAL) {
            return;
        }
        ODatabaseRecord tlDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (!(this.threadMode != THREAD_MODE.ALWAYS_AUTOSET && tlDb != null || (ctx = this.getContext(true)) == null || tlDb != null && tlDb == ctx.rawGraph)) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.getRawGraph());
        }
    }

    public static enum THREAD_MODE {
        MANUAL,
        AUTOSET_IFNULL,
        ALWAYS_AUTOSET;

    }
}

