/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.maven.plugin.jet;

import com.tikal.codegen.jet.EmitterException;
import com.tikal.codegen.jet.ErrorCode;
import com.tikal.codegen.jet.TemplateEmitter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetMojo
extends AbstractMojo {
    private File generateDirectory;
    private File templateDirectory;
    protected Set<String> includeTemplates = new HashSet<String>();
    protected Set<String> excludeTemplates = new HashSet<String>();
    private boolean readonly;
    private MavenProject project;
    private Set<File> templates = null;

    public void execute() throws MojoExecutionException {
        try {
            Set<File> templates;
            if (!this.generateDirectory.exists()) {
                this.generateDirectory.mkdirs();
            }
            if ((templates = this.getTemplates()) != null) {
                for (File template : templates) {
                    this.getLog().info((CharSequence)String.format("Processing template - %s", template.getName()));
                    TemplateEmitter emitter = new TemplateEmitter(template.toURI().toURL());
                    emitter.parse();
                    File packageDir = new File(this.generateDirectory, emitter.getPackageName().replace('.', '/'));
                    if (!packageDir.exists()) {
                        packageDir.mkdirs();
                    }
                    File classFile = new File(packageDir, emitter.getClassName() + ".java");
                    FileWriter writer = new FileWriter(classFile);
                    writer.write(emitter.generate());
                    writer.flush();
                    writer.close();
                    if (!this.readonly) continue;
                    classFile.setReadOnly();
                }
                if (this.project != null) {
                    this.project.addCompileSourceRoot(this.generateDirectory.getPath());
                }
            }
        }
        catch (EmitterException e) {
            if (e.getErrorCode().equals((Object)ErrorCode.UNKNOWN)) {
                throw new MojoExecutionException(e.getErrorCode().getMessage(e.getMessage()));
            }
            throw new MojoExecutionException(e.getErrorCode().getMessage(e.getParams()));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public Set<String> getIncludesPatterns() {
        if (this.includeTemplates == null || this.includeTemplates.isEmpty()) {
            return Collections.singleton("**/*.template");
        }
        return this.includeTemplates;
    }

    public Set<String> getExcludesPatterns() {
        if (this.excludeTemplates == null || this.excludeTemplates.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return this.includeTemplates;
    }

    public Set<File> getTemplates() throws InclusionScanException {
        if (this.templates == null) {
            SuffixMapping mapping = new SuffixMapping("template", Collections.EMPTY_SET);
            SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(this.getIncludesPatterns(), this.excludeTemplates);
            scan.addSourceMapping((SourceMapping)mapping);
            this.templates = scan.getIncludedSources(this.templateDirectory, null);
        }
        return this.templates;
    }
}

