/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Task;

public abstract class ProtectedTask
extends Task
implements DynamicConfigurator {
    private final AntElement root = new AntElement("root");

    public void setDynamicAttribute(String name, String value) throws BuildException {
        this.root.setDynamicAttribute(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        return this.root.createDynamicElement(name);
    }

    public void execute() throws BuildException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.createClassLoader();
            Class<?> driver = cl.loadClass(this.getCoreClassName());
            Task t = (Task)driver.newInstance();
            t.setProject(this.getProject());
            t.setTaskName(this.getTaskName());
            this.root.configure(t);
            Thread.currentThread().setContextClassLoader(cl);
            t.execute();
        }
        catch (UnsupportedClassVersionError e) {
            throw new BuildException("Requires JDK 5.0 or later. Please download it from http://java.sun.com/j2se/1.5/");
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract String getCoreClassName();

    protected abstract ClassLoader createClassLoader() throws ClassNotFoundException, IOException;

    private class AntElement
    implements DynamicConfigurator {
        private final String name;
        private final Map attributes = new HashMap();
        private final List elements = new ArrayList();

        public AntElement(String name) {
            this.name = name;
        }

        public void setDynamicAttribute(String name, String value) throws BuildException {
            this.attributes.put(name, value);
        }

        public Object createDynamicElement(String name) throws BuildException {
            AntElement e = new AntElement(name);
            this.elements.add(e);
            return e;
        }

        public void configure(Object antObject) {
            IntrospectionHelper ih = IntrospectionHelper.getHelper(antObject.getClass());
            for (Map.Entry att : this.attributes.entrySet()) {
                ih.setAttribute(ProtectedTask.this.getProject(), antObject, (String)att.getKey(), (String)att.getValue());
            }
            for (AntElement e : this.elements) {
                Object child = ih.createElement(ProtectedTask.this.getProject(), antObject, e.name);
                e.configure(child);
                ih.storeElement(ProtectedTask.this.getProject(), antObject, child, e.name);
            }
        }
    }
}

