/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.ErrorBean;
import com.sun.faces.mgbean.ManagedBeanBuilder;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.mgbean.ManagedListBeanBuilder;
import com.sun.faces.mgbean.ManagedMapBeanBuilder;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManager
implements SystemEventListener {
    private static final Logger LOGGER = FacesLogger.MANAGEDBEAN.getLogger();
    private Map<String, BeanBuilder> managedBeans = new HashMap<String, BeanBuilder>();
    private InjectionProvider injectionProvider;
    private boolean configPreprocessed;
    private boolean lazyBeanValidation;
    private List<String> eagerBeans = new ArrayList<String>(4);

    public BeanManager(InjectionProvider injectionProvider, boolean lazyBeanValidation) {
        this.injectionProvider = injectionProvider;
        this.lazyBeanValidation = lazyBeanValidation;
    }

    public BeanManager(InjectionProvider injectionProvider, Map<String, BeanBuilder> managedBeans, boolean lazyBeanValidation) {
        this(injectionProvider, lazyBeanValidation);
        this.managedBeans = managedBeans;
    }

    @Override
    public void processEvent(SystemEvent event) throws AbortProcessingException {
        ScopeContext scopeContext = ((PreDestroyCustomScopeEvent)event).getContext();
        Map<String, Object> scope = scopeContext.getScope();
        for (Map.Entry<String, Object> entry : scope.entrySet()) {
            String name = entry.getKey();
            if (!this.isManaged(name)) continue;
            BeanBuilder builder = this.getBuilder(name);
            builder.destroy(this.injectionProvider, entry.getValue());
        }
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof ScopeContext;
    }

    public void register(ManagedBeanInfo beanInfo) {
        BeanBuilder builder;
        if (beanInfo.hasListEntry()) {
            if (beanInfo.hasMapEntry() || beanInfo.hasManagedProperties()) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_LIST_CONFIG_ERROR", beanInfo.getName());
                builder = new ErrorBean(beanInfo, message);
            } else {
                builder = new ManagedListBeanBuilder(beanInfo);
            }
        } else if (beanInfo.hasMapEntry()) {
            if (beanInfo.hasManagedProperties()) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_MAP_CONFIG_ERROR", beanInfo.getName());
                builder = new ErrorBean(beanInfo, message);
            } else {
                builder = new ManagedMapBeanBuilder(beanInfo);
            }
        } else {
            builder = new ManagedBeanBuilder(beanInfo);
        }
        this.addBean(beanInfo.getName(), builder);
        if (beanInfo.isEager()) {
            this.eagerBeans.add(beanInfo.getName());
        }
    }

    public List<String> getEagerBeanNames() {
        return this.eagerBeans;
    }

    public Map<String, BeanBuilder> getRegisteredBeans() {
        return this.managedBeans;
    }

    public boolean isManaged(String name) {
        return this.managedBeans != null && this.managedBeans.containsKey(name);
    }

    public BeanBuilder getBuilder(String name) {
        if (this.managedBeans != null) {
            return this.managedBeans.get(name);
        }
        return null;
    }

    public void preProcessesBeans() {
        if (!this.configPreprocessed && !this.lazyBeanValidation) {
            this.configPreprocessed = true;
            for (Map.Entry<String, BeanBuilder> entry : this.managedBeans.entrySet()) {
                this.preProcessBean(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isBeanInScope(String name, BeanBuilder builder, FacesContext context) {
        return ScopeManager.isInScope(name, builder.getScope(), context);
    }

    public Object getBeanFromScope(String name, BeanBuilder builder, FacesContext context) {
        return ScopeManager.getFromScope(name, builder.getScope(), context);
    }

    public Object getBeanFromScope(String name, FacesContext context) {
        String scope = this.getBuilder(name).getScope();
        return ScopeManager.getFromScope(name, scope, context);
    }

    public Object create(String name, FacesContext facesContext) {
        return this.create(name, this.managedBeans.get(name), facesContext);
    }

    public Object create(String name, BeanBuilder builder, FacesContext facesContext) {
        if (builder != null) {
            if (this.lazyBeanValidation && !builder.isBaked()) {
                this.preProcessBean(name, builder);
            }
            if (builder.hasMessages()) {
                throw new ManagedBeanCreationException(this.buildMessage(name, builder.getMessages(), true));
            }
            return this.createAndPush(name, builder, facesContext);
        }
        return null;
    }

    public void destroy(String beanName, Object bean) {
        BeanBuilder builder = this.managedBeans.get(beanName);
        if (builder != null) {
            builder.destroy(this.injectionProvider, bean);
        }
    }

    private void addBean(String beanName, BeanBuilder builder) {
        if (this.configPreprocessed) {
            this.preProcessBean(beanName, builder);
        }
        if (LOGGER.isLoggable(Level.WARNING) && this.managedBeans.containsKey(beanName)) {
            LOGGER.log(Level.WARNING, "jsf.managed.bean.duplicate", new Object[]{beanName, this.managedBeans.get((Object)beanName).beanInfo.getClassName(), builder.beanInfo.getClassName()});
        }
        this.managedBeans.put(beanName, builder);
    }

    private void validateReferences(BeanBuilder builder, List<String> references, List<String> messages) {
        List<String> refs = builder.getReferences();
        if (refs != null) {
            for (String ref : refs) {
                if (!this.isManaged(ref)) continue;
                if (references.contains(ref)) {
                    String[] ra;
                    StringBuilder sb = new StringBuilder(64);
                    for (String reference : ra = references.toArray(new String[references.size()])) {
                        sb.append(reference);
                        sb.append(" -> ");
                    }
                    sb.append(ref);
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", ra[0], sb.toString());
                    messages.add(message);
                    continue;
                }
                BeanBuilder b = this.getBuilder(ref);
                if (b.getReferences() == null) continue;
                references.add(ref);
                this.validateReferences(b, references, messages);
                references.remove(ref);
            }
        }
    }

    private synchronized void preProcessBean(String beanName, BeanBuilder builder) {
        if (!builder.isBaked()) {
            try {
                builder.bake();
                List<String> propRefs = builder.getReferences();
                if (propRefs != null) {
                    for (String reference : propRefs) {
                        if (!this.isManaged(reference)) continue;
                        BeanBuilder b = this.getBuilder(reference);
                        this.preProcessBean(reference, b);
                    }
                }
                ArrayList<String> refs = new ArrayList<String>();
                refs.add(beanName);
                ArrayList<String> messages = new ArrayList<String>();
                this.validateReferences(builder, refs, messages);
                if (!messages.isEmpty()) {
                    builder.queueMessages(messages);
                }
                if (builder.hasMessages() && LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, this.buildMessage(beanName, builder.getMessages(), false));
                }
            }
            catch (ManagedBeanPreProcessingException mbpe) {
                if (ManagedBeanPreProcessingException.Type.CHECKED.equals((Object)mbpe.getType())) {
                    builder.queueMessage(mbpe.getMessage());
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, this.buildMessage(beanName, builder.getMessages(), false));
                    }
                }
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNKNOWN_PROCESSING_ERROR", beanName);
                throw new ManagedBeanPreProcessingException(message, mbpe);
            }
        }
    }

    private Object createAndPush(String name, BeanBuilder builder, FacesContext facesContext) {
        Object bean = builder.build(this.injectionProvider, facesContext);
        ScopeManager.pushToScope(name, bean, builder.getScope(), facesContext);
        return bean;
    }

    private String buildMessage(String name, List<String> messages, boolean runtime) {
        StringBuilder sb = new StringBuilder(128);
        if (runtime) {
            sb.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_ERROR", name));
        } else {
            sb.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_STARTUP_ERROR", name));
        }
        for (String message : messages) {
            sb.append("\n     - ").append(message);
        }
        return sb.toString();
    }

    private static class ScopeManager {
        private static final ConcurrentMap<String, ScopeHandler> handlerMap = new ConcurrentHashMap<String, ScopeHandler>(5);

        private ScopeManager() {
        }

        static void pushToScope(String name, Object bean, String customScope, FacesContext context) {
            ScopeHandler handler = ScopeManager.getScopeHandler(customScope, context);
            handler.handle(name, bean, context);
        }

        static boolean isInScope(String name, String customScope, FacesContext context) {
            ScopeHandler handler = ScopeManager.getScopeHandler(customScope, context);
            return handler.isInScope(name, context);
        }

        static Object getFromScope(String name, String customScope, FacesContext context) {
            ScopeHandler handler = ScopeManager.getScopeHandler(customScope, context);
            return handler.getFromScope(name, context);
        }

        private static ScopeHandler getScopeHandler(String customScope, FacesContext context) {
            ScopeHandler handler = (ScopeHandler)handlerMap.get(customScope);
            if (handler == null) {
                ExpressionFactory factory = context.getApplication().getExpressionFactory();
                ValueExpression ve = factory.createValueExpression(context.getELContext(), customScope, Map.class);
                handler = new CustomScopeHandler(ve);
                handlerMap.putIfAbsent(customScope, handler);
            }
            return handler;
        }

        static {
            handlerMap.put(ELUtils.Scope.REQUEST.toString(), new RequestScopeHandler());
            handlerMap.put(ELUtils.Scope.VIEW.toString(), new ViewScopeHandler());
            handlerMap.put(ELUtils.Scope.SESSION.toString(), new SessionScopeHandler());
            handlerMap.put(ELUtils.Scope.APPLICATION.toString(), new ApplicationScopeHandler());
            handlerMap.put(ELUtils.Scope.NONE.toString(), new NoneScopeHandler());
        }

        private static class CustomScopeHandler
        implements ScopeHandler {
            private ValueExpression scope;

            CustomScopeHandler(ValueExpression scope) {
                this.scope = scope;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String name, Object bean, FacesContext context) {
                Map scopeMap = (Map)this.scope.getValue(this.getELContext(context));
                if (scopeMap != null) {
                    CustomScopeHandler customScopeHandler = this;
                    synchronized (customScopeHandler) {
                        scopeMap.put(name, bean);
                    }
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.managed.bean.custom.scope.eval.null", new Object[]{this.scope.getExpressionString()});
                }
            }

            public boolean isInScope(String name, FacesContext context) {
                Map scopeMap = (Map)this.scope.getValue(this.getELContext(context));
                if (scopeMap != null) {
                    return scopeMap.containsKey(name);
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.managed.bean.custom.scope.eval.null.existence", new Object[]{this.scope.getExpressionString()});
                }
                return true;
            }

            public Object getFromScope(String name, FacesContext context) {
                Map scopeMap = (Map)this.scope.getValue(this.getELContext(context));
                if (scopeMap != null) {
                    return scopeMap.get(name);
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.managed.bean.custom.scope.eval.null.existence", new Object[]{this.scope.getExpressionString()});
                }
                return null;
            }

            private ELContext getELContext(FacesContext ctx) {
                return new CustomScopeELContext(ctx.getELContext());
            }

            private static final class CustomScopeELContext
            extends ELContext {
                private ELContext delegate;

                public CustomScopeELContext(ELContext delegate) {
                    this.delegate = delegate;
                }

                public void putContext(Class aClass, Object o) {
                    this.delegate.putContext(aClass, o);
                }

                public Object getContext(Class aClass) {
                    return this.delegate.getContext(aClass);
                }

                public Locale getLocale() {
                    return this.delegate.getLocale();
                }

                public void setLocale(Locale locale) {
                    this.delegate.setLocale(locale);
                }

                public ELResolver getELResolver() {
                    return this.delegate.getELResolver();
                }

                public FunctionMapper getFunctionMapper() {
                    return this.delegate.getFunctionMapper();
                }

                public VariableMapper getVariableMapper() {
                    return this.delegate.getVariableMapper();
                }
            }
        }

        private static class ApplicationScopeHandler
        implements ScopeHandler {
            private ApplicationScopeHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String name, Object bean, FacesContext context) {
                Object object = context.getExternalContext().getContext();
                synchronized (object) {
                    context.getExternalContext().getApplicationMap().put(name, bean);
                }
            }

            public boolean isInScope(String name, FacesContext context) {
                return context.getExternalContext().getApplicationMap().containsKey(name);
            }

            public Object getFromScope(String name, FacesContext context) {
                return context.getExternalContext().getApplicationMap().get(name);
            }
        }

        private static class SessionScopeHandler
        implements ScopeHandler {
            private SessionScopeHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String name, Object bean, FacesContext context) {
                Object object = context.getExternalContext().getSession(true);
                synchronized (object) {
                    context.getExternalContext().getSessionMap().put(name, bean);
                }
            }

            public boolean isInScope(String name, FacesContext context) {
                return context.getExternalContext().getSessionMap().containsKey(name);
            }

            public Object getFromScope(String name, FacesContext context) {
                return context.getExternalContext().getSessionMap().get(name);
            }
        }

        private static class ViewScopeHandler
        implements ScopeHandler {
            private ViewScopeHandler() {
            }

            public void handle(String name, Object bean, FacesContext context) {
                context.getViewRoot().getViewMap().put(name, bean);
            }

            public boolean isInScope(String name, FacesContext context) {
                Map<String, Object> viewMap = context.getViewRoot().getViewMap(false);
                return viewMap != null && viewMap.containsKey(name);
            }

            public Object getFromScope(String name, FacesContext context) {
                Map<String, Object> viewMap = context.getViewRoot().getViewMap(false);
                return viewMap != null ? viewMap.get(name) : null;
            }
        }

        private static class RequestScopeHandler
        implements ScopeHandler {
            private RequestScopeHandler() {
            }

            public void handle(String name, Object bean, FacesContext context) {
                context.getExternalContext().getRequestMap().put(name, bean);
            }

            public boolean isInScope(String name, FacesContext context) {
                return context.getExternalContext().getRequestMap().containsKey(name);
            }

            public Object getFromScope(String name, FacesContext context) {
                return context.getExternalContext().getRequestMap().get(name);
            }
        }

        private static class NoneScopeHandler
        implements ScopeHandler {
            private NoneScopeHandler() {
            }

            public void handle(String name, Object bean, FacesContext context) {
            }

            public boolean isInScope(String name, FacesContext context) {
                return false;
            }

            public Object getFromScope(String name, FacesContext context) {
                return null;
            }
        }

        private static interface ScopeHandler {
            public void handle(String var1, Object var2, FacesContext var3);

            public boolean isInScope(String var1, FacesContext var2);

            public Object getFromScope(String var1, FacesContext var2);
        }
    }
}

