/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.common.FilenameComparator;
import com.samaxes.maven.minify.common.ListOfFiles;
import com.samaxes.maven.minify.plugin.ProcessCSSFilesTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class ProcessFilesTask
implements Callable<Object> {
    public static final String TEMP_SUFFIX = ".tmp";
    protected final Log log;
    protected final Integer bufferSize;
    protected final boolean debug;
    protected final boolean skipMerge;
    protected final boolean skipMinify;
    protected final String charset;
    protected final int linebreak;
    protected final boolean nosuffix;
    protected final String suffix;
    private final String mergedFilename;
    private final File targetDir;
    private final boolean sourceFilesEmpty;
    private final boolean sourceIncludesEmpty;
    private final List<File> files = new ArrayList<File>();

    public ProcessFilesTask(Log log, Integer bufferSize, boolean debug, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFilenames, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, String suffix, boolean nosuffix, String charset, int linebreak) {
        this.log = log;
        this.bufferSize = bufferSize;
        this.debug = debug;
        this.skipMerge = skipMerge;
        this.skipMinify = skipMinify;
        this.charset = charset;
        this.linebreak = linebreak;
        this.nosuffix = nosuffix;
        this.mergedFilename = outputFilename;
        this.suffix = suffix + ".";
        File sourceDir = new File(webappSourceDir + File.separator + inputDir);
        for (String sourceFilename : sourceFilenames) {
            this.addNewSourceFile(this.mergedFilename, sourceDir, sourceFilename);
        }
        for (File sourceInclude : this.getFilesToInclude(sourceDir, sourceIncludes, sourceExcludes)) {
            if (this.files.contains(sourceInclude)) continue;
            this.addNewSourceFile(this.mergedFilename, sourceDir, sourceInclude);
        }
        this.targetDir = new File(webappTargetDir + File.separator + outputDir);
        this.sourceFilesEmpty = sourceFilenames.isEmpty();
        this.sourceIncludesEmpty = sourceIncludes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws IOException {
        Log log = this.log;
        synchronized (log) {
            String fileType = this instanceof ProcessCSSFilesTask ? "CSS" : "JavaScript";
            this.log.info((CharSequence)("Starting " + fileType + " task:"));
            if (!this.files.isEmpty() && (this.targetDir.exists() || this.targetDir.mkdirs())) {
                if (this.skipMerge) {
                    this.log.info((CharSequence)"Skipping the merge step...");
                    for (File mergedFile : this.files) {
                        File minifiedFile = new File(this.targetDir, this.nosuffix ? mergedFile.getName() : FileUtils.basename((String)mergedFile.getName()) + this.suffix + FileUtils.getExtension((String)mergedFile.getName()));
                        this.minify(mergedFile, minifiedFile);
                    }
                } else if (this.skipMinify) {
                    File mergedFile = new File(this.targetDir, this.mergedFilename);
                    this.merge(mergedFile);
                    this.log.info((CharSequence)"Skipping the minify step...");
                } else {
                    File mergedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename + TEMP_SUFFIX : this.mergedFilename);
                    this.merge(mergedFile);
                    File minifiedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename : FileUtils.basename((String)this.mergedFilename) + this.suffix + FileUtils.getExtension((String)this.mergedFilename));
                    this.minify(mergedFile, minifiedFile);
                    if (this.nosuffix) {
                        mergedFile.deleteOnExit();
                    }
                }
                this.log.info((CharSequence)"");
            } else if (!this.sourceFilesEmpty || !this.sourceIncludesEmpty) {
                this.log.error((CharSequence)("No valid " + fileType + " source files found to process."));
            }
        }
        return null;
    }

    protected void merge(File mergedFile) throws IOException {
        try (SequenceInputStream sequence = new SequenceInputStream(new ListOfFiles(this.log, this.files, this.debug));
             FileOutputStream out = new FileOutputStream(mergedFile);
             InputStreamReader sequenceReader = new InputStreamReader((InputStream)sequence, this.charset);
             OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, this.charset);){
            this.log.info((CharSequence)("Creating the merged file [" + (this.debug ? mergedFile.getPath() : mergedFile.getName()) + "]."));
            IOUtil.copy((Reader)sequenceReader, (Writer)outWriter, (int)this.bufferSize);
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Failed to concatenate files.", (Throwable)e);
            throw e;
        }
    }

    abstract void minify(File var1, File var2) throws IOException;

    void logCompressionGains(File mergedFile, File minifiedFile) {
        try {
            File temp = File.createTempFile(minifiedFile.getName(), ".gz");
            try (FileInputStream in = new FileInputStream(minifiedFile);
                 FileOutputStream out = new FileOutputStream(temp);
                 GZIPOutputStream outGZIP = new GZIPOutputStream(out);){
                IOUtil.copy((InputStream)in, (OutputStream)outGZIP, (int)this.bufferSize);
            }
            this.log.info((CharSequence)("Uncompressed size: " + mergedFile.length() + " bytes."));
            this.log.info((CharSequence)("Compressed size: " + minifiedFile.length() + " bytes minified (" + temp.length() + " bytes gzipped)."));
            temp.deleteOnExit();
        }
        catch (IOException e) {
            this.log.debug((CharSequence)"Failed to calculate the gzipped file size.", (Throwable)e);
        }
    }

    private void addNewSourceFile(String finalFilename, File sourceDir, String sourceFilename) {
        File sourceFile = new File(sourceDir, sourceFilename);
        this.addNewSourceFile(finalFilename, sourceDir, sourceFile);
    }

    private void addNewSourceFile(String finalFilename, File sourceDir, File sourceFile) {
        if (sourceFile.exists()) {
            if (finalFilename.equalsIgnoreCase(sourceFile.getName())) {
                this.log.warn((CharSequence)("The source file [" + (this.debug ? sourceFile.getPath() : sourceFile.getName()) + "] has the same name as the final file."));
            }
            this.log.debug((CharSequence)("Adding source file [" + (this.debug ? sourceFile.getPath() : sourceFile.getName()) + "]."));
            this.files.add(sourceFile);
        } else {
            this.log.warn((CharSequence)("The source file [" + (this.debug ? sourceFile.getPath() : sourceFile.getName()) + "] does not exist."));
        }
    }

    private List<File> getFilesToInclude(File baseDir, List<String> includes, List<String> excludes) {
        ArrayList<File> includedFiles = new ArrayList<File>();
        if (includes != null && !includes.isEmpty()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(includes.toArray(new String[0]));
            scanner.setExcludes(excludes.toArray(new String[0]));
            scanner.addDefaultExcludes();
            scanner.setBasedir(baseDir);
            scanner.scan();
            for (String includedFilename : scanner.getIncludedFiles()) {
                includedFiles.add(new File(baseDir, includedFilename));
            }
            Collections.sort(includedFiles, new FilenameComparator());
        }
        return includedFiles;
    }
}

