/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config.annotation;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricsConfigurerComposite
implements MetricsConfigurer {
    private final List<MetricsConfigurer> configurers = new ArrayList<MetricsConfigurer>();

    public void addMetricsConfigurers(Collection<MetricsConfigurer> configurers) {
        if (configurers != null) {
            this.configurers.addAll(configurers);
        }
    }

    @Override
    public void configureReporters(MetricRegistry metricRegistry) {
        for (MetricsConfigurer configurer : this.configurers) {
            configurer.configureReporters(metricRegistry);
        }
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        ArrayList<MetricRegistry> candidates = new ArrayList<MetricRegistry>();
        for (MetricsConfigurer configurer : this.configurers) {
            MetricRegistry metricRegistry = configurer.getMetricRegistry();
            if (metricRegistry == null) continue;
            candidates.add(metricRegistry);
        }
        MetricRegistry instance = this.selectSingleInstance(candidates, MetricRegistry.class);
        if (instance == null) {
            instance = new MetricRegistry();
        }
        return instance;
    }

    @Override
    public HealthCheckRegistry getHealthCheckRegistry() {
        ArrayList<HealthCheckRegistry> candidates = new ArrayList<HealthCheckRegistry>();
        for (MetricsConfigurer configurer : this.configurers) {
            HealthCheckRegistry healthCheckRegistry = configurer.getHealthCheckRegistry();
            if (healthCheckRegistry == null) continue;
            candidates.add(healthCheckRegistry);
        }
        HealthCheckRegistry instance = this.selectSingleInstance(candidates, HealthCheckRegistry.class);
        if (instance == null) {
            instance = new HealthCheckRegistry();
        }
        return instance;
    }

    private <T> T selectSingleInstance(List<T> instances, Class<T> instanceType) {
        if (instances.size() > 1) {
            throw new IllegalStateException("Only one [" + instanceType + "] was expected but multiple instances were provided: " + instances);
        }
        if (instances.size() == 1) {
            return instances.get(0);
        }
        return null;
    }
}

